/**
 * Copyright (C) 2006-2011 Takanori Amano, Amax Inc., and Connectone Co.,Ltd.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; version 2
 * of the License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package jp.co.connectone.user;

import jp.co.connectone.service.IServiceInfo;

public class PasswordBasedAccountDataImpl extends AccountData implements IPasswordBasedAccountData
{

	private static final long serialVersionUID = 1L;
	protected String userID;
	protected String password;
	protected String[] params = new String[10];

	public PasswordBasedAccountDataImpl()
	{
		super();
	}

	public PasswordBasedAccountDataImpl(IUserKey uid, IServiceInfo serviceInfo)
	{
		super(uid, serviceInfo);
	}

	/* (non-Javadoc)
	 * @see jp.co.connectone.user.IPasswordBasedAccountData#getPassword()
	 */
	public String getPassword()
	{
		return password;
	}

	/* (non-Javadoc)
	 * @see jp.co.connectone.user.IPasswordBasedAccountData#setPassword(java.lang.String)
	 */
	public void setPassword(String password)
	{
		this.password = password;
	}

	/* (non-Javadoc)
	 * @see jp.co.connectone.user.IPasswordBasedAccountData#getUserID()
	 */
	public String getUserID()
	{
		return userID;
	}

	/* (non-Javadoc)
	 * @see jp.co.connectone.user.IPasswordBasedAccountData#setUserID(java.lang.String)
	 */
	public void setUserID(String userID)
	{
		this.userID = userID;
	}
	
	// for connector specific parameters, override these.
	public void setParam1(String param){
		params[0]=param;
	}
	
	public void setParam2(String param){
		params[1]=param;
	}
	
	public void setParam3(String param){
		params[2]=param;
	}
	
	public void setParam4(String param){
		params[3]=param;
	}
	
	public void setParam5(String param){
		params[4]=param;
	}
	
	public void setParam6(String param){
		params[5]=param;
	}
	
	public void setParam7(String param){
		params[6]=param;
	}
	
	public void setParam8(String param){
		params[7]=param;
	}
	
	public void setParam9(String param){
		params[8]=param;
	}
	
	public void setParam10(String param){
		params[9]=param;
	}
}
