/**
 * Copyright (C) 2006-2011 Takanori Amano, Amax Inc., and Connectone Co.,Ltd.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; version 2
 * of the License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package jp.co.connectone.store.pim;

import java.io.Serializable;
import java.util.*;

import jp.co.connectone.log.Log;

/**
 * @author amanot
 *
 */
public class MailAddress implements Serializable 
{
	private static final long serialVersionUID = 1L;
	private String rawAddress;
	public static final String COMMA_REPLACE_WORD="AMAX_REPLACE_COMMA";
	public static final String DOUBLEQUATE_REPLACE_WORD="AMAX_REPLACE_DOUBLEQUATE";
	
	public static MailAddress[] parseAddressLine(String src)
	{
Log.trace("parseAddressLine:src="+src);
		if (src==null) return new MailAddress[0];
		if (src.length()==0) return new MailAddress[0];
		String stage1[] = src.split("\"");
Log.trace("stage1="+Arrays.asList(stage1));
		String stage2[] = new String[stage1.length];
		stage2[0] = stage1[0];
		int j=0;
		for (int i=1;i<stage1.length;i++) {
			if (stage2[j].endsWith("\\")) {
				stage2[j] = stage2[j] + "\"" + stage1[i];
			}
			else {
				stage2[++j] = stage1[i];
			}
		}
Log.trace("stage2="+Arrays.asList(stage2));
		String stage3 = stage2[0];
		for (int i=1;i<stage2.length;i++) {
			if (stage2[i]==null) break;
			if ((i%2)==1) {
				stage3 = stage3 + "\"" + stage2[i].replaceAll(",",COMMA_REPLACE_WORD);
			}
			else {
				stage3 = stage3 + "\"" + stage2[i];
			}
		}
Log.trace("stage3="+stage3);
		String[] stage4 = stage3.split(",");
Log.trace("stage4="+Arrays.asList(stage4));
		MailAddress[] rc = new MailAddress[stage4.length];
		for (int i=0;i<stage4.length;i++) {
			stage4[i] = stage4[i].trim();
			if ((stage4[i].indexOf(" <")>0) && stage4[i].indexOf('"')<0) {
				stage4[i] = "\"" + stage4[i].trim();
				int idx = stage4[i].lastIndexOf('<') - 1;
				if (idx>0) {
					stage4[i] = stage4[i].substring(0,idx) + "\"" + stage4[i].substring(idx);
				}
			}
			rc[i] = new MailAddress(stage4[i].replaceAll(COMMA_REPLACE_WORD,","));
		}
Log.trace("rc="+Arrays.asList(rc));

		return rc;
	}
	
	public MailAddress(String rawAddress)
	{
		setRawAddress(rawAddress);
	}
	
	public MailAddress(String displayName,String addressPart)
	{
		setRawAddress(addressPart);
		if (displayName==null) {
			return;
		}
		if (displayName.length()<2) {
			return;
		}
		setRawAddress("\""+displayName+"\" <"+addressPart+">");
		
	}
	/**
	 * @return rawAddress ߂܂B
	 */
	public String getRawAddress() 
	{
		return rawAddress;
	}
	/**
	 * @param rawAddress rawAddress ݒB
	 */
	public void setRawAddress(String rawAddress) 
	{
		if (rawAddress==null) {
			this.rawAddress=null;
			return ;
		}
		this.rawAddress = rawAddress.trim();
		if (this.rawAddress.startsWith("<") && this.rawAddress.endsWith(">")) {
			this.rawAddress = this.rawAddress.substring(1,this.rawAddress.length()-1);
		}
		if (this.rawAddress==null) this.rawAddress = rawAddress;
	}
	
	public String getNamePart()
	{
		if (rawAddress==null) return null;
		String namePart=rawAddress;
		int idx = -1;
		if ((idx=rawAddress.indexOf(" <"))>=0) {
			namePart = rawAddress.substring(0,idx);
			namePart = namePart.replaceAll("\\\\\"",DOUBLEQUATE_REPLACE_WORD);
			namePart = namePart.replaceAll("\"","");
			namePart = namePart.replaceAll(DOUBLEQUATE_REPLACE_WORD,"\\\"");
		}
		
		return namePart;
	}
	
	public String getAddressPart()
	{
		if (rawAddress==null) return null;
		String addressPart=rawAddress;
		int idx = -1;
		if ((idx=rawAddress.indexOf("<"))>=0) {
			addressPart = rawAddress.substring(idx+1);
			idx = addressPart.indexOf(">");
			if (idx>=0) addressPart = addressPart.substring(0,idx);
		}

		
		return addressPart;
	}
	
	public String toString()
	{
		return rawAddress;
	}
}
