/**
 * Copyright (C) 2006-2011 Takanori Amano, Amax Inc., and Connectone Co.,Ltd.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; version 2
 * of the License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package jp.co.connectone.store.pim;

import jp.co.connectone.exception.*;
import jp.co.connectone.store.*;
import jp.co.connectone.user.IAccountData;

import java.util.Date;

/**
 * Interface methods to be implemented by IMAP and NOTES Implementation class.
 * 
 * @version 2.00
 * @author maneta
 */
public interface IMailStore extends IStore
{
	public static final int DEST_TYPE_DEFAULT_MAIL_FOLDER=1;
	public static final int DEST_TYPE_SENT_FOLDER=2;
	public static final int DEST_TYPE_DRAFT_FOLDER=3;
	public static final int DEST_TYPE_TRASH_FOLDER=4;
	public static final int DEST_TYPE_JUNK_FOLDER=5;
	public FolderMetadata[] getMailFolders(IAccountData acc, ISearchDestination dest) throws StoreNotFound, NoSuchRights, ServerDown, IncorrectStore, DataNotFound, IncorrectData, HandleException;
	public IMailDTO[] getHeaders(IAccountData acc, ISearchDestination dest) throws StoreNotFound, ServerDown, NoSuchRights, IncorrectStore, DataNotFound, IncorrectData, HandleException;
	public IMailDTO[] getHeadersByDate(IAccountData acc, ISearchDestination dest, Date lastDate) throws StoreNotFound, ServerDown, NoSuchRights, IncorrectStore, DataNotFound, IncorrectData, HandleException;
	public IObjectIndex[] getUIDLs(IAccountData acc, ISearchDestination dest) throws StoreNotFound, ServerDown, NoSuchRights, IncorrectStore, DataNotFound, IncorrectData, HandleException;
	public IObjectIndex[] getUIDLsByDate(IAccountData acc, ISearchDestination dest, Date lastDate) throws StoreNotFound, ServerDown, NoSuchRights, IncorrectStore, DataNotFound, IncorrectData, HandleException;
	public IMailDTO getMail(IAccountData acc, ISearchDestination dest, IObjectIndex oid) throws StoreNotFound, ServerDown, NoSuchRights, IncorrectStore, DataNotFound, IncorrectData, HandleException;
	public IMailDTO[] getMailsByDate(IAccountData acc, ISearchDestination dest, Date dateObj) throws StoreNotFound, NoSuchRights, ServerDown, DataNotFound, IncorrectStore, IncorrectData, HandleException;
	public IMailDTO[] getSentMails(IAccountData acc) throws ServerDown, HandleException;
	public IMailDTO[] getSentMailsByDate(IAccountData acc, Date dateObj) throws ServerDown, HandleException;
	public IObjectIndex sendMail(IAccountData acc, IMailDTO mailDTOobj) throws NoSuchRights, ServerDown, IncorrectData, HandleException;
	public void deleteMail(IAccountData acc, IObjectIndex oid) throws ServerDown, NoSuchRights, DataNotFound, IncorrectData, HandleException;

}
