/**
 * Copyright (C) 2006-2011 Takanori Amano, Amax Inc., and Connectone Co.,Ltd.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; version 2
 * of the License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package jp.co.connectone.store.client;

import java.io.*;

import javax.activation.DataSource;

import jp.co.connectone.store.pim.AttachmentDTO;

/**
 * @author amanot
 *
 */
public class AttachmentDataSource implements DataSource {
	protected AttachmentDTO data;

	public AttachmentDataSource(AttachmentDTO source)
	{
		data = source;
	}
	/* ( Javadoc)
	 * @see javax.activation.DataSource#getContentType()
	 */
	public String getContentType() {
		return "application/octet-stream;";
	}

	/* ( Javadoc)
	 * @see javax.activation.DataSource#getInputStream()
	 */
	public InputStream getInputStream() throws IOException {
		byte[] src = data.getFileBody();
		ByteArrayInputStream s = new ByteArrayInputStream(src);
		return s;
	}

	/* ( Javadoc)
	 * @see javax.activation.DataSource#getName()
	 */
	public String getName() {
		if (data == null) return null;
		return data.getFileName();
	}

	/* ( Javadoc)
	 * @see javax.activation.DataSource#getOutputStream()
	 */
	public OutputStream getOutputStream() throws IOException {
		return null;
	}

}
