/**
 * Copyright (C) 2006-2011 Takanori Amano, Amax Inc., and Connectone Co.,Ltd.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; version 2
 * of the License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package jp.co.connectone.store;

import java.util.HashMap;

/**
 * @author amanot
 */
public class FolderMetadata extends BasicRecordObject
{
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	private IFolderIndex oid;
	private String folderName;
	/**
	 * @return folderName ߂܂B
	 */
	public String getFolderName()
	{
		return folderName;
	}

	/**
	 * @param folderName ݒ肷 folderNameB
	 */
	public void setFolderName(String folderName)
	{
		this.folderName = folderName;
	}

	/* ( Javadoc)
	 * @see jp.co.connectone.store.IRecordObject#getFieldSet()
	 */
	public HashMap<String,Object> getFieldSet()
	{
		HashMap<String,Object> rc = new HashMap<String,Object>();
		rc.put("folderName",folderName);
		return rc;
	}

	/* ( Javadoc)
	 * @see jp.co.connectone.store.IRecordObject#getoid()
	 */
	public IObjectIndex getOid()
	{
		return oid;
	}

	/* ( Javadoc)
	 * @see jp.co.connectone.store.IRecordObject#isNew()
	 */
	public boolean isNew()
	{
		return false;
	}

	/* ( Javadoc)
	 * @see jp.co.connectone.store.IRecordObject#setFieldSet(java.util.HashMap)
	 */
	public void setFieldSet(HashMap<String,Object> h)
	{
		if (h==null) {
			throw new NullPointerException("setFieldSet HashMap must not be null.");
		}
		Object o = h.get("folderName");
		if (o instanceof String) {
			folderName = (String)o;
		}
	}

	/**
	 * @param oid ݒ肷 oidB
	 */
	public void setOid(IObjectIndex oid)
	{
		this.oid = (IFolderIndex)oid;
	}
}
