/**
 * Copyright (C) 2006-2011 Takanori Amano, Amax Inc., and Connectone Co.,Ltd.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; version 2
 * of the License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package jp.co.connectone.service;

import java.util.*;
import java.util.Map.Entry;

import jp.co.connectone.common.*;
import jp.co.connectone.exception.*;
import jp.co.connectone.log.Log;

public class PropertyBasedServiceInfoRawdataProvider implements IServiceInfoRawdataProvider
{
	protected Properties prop;

	protected PropertyBasedServiceInfoRawdataProvider(Properties src)
	{
		if (src == null) throw new NullPointerException("src must not be null");
		prop = src;
	}
	
	public static IServiceInfoRawdataProvider getInstance(String domainName) throws Exception
	{
		Properties src=null;
		Properties initArgs = PropertyHandlerBaseImpl.getInstance().getProperties("jp.co.connectone.service."+domainName);
		IPropertyHandler handler = PropertyHandlerBaseImpl.getInstance(initArgs.getProperty("PropertyHandler"));
		handler.setInitArgs(initArgs);
		try {
			src = handler.getProperties("jp.co.connectone.service.PropertyBasedServiceInfoRawdataProvider."+domainName);
		}
		catch (DataNotFound dnf) {
			throw dnf;
		}
		catch (Exception e) {
			Log.error("",e);
		}
		return new PropertyBasedServiceInfoRawdataProvider(src);
	}

	public IServiceInfoRawData getServiceInfoRawData(String serviceCode) throws HandleException
	{
		SimpleServiceInfoRawData data = new SimpleServiceInfoRawData();
		HashMap<String,Object> h = new HashMap<String,Object>();
		h.put("serviceCode", serviceCode);

		Iterator<Entry<Object, Object>> it = prop.entrySet().iterator();
		while (it.hasNext()) {
			Entry<Object, Object> o = it.next();
			String name = (String)o.getKey();
			if (name.indexOf(serviceCode)<0) continue;
			Object value = o.getValue();
			h.put(name.substring(serviceCode.length()+1), value);
		}
		try {
			data.setFieldSet(h);
		}
		catch (IllegalAccessException iae) {
			Log.error("IllegalAccessException on SimpleServiceInfoRawData.setFieldSet(HashMap).",iae);
			throw new HandleException(iae.getMessage());
		}
		
		return data;
	}

	public String getStoreClientName(String serviceCode) throws HandleException
	{
		return prop.getProperty(serviceCode+".store");
	}
	
	public String[] getServieCodeList() throws HandleException
	{
		HashSet<String> hash=new HashSet<String>();
		Iterator<Entry<Object, Object>> it = prop.entrySet().iterator();
		while (it.hasNext()) {
			Entry<Object, Object> o = (Entry<Object, Object>)it.next();
			String name = (String)o.getKey();
			String serviceCode = name.substring(0,name.indexOf('.'));
			hash.add(serviceCode);
		}
		return (String[])hash.toArray(new String[0]);
	}

}
