/**
 * Copyright (C) 2006-2011 Takanori Amano, Amax Inc., and Connectone Co.,Ltd.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; version 2
 * of the License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package jp.co.connectone.common;

import java.util.*;

import jp.co.connectone.store.pim.MailAddress;

public class MailTool
{
    public static final String ptn = "^[\\x01-\\x7F]+@(([-a-z0-9]+\\.)*[a-z]+|\\[\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\])";
    private boolean allowNullOrBlankMailAddress = false;

    public boolean isAllowNullOrBlankMailAddress()
    {
	return allowNullOrBlankMailAddress;
    }

    public void setAllowNullOrBlankMailAddress(boolean allowNullOrBlankMailAddress)
    {
	this.allowNullOrBlankMailAddress = allowNullOrBlankMailAddress;
    }

    public String[] checkMailAddressesString(String[] addresses)
    {
	ArrayList<MailAddress> addrs = new ArrayList<MailAddress>();
	for (String addr : addresses) {
	    MailAddress address = new MailAddress(addr);
	    addrs.add(address);
	}
	List<MailAddress> rcl = checkMailAddresses(addrs);
	if (rcl.equals(addrs)) {
	    return addresses;
	}
	ArrayList<String> rc = new ArrayList<String>();
	for (int i = 0; i < rcl.size(); i++) {
	    MailAddress addr = rcl.get(i);
	    int idx = addrs.indexOf(addr);
	    if (idx>=0) {
		rc.add(addresses[idx]);
	    }
	}
	return rc.toArray(new String[0]);
    }

    public List<MailAddress> checkMailAddresses(List<MailAddress> addresses)
    {
	if (addresses == null) return null;
	if (addresses.size() == 0) return addresses;
	ArrayList<MailAddress> rc = new ArrayList<MailAddress>();
	rc.addAll(addresses);
	for (MailAddress addr : addresses) {
	    if (checkAddressFormat(addr) != true) {
		rc.remove(addr);
	    }
	}

	return rc;
    }

    public boolean checkAddressFormat(MailAddress address)
    {
	if (address == null) return allowNullOrBlankMailAddress;
	if ("".equals(address)) return allowNullOrBlankMailAddress;
	String addr = address.getAddressPart();
	if (addr == null) return allowNullOrBlankMailAddress;
	if ("".equals(addr)) return allowNullOrBlankMailAddress;

	return addr.matches(ptn);
    }

}
