/**
 * Copyright (C) 2006-2011 Takanori Amano, Amax Inc., and Connectone Co.,Ltd.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; version 2
 * of the License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package jp.co.connectone.webapps.helpers;
import jp.co.connectone.log.Log;
import jregex.*;

/**
 * @author amanot
 *
 */
public class WebParserAggregationBase implements Substitution {
	protected int bodyLength=this.DEFAULT_BODY_LENGTH;
	protected int currentPage=0;
	
	public final int DEFAULT_BODY_LENGTH = 3000;

	public final int MAIL_TYPE = 2;
	public final int MAIL_TYPE_WITH_BRAC = 1;
	public final int MAIL_TYPE_WITH_BRAC_NAME = 16;
	public final int URL_TYPE = 3;
	public final int PHONE_TYPE = 4;
	
	public final String EMAIL_PATTERN_GROUP="([a-zA-Z\\-_0-9./]{1,}[@][a-zA-Z.\\-_0-9]{1,})";
	// &lt; is given instead of < and &gt; is given instead of > 
	public final String EMAIL_WITH_BRAC_PATTERN_GROUP="(&lt;[ ]{0,}[a-zA-Z\\-_0-9./]{1,}[@][a-zA-Z.\\-_0-9]{1,}[ ]{0,}&gt;)";
	////////////////////////////////////////////
	// Actual pattern ["]{1,1}[^"]{1,}["]{1,1}[ ]{0,}[<]{1,1}[ ]{0,}[a-zA-Z\\-_0-9.]{1,}[@][a-zA-Z.\\-_0-9]{1,}[ ]{0,}[>]{1,1}
	public final String EMAIL_WITH_BRAC_NAME_PATTERN_GROUP="([\"]{1,1}[^\"]{1,}[\"]{1,1}[ ]{0,}[<]{1,1}[ ]{0,}[a-zA-Z\\-_0-9./]{1,}[@][a-zA-Z.\\-_0-9]{1,}[ ]{0,}[>]{1,1})";
	//////////////////////////////////////////////
	public final String URL_PATTERN_GROUP="(http://[a-zA-Z0-9\\-_~?=%#:*\\&]{1,}[.][a-zA-Z0-9\\-_~?=%#:*\\&/.;]{1,}|HTTP://[a-zA-Z0-9\\-_~?=%#:*\\&]{1,}[.][a-zA-Z0-9\\-_~?=%#:*\\&/.;]{1,}|https://[a-zA-Z0-9\\-_~?=%#:*\\&]{1,}[.][a-zA-Z0-9\\-_~?=%#:*\\&/.;]{1,}|HTTPS://[a-zA-Z0-9\\-_~?=%#:*\\&]{1,}[.][a-zA-Z0-9\\-_~?=%#:*\\&/.;]{1,}|ftp://[a-zA-Z0-9\\-_~?=%#:*\\&\\&]{1,}[.][a-zA-Z0-9\\-_~?=%#:*\\&/.;]{1,}|www[.][a-zA-Z0-9\\-_~?=%#:*\\&]{1,}[.][a-zA-Z0-9\\-_~?=%#:*\\&/.;]{1,}|WWW[.][a-zA-Z0-9\\-_~?=%#:*\\&]{1,}[.][a-zA-Z0-9\\-_~?=%#:*\\&\\&/.;]{1,})";
	public final String PHONE_PATTERN_GROUP="([0-9\\-]{9,})";

	/*
	public final String FINAL_PATTERN_GROUP=
			EMAIL_WITH_BRAC_NAME_PATTERN_GROUP+
		"|"+EMAIL_WITH_BRAC_PATTERN_GROUP+
		"|"+EMAIL_PATTERN_GROUP+
		"|"+URL_PATTERN_GROUP+
		"|"+PHONE_PATTERN_GROUP;
		*/
	public final String FINAL_PATTERN_GROUP= EMAIL_WITH_BRAC_PATTERN_GROUP+"|"+EMAIL_PATTERN_GROUP+"|"+URL_PATTERN_GROUP+"|"+PHONE_PATTERN_GROUP;

	public String pagingString(String src)
	{
		String rc = src;
Log.trace("rc="+rc);
		int len = rc.length();
		if (bodyLength==0) return rc;
Log.debug("bodyLength="+bodyLength+",currentPage="+currentPage);
		int startIndex = currentPage * bodyLength;
		if (startIndex>=len) return "";
Log.debug("startIndex="+startIndex);
		int endIndex = (currentPage+1) * bodyLength;
		if (endIndex > len) endIndex = len;
Log.debug("endIndex="+endIndex);
		return rc. substring(startIndex,endIndex);
	}
	
	public int getLastPage(String srcString)
	{
		if (srcString==null) return 0;
		if (bodyLength==0) return 0;
		int lastPage = (srcString.length()-1)/bodyLength;
		return lastPage;
	}
	/**
	 * @return bodyLength ߂܂B
	 */
	public int getBodyLength() {
		return bodyLength;
	}
	/**
	 * @param bodyLength bodyLength ݒB
	 */
	public void setBodyLength(int bodyLength) {
		if (bodyLength==0) this.bodyLength = this.DEFAULT_BODY_LENGTH; 
		else this.bodyLength = bodyLength;
	}

    protected String formatBody(String body)
    {
		/** Create the pattern for link urls **/
		/** \\ is the escape sequence for - and & **/
		jregex.Pattern linkPattern=new jregex.Pattern(FINAL_PATTERN_GROUP);
		jregex.Replacer r=linkPattern.replacer(this);
		String linkResultFinal=r.replace(body);
Log.trace("formatted Body="+linkResultFinal);
		return linkResultFinal;

		
		
    }
    
    /**
     * o^ꂽe^OGXP[v܂B
     * @param body
     * @return
     */
    protected String escapeTags(String src) {
    	
    	jregex.Pattern linkPatternlt=new jregex.Pattern("<");
    	jregex.Pattern linkPatterngt=new jregex.Pattern(">");
    	jregex.Pattern linkPatternamp=new jregex.Pattern("&");
    	jregex.Replacer rlt=linkPatternlt.replacer("&lt;");
    	jregex.Replacer rgt=linkPatterngt.replacer("&gt;");
    	jregex.Replacer amp = linkPatternamp.replacer("&amp;");
    	String linkResultFinal=rgt.replace(rlt.replace(amp.replace(src)));
    	Log.trace("escaped Body="+linkResultFinal);
    	
    	return linkResultFinal;
    	
    }
    
	/** Function to replace a given string with the replacer string **/
	public String replace(String str, String pattern, String replace) 
	{
	   int s = 0;
	   int e = 0;
	   StringBuffer result = new StringBuffer();
   
	   while ((e = str.indexOf(pattern, s)) >= 0) 
	   {
		   result.append(str.substring(s, e));
		   result.append(replace);
		   s = e+pattern.length();
	   }
	   result.append(str.substring(s));
	   return result.toString();
   }
	/** Function to replace the words which matched the given pattern with the specified replacer after
	undergoing some conditional checks **/
	public void appendSubstitution(MatchResult match,TextBuffer sb) 
	{
		try
		{
			// If Match is of Mail Group - eg : xxx@yyy.com
			if (match.isCaptured(MAIL_TYPE))
			{
Log.trace("MAIL_TYPE ");
				String mailStr = match.group(MAIL_TYPE);
				if(mailStr == null || mailStr.equals(""))
					return;
				else
				{
					sb.append("<a href=\"mailto:" + mailStr + "\">" + mailStr + "</a>");
				}

			}
			// If Match is of Mail with bracket Group - eg : <xxx@yyy.com>
			
			else if (match.isCaptured(MAIL_TYPE_WITH_BRAC))
			{
Log.trace("MAIL_TYPE with Bra");
				String mailStr=match.group(MAIL_TYPE_WITH_BRAC);
Log.trace("Mail String " + mailStr);
				String mailId="";
				int startPoint=0,endPoint=0;
				
				if (mailStr == null || mailStr.equals(""))
					return;
				else
				{
					startPoint=mailStr.lastIndexOf("&lt;")+4;
					endPoint=mailStr.lastIndexOf("&gt;");
					mailId=mailStr.substring(startPoint,endPoint);
					sb.append("<a href=\"mailto:" + mailId + "\">" + mailStr + "</a>");
				}
Log.trace("done.");
			}
			/*
			// If Match is of Mail with bracket and name Group - eg : "zzz" <xxx@yyy.com>
			else if (match.isCaptured(MAIL_TYPE_WITH_BRAC_NAME))
			{
				Log.write("MAIL_TYPE with Bra Name" ,3);
				String mailStr=match.group(MAIL_TYPE_WITH_BRAC_NAME);
				String mailId="";
				int startPoint=0,endPoint=0;
				
				if (mailStr == null || mailStr.equals(""))
					return;
				else
				{
					startPoint=mailStr.lastIndexOf("<");
					endPoint=mailStr.lastIndexOf(">");
					mailId=mailStr.substring(startPoint,endPoint-1);
					sb.append("<a href=\"mailto:" + mailId + "\">" + mailStr + "</a>");
				}
			}
			*/
			// If Match is of Phone group
			else if (match.isCaptured(PHONE_TYPE))
			{
Log.trace("Phony with Phone");
				String phoneno = match.group(PHONE_TYPE);
				if(phoneno == null || phoneno.equals("")  )
					return;
				/** Replacing - with "" inorder to count actual number of digits. Becuase minimum digits should be 9 and any number of hyphens can
				occur is phone no **/
				String rphoneno = replace(phoneno,"-","");

				/*if((phoneno != null) && (phoneno.startsWith("0")) && (phoneno.indexOf("--") == -1) && (rphoneno.length() > 8))		
					sb.append("]]><a href=\"tel:" + rphoneno + "\"><![CDATA[" + phoneno + "]]></a><![CDATA[");
				else
					sb.append(phoneno);*/
				if((phoneno != null) && (phoneno.startsWith("0")) && (phoneno.indexOf("--") == -1) && (rphoneno.length() > 8))		
					sb.append("<a href=\"tel:" + rphoneno + "\">" + phoneno + "</a>");
				else
					sb.append(phoneno);
Log.trace("done.");
			}
			// If match is of URL group
			else if (match.isCaptured(URL_TYPE))
			{
Log.trace("Url Type ");
				String url=match.group(URL_TYPE);			
				String urlLower=url.toLowerCase();
				if(url == null || url.equals("")  )
					return;
				
				/** replace & with &amp; as xml will throw error for &**/
				/* To be changed by chandy */
				//String urlNoCdata = replace(url, "&", "&amp;"); // Old code
				String urlNoCdata = replace(url, "&amp;", "&");
				/** if pattern is www.eximsoft.com then change it to <a href="http://www.eximsoft.com>www.eximsoft.com</a> **/

				/*if((url != null) && ( (urlLower.startsWith("http://")) || (urlLower.startsWith("ftp://")) || (urlLower.startsWith("https://")) ) )
					dest.append("]]><a href=\"" + urlNoCdata + "\"><![CDATA[" + url + "]]></a><![CDATA[");
				else
					dest.append("]]><a href=\"http://" + urlNoCdata + "\"><![CDATA[" + url + "]]></a><![CDATA[");*/
					
				if((url != null) && ( (urlLower.startsWith("http://")) || (urlLower.startsWith("ftp://")) || (urlLower.startsWith("https://")) ) )
					//sb.append("<a href=\"" + urlNoCdata + "\">" + url + "</a>"); // Old code
                    sb.append("<a href=\"" + url + "\">" + urlNoCdata + "</a>");
				else
					//sb.append("<a href=\"http://" + urlNoCdata + "\">" + url + "</a>"); // Old code
					sb.append("<a href=\"http://" + url + "\">" + urlNoCdata + "</a>");
Log.trace("done.");
			}		
		}
		catch(Exception ex)
		{
Log.trace("Exc "+ex);
		}
	}
	
	public int getNextID()
	{
		return this.hashCode();
	}
    
	/**
	 * @return currentPage ߂܂B
	 */
	public int getCurrentPage() {
		return currentPage;
	}

	
	public int getPrevPage()
	{
		return currentPage-1;
	}
	
	public int getNextPage()
	{
		return currentPage+1;
	}
	/**
	 * @param currentPage currentPage ݒB
	 */
	public void setCurrentPage(int currentPage) {
		this.currentPage = currentPage;
	}

}
