/**
 * Copyright (C) 2006-2011 Takanori Amano, Amax Inc., and Connectone Co.,Ltd.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; version 2
 * of the License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package jp.co.connectone.webapps.helpers;

import java.net.URLEncoder;
import java.util.*;
import java.text.*;

import jp.co.connectone.log.Log;
import jp.co.connectone.store.IRecordObject;
import jp.co.connectone.store.pim.*;

/**
 * @author amanot
 * 
 */
public class WebMailParseHelper extends MailParseHelper implements IRecordObject
{
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	protected String formattedBody;

	protected String originalBody = "";// used only on replying/forwarding mail
	
	protected boolean read = false;

	public IMailDTOComparator getComparator(int sortKey,boolean isReverce)
	{
		return new IMailDTOComparator(sortKey,isReverce);
	}

	
	/* ( Javadoc)
	 * @see jp.co.connectone.store.IRecordObject#getFieldSet()
	 */
	public HashMap<String,Object> getFieldSet() throws Exception
	{
		return mMail.getFieldSet();
	}


	/* ( Javadoc)
	 * @see jp.co.connectone.store.IRecordObject#isNew()
	 */
	public boolean isNew()
	{
		return mMail.isNew();
	}


	/* ( Javadoc)
	 * @see jp.co.connectone.store.IRecordObject#setFieldSet(java.util.HashMap)
	 */
	public void setFieldSet(HashMap<String,Object> h) throws IllegalAccessException
	{
		mMail.setFieldSet(h);
	}


	/**
	 * @return originalBody ߂܂B
	 */
	public String getOriginalBody()
	{
		return originalBody;
	}

	/* override original helper */
	public void setMailDTO(IMailDTO arg0)
	{
		super.setMailDTO(arg0);
		formattedBody = super.getBodyHtml();
		formattedBody = extention.formatBody(super.getBodyHtml());
	}

	public void escapeTags() {
		mMail.setBody(extention.escapeTags(mMail.getBody()));
	}

	public String getBodyHtml()
	{
		// String rc = formattedBody;
		String rc = super.getBodyHtml();
		if (rc == null) return rc;
		rc = extention.pagingString(rc);
		rc = extention.escapeTags(rc);
		rc = extention.formatBody(rc);
		Log.trace("bodyHTML=" + rc);
		return rc;
	}

	public String getHtmlSubject()
	{
		String rc = super.getSubject();
		if (rc == null) return "";
		rc = rc.replace('@', ' ');// for check SpXy[X
		rc = rc.trim();
		if (rc.length() == 0) return "";
		return super.getSubject();// return oroginal string
	}

	public Collection<MailAddress> getCCCollection()
	{
		Log.trace("getCCCollection");
		Collection<MailAddress> rc = new ArrayList<MailAddress>();
		if (super.getCC() == null) return rc;
		Collection<MailAddress> org = super.getCCCollection();
		Log.trace("original=" + org);
		if (org == null) return rc;
		Log.trace(org.size() + "");
		try {
			Iterator<MailAddress> it = super.getCCCollection().iterator();
			while (it.hasNext()) {
				MailAddress email = it.next();
				Log.trace("email-org:" + email);
				rc.add(getEmailId(email));
			}
		}
		catch (NullPointerException e) {
		}
		;
		return rc;
	}

	public Collection<MailAddress> getBCCCollection()
	{
		Log.trace("getBCCCollection");
		Collection<MailAddress> rc = new ArrayList<MailAddress>();
		if (super.getBCC() == null) return rc;
		Collection<MailAddress> org = super.getBCCCollection();
		Log.trace("original=" + org);
		if (org == null) return rc;
		Log.trace(org.size() + "");
		try {
			Iterator<MailAddress> it = super.getBCCCollection().iterator();
			while (it.hasNext()) {
				MailAddress email = it.next();
				Log.trace("email-org:" + email);
				rc.add(getEmailId(email));
			}
		}
		catch (NullPointerException e) {
		}
		;
		return rc;
	}

	public Collection<MailAddress> getTOCollection()
	{
		Log.trace("getTOCollection");
		Collection<MailAddress> rc = new ArrayList<MailAddress>();
		if (super.getTO() == null) return rc;
		Collection<MailAddress> org = super.getTOCollection();
		Log.trace("original=" + org);
		if (org == null) return rc;
		Log.trace(org.size() + "");
		try {
			Iterator<MailAddress> it = org.iterator();
			while (it.hasNext()) {
				MailAddress email = it.next();
				Log.trace("email-org:" + email);
				rc.add(getEmailId(email));
			}
		}
		catch (NullPointerException e) {
		}
		;
		return rc;
	}

	public MailAddress getFrom()
	{
		Log.trace("getFrom");
		Log.trace("email-org:" + super.getFrom());
		return getEmailId(super.getFrom());
	}

	public MailAddress getReplyTo()
	{
		Log.trace("getReplyTo");
		Log.trace("email-org:" + super.getReplyTo());
		return getEmailId(super.getReplyTo());
	}

	public Collection<AttachmentDTO> getAttachmentCollection()
	{
		Collection<AttachmentDTO> rc = new ArrayList<AttachmentDTO>();
		try {
			rc.addAll(super.getAttachmentCollection());
		}
		catch (NullPointerException e) {
		}
		;
		return rc;
	}

	/*
	 * ( Javadoc)
	 * 
	 * @see jp.co.connectone.store.client.MailParseHelper#getNumberOfAttachments()
	 */
	public int getNumberOfAttachments()
	{
		return mMail.getNumberOfAttachments();
	}

	/* added module */
	protected WebParserAggregationBase extention = new WebParserAggregationBase();

	public String getEscapedId()
	{
		String rc = getUIDL();
		try {
			rc = URLEncoder.encode(getUIDL(), "UTF-8");
		}
		catch (Exception e) {
		}
		;
		return rc;
	}

	/**
	 * @return bodyLength ߂܂B
	 */
	public int getBodyLength()
	{
		return extention.getBodyLength();
	}

	/**
	 * @param bodyLength
	 *            bodyLength ݒB
	 */
	public void setBodyLength(int bodyLength)
	{
		extention.setBodyLength(bodyLength);
	}

	/**
	 * @return currentPage ߂܂B
	 */
	public int getCurrentPage()
	{
		return extention.getCurrentPage();
	}

	public int getPrevPage()
	{
		return extention.getPrevPage();
	}

	public int getNextPage()
	{
		return extention.getNextPage();
	}

	public int getLastPage()
	{
		return extention.getLastPage(super.getBodyHtml());
	}

	/**
	 * @param currentPage
	 *            currentPage ݒB
	 */
	public void setCurrentPage(int currentPage)
	{
		extention.setCurrentPage(currentPage);
	}

	public WebMailParseHelper(MailParseHelper org)
	{
		super(org);
		String body = org.getBody();
		if (body == null) body = "";
		body = super.getBodyHtml();
		if (body == null) body = "";
		formattedBody = extention.formatBody(body);
		Log.debug("Number of Attachements on WebMailParseHelper:" + this.getNumberOfAttachments());

	}

	public static WebMailParseHelper getNewMail()
	{
		Log.trace("WebMailParseHelper::getNewMail called");
		HeaderDTO newHeader = new HeaderDTO();
		IMailDTO newMail = new BasicMailDTO();
		newMail.setHeaderDTO(newHeader);
		return new WebMailParseHelper(new MailParseHelper(newMail));
	}

	public static WebMailParseHelper getReplyMail(MailParseHelper org)
	{
		Log.trace("WebMailParseHelper::getReplyMail called,calling getNewMail()");
		WebMailParseHelper mail = getNewMail();
		HeaderDTO head = mail.getMHeader();
		head.setHeaderSubject("Re:" + org.getSubject());
		MailAddress replyTo = org.getReplyTo();
		if ((replyTo == null) || ("".equals(replyTo.toString()))) {
			replyTo = org.getFrom();
		}
		String firstTOAddress = replyTo.getAddressPart();
		String toAddresses[] = { firstTOAddress };
		head.setHeaderTo(toAddresses);
		
		String body = getOriginalHeader(head, org);

		// mail.getMail().setBody(body);
		mail.originalBody = body;

		// mail.getMail().setAttachments(org.getAttachments());

		return mail;
	}

	public static WebMailParseHelper getReplyAllMail(MailParseHelper org)
	{
		Log.trace("WebMailParseHelper::getReplyAllMail called,calling getNewMail()");
		WebMailParseHelper mail = getNewMail();
		HeaderDTO head = mail.getMHeader();
		head.setHeaderSubject("Re:" + org.getSubject());
		MailAddress replyAddress = org.getReplyTo();
		String firstTOAddress = null;

		String commonUserName = null;
		
		try {
			HashMap<String,Object> h = org.getFieldSet();
			commonUserName = (String)h.get("CommonUserName");
		} catch (Exception e) {
			Log.error("failed getting FieldSet ",e);
		}
		if (replyAddress != null) {
			firstTOAddress = org.getReplyTo().getAddressPart();
		}
		if (firstTOAddress == null) {
			MailAddress fromAddress = org.getFrom();
			if (fromAddress != null) {
				firstTOAddress = fromAddress.getAddressPart();
			}
		}
		else if (firstTOAddress.length() == 0) {
			MailAddress fromAddress = org.getFrom();
			if (fromAddress != null) {
				firstTOAddress = fromAddress.getAddressPart();
			}
		}
		MailAddress toAddresses[] = org.getTO();
		String toAddresses2[] = null;
		ArrayList<String> toArray = new ArrayList<String>();
		toArray.add(firstTOAddress);
		if (toAddresses != null) {
			String address = "";
			for (int i = 0; i < toAddresses.length; i++) {
				address = toAddresses[i].getAddressPart();
				if (commonUserName != null) {
					if (!address.startsWith(commonUserName)){
						toArray.add(address);
					}
				} else {
					toArray.add(address);
				}
			}
		}
		toAddresses2 = (String[]) toArray.toArray(new String[]{});

		head.setHeaderTo(toAddresses2);
		MailAddress ccAddresses[] = org.getCC();
		String[] ccAddresses2 = null;
		if (ccAddresses != null) {
			ArrayList<String> ccArray = new ArrayList<String>();
			String address = "";
			for (int i = 0; i < ccAddresses.length; i++) {
				address = ccAddresses[i].getAddressPart();
				if (commonUserName != null) {
					if (!address.startsWith(commonUserName)){
						ccArray.add(address);
					}
				} else {
					ccArray.add(address);
				}
			}
			ccAddresses2 = (String[])ccArray.toArray(new String[]{});
			head.setHeaderCC(ccAddresses2);
		}

		// String body = "\n> " + org.getBody().replaceAll("\n", "\n> ");
		String body = getOriginalHeader(head, org);
		
		// mail.getMail().setBody(body);
		mail.originalBody = body;

		// mail.getMail().setAttachments(org.getAttachments());

		return mail;
	}

	public static WebMailParseHelper getForwardMail(MailParseHelper org)
	{
		Log.trace("WebMailParseHelper::getForwardMail called,calling getNewMail()");
		WebMailParseHelper mail = getNewMail();
		HeaderDTO head = mail.getMHeader();
		head.setHeaderSubject("Fw:" + org.getSubject());
		head.setOid(org.getOid());

		//String body = "\n> " + org.getBody().replaceAll("\n", "\n> ");
		// mail.getMail().setBody(body);
		String body = getOriginalHeader(head, org);
		mail.originalBody = body;

		mail.getMail().setAttachments(org.getAttachments());

		return mail;
	}

	private MailAddress getEmailId(MailAddress eMailAddress)
	{
		Log.trace("getEmailId(): Entering Method ");
		if (eMailAddress == null) return new MailAddress("");
		String eMailId = eMailAddress.getRawAddress();
		if (eMailId == null) return new MailAddress("");
		String notesId = "";
		// String fnln=null;
		// String nDomain=null;
		String internetId = eMailId;
		Log.trace(" getEmailId(): E-Mail Id to process " + eMailId);

		// If the author name starts with CN= process the name and if lotus
		// notes id check for "/"
		if (eMailId.startsWith("CN=")) {
			int atIndx = eMailId.indexOf('@');
			if (atIndx != -1) eMailId = eMailId.substring(0, atIndx);
			// Parse for "/"
			StringTokenizer sParser = new StringTokenizer(eMailId, "/");
			String sPart = "";
			// Rebuild the Id
			while (sParser.hasMoreTokens()) {
				sPart = sParser.nextToken();
				// if (sPart.indexOf("CN=") != -1) fnln = sPart;
				// if (sPart.indexOf("O=") != -1) nDomain = sPart;
				sPart = sPart.substring(sPart.indexOf("=") + 1);
				if (sParser.hasMoreTokens()) {
					notesId = notesId + sPart + "/";
				}
				else {
					// internet name or alias
					notesId = notesId + sPart;
				}
			}
			internetId = notesId;
		}
		eMailAddress.setRawAddress(internetId);
		Log.trace(" getEmailId(): before leaving internet Id:   " + eMailAddress);
		return eMailAddress;

	}
	/* 
	 * Format the original message for "Reply", "Forward", "Reply-ALL".  
	 * @author A.Shimoda
	 * @date 16/05/2007
	 */
	private static String getOriginalHeader(final HeaderDTO head, final MailParseHelper org){

		/* Set the date format. */
		DateFormat dfm = new SimpleDateFormat("EEEEE, MMMMM dd, yyyy hh:mm a", Locale.ENGLISH);

		String headMessage = "> -----Original Message-----\n" ;
		String from = "> From: " + org.getFrom() +  "\n";
		String subject = "> Subject: " + org.getSubject() + "\n";
		String sent = "> Sent: " + dfm.format(org.getSentDate()) + "\n";
		
	   
		/* 
		 * Format To: addresses. 
		 * Ex.  "> To: test1@test.com; test2@test.com" 
		 */  
		final MailAddress[] toAddrs = org.getTO(); 
		StringBuffer to = new StringBuffer();
		if(toAddrs != null && toAddrs.length > 0) {
			to.append("> To: ");
			to.append(toAddrs[0]);
			for(int i=1; i<toAddrs.length; i++) {
				to.append("; ");
				to.append(toAddrs[i]);
			}
			to.append("\n");
		}

		/*
		 * Format Cc: addresses.
		 * Don't display CC: if not exists.
		 */
		final MailAddress[] ccAddrs = org.getCC();
		StringBuffer cc = new StringBuffer();
		
		if(ccAddrs != null && ccAddrs.length > 0) {
			cc.append("> Cc: ");
			cc.append(ccAddrs[0]);
			for(int i=1; i<ccAddrs.length; i++) {
				cc.append("; ");
				cc.append(ccAddrs[i]);
			}
			cc.append("\n");
		}
		
		String body = "> " + org.getBody().replaceAll("\n", "\n> ");
		
		
		return 
			"\n\n" +
			headMessage + from + sent + to + cc + subject +
			">\n" +
			body;

	}
	
	public void setTO(String[] to)
	{
		mHeader.setHeaderTo(to);
	}

	public void setCC(String[] cc)
	{
		mHeader.setHeaderCC(cc);
	}

	public void setBCC(String[] bcc)
	{
		mHeader.setHeaderBCC(bcc);
	}

	public void setSubject(String subject)
	{
		mHeader.setHeaderSubject(subject);
	}

	public void setFrom(String from)
	{
		mHeader.setHeaderFrom(from);
	}

	public void setReplyTo(String to)
	{
		mHeader.setHeaderReplyTo(to);
	}

	public void setBody(String body)
	{
		mMail.setBody(body);
	}

	public IMailDTO getMail()
	{
		return mMail;
	}

	/* ( Javadoc)
	 * @see jp.co.connectone.store.client.MailParseHelper#getSubject()
	 */
	public String getSubject()
	{
		String sub = super.getSubject();
		if (sub == null) return "";
		if (sub.length() == 0) return "";
		return sub;
	}
	
	public String getAttachMark()
	{
		if (this.getNumberOfAttachments() > 0) return "";
		return "";
	}

	public boolean isRead()
	{
		return read;
	}

	public void setRead(boolean read)
	{
		this.read = read;
	}
}
