/**
 * Copyright (C) 2006-2011 Takanori Amano, Amax Inc., and Connectone Co.,Ltd.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; version 2
 * of the License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package jp.co.connectone.webapps.helpers;

import java.net.URLEncoder;
import java.util.Comparator;

import jp.co.connectone.log.Log;
import jp.co.connectone.store.IRecordObject;
import jp.co.connectone.store.pim.*;

/**
 * @author amanot
 *
 */
public class WebAddressParseHelper extends AddressParseHelper implements IRecordObject 
{

/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	/*override original helper */
	public void setAddressDTO(IAddressDTO arg0) {
		copy(arg0);
	}
	
	
	public int getPrevPage()
	{
		return extention.getPrevPage();
	}
	
	public int getNextPage()
	{
		return extention.getNextPage();
	}
	
	
/* added module */
	protected WebParserAggregationBase extention=new WebParserAggregationBase();

	public String getEscapedId()
	{
		String rc = getTid();
		try {rc = URLEncoder.encode(getTid(),"UTF-8");}catch(Exception e){};
		return rc;
	}

	public String getEscapedOid()
	{
		String rc = (String)getOid().getIndex();
		try {rc = URLEncoder.encode((String)getOid().getIndex(),"UTF-8");}catch(Exception e){};
		return rc;
	}

	public static Comparator<WebAddressParseHelper> getComparator()
	{
		return new WebAddressParseHelperComparator();
	}

	/**
	 * @return currentPage ߂܂B
	 */
	public int getCurrentPage() {
		return extention.getCurrentPage();
	}
	/**
	 * @param currentPage currentPage ݒB
	 */
	public void setCurrentPage(int currentPage) {
		extention.setCurrentPage(currentPage);
	}
	
	public WebAddressParseHelper(AddressParseHelper org)
	{
		super(org.getAddressDTO());
		super.setTid(""+extention.getNextID());
		
	}

}
class WebAddressParseHelperComparator implements Comparator<WebAddressParseHelper> {
	  public int compare(WebAddressParseHelper obj1, WebAddressParseHelper obj2) {
	  	if (obj1==null) return -1;
	  	if (obj2==null) return 1;
	  	String displayName1 = obj1.getDisplayName();
	  	String displayName2 = obj2.getDisplayName();
	  	if (displayName1==null) return -1;
	  	if (displayName2==null) return 1;
Log.trace("compare:displayName1="+displayName1+",familyName2="+displayName2);
	  	
	    return displayName1.compareTo(displayName2);
	  }
}
