/**
 * Copyright (C) 2006-2011 Takanori Amano, Amax Inc., and Connectone Co.,Ltd.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; version 2
 * of the License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package jp.co.connectone.protocols.ldap;

import java.util.*;

import javax.naming.*;
import javax.naming.directory.*;

import jp.co.connectone.exception.HandleException;
import jp.co.connectone.log.Log;

/**
 * @author amanot
 *
 */
public class Ldap {
	private DirContext ctx=null;
	
	public boolean open(String userID,String password,String serverName,String suffix) throws HandleException
	{
		Log.debug("Ldap.Open:userID="+userID+",password("+(password==null?"null":"length "+password.length())+"),serverName="+serverName+",suffix="+suffix);
		if (suffix==null) suffix="";
		Properties env = new Properties();
		env.put(Context.SECURITY_PRINCIPAL, userID+suffix);
		env.put(Context.SECURITY_CREDENTIALS, password); 
		env.put(Context.SECURITY_AUTHENTICATION, "simple"); 
		env.put(Context.INITIAL_CONTEXT_FACTORY,"com.sun.jndi.ldap.LdapCtxFactory");
		env.put(Context.PROVIDER_URL,"ldap://" + serverName + "/");
		env.put(Context.REFERRAL, "throw");
		try {
			ctx = new InitialDirContext(env);
		}
		catch (Exception e) {
			Log.error("error LDAP open.", e);
			return false;
		}
		
		return true;
	}
	public void close()
	{
		if (ctx == null) return;
		try {
			ctx.close();
		}
		catch (NamingException ne) {
			Log.debug("error on closing LDAP session.continue...",ne);
		}
		finally {
			ctx = null;
		}
	}
}
