/*
 * Decompiled with CFR 0.152.
 */
package jp.co.connectone.eai.exchews.store;

import com.microsoft.schemas.exchange.services._2006.types.ArrayOfStringsType;
import com.microsoft.schemas.exchange.services._2006.types.AttendeeType;
import com.microsoft.schemas.exchange.services._2006.types.CalendarItemType;
import com.microsoft.schemas.exchange.services._2006.types.FolderIdType;
import com.microsoft.schemas.exchange.services._2006.types.ItemType;
import com.microsoft.schemas.exchange.services._2006.types.LegacyFreeBusyType;
import com.microsoft.schemas.exchange.services._2006.types.MimeContentType;
import com.microsoft.schemas.exchange.services._2006.types.NonEmptyArrayOfAttendeesType;
import com.microsoft.schemas.exchange.services._2006.types.SingleRecipientType;
import com.microsoft.schemas.exchange.services._2006.types.TimeZoneType;
import java.util.Date;
import java.util.List;
import jp.co.connectone.eai.exchews.log.LogAspect;
import jp.co.connectone.eai.exchews.store.ExchewsItemBase;
import jp.co.connectone.eai.exchews.util.ExchEWSTranslator;
import jp.co.connectone.log.Log;
import jp.co.connectone.store.pim.IScheduleDTO;
import jp.co.connectone.store.pim.MailAddress;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.AroundClosure;
import org.aspectj.runtime.reflect.Factory;

public class ExchewsScheduleDTO
extends ExchewsItemBase
implements IScheduleDTO {
    private static final long serialVersionUID = 1L;
    protected String location;
    protected Date start;
    protected Date end;
    protected MailAddress[] requiredAttendees;
    protected MailAddress[] optionalAttendees;
    protected MailAddress[] resources;
    protected MailAddress organizer;
    protected int adjacentMeetingCount;
    protected boolean allowNewTimeProposal;
    protected Date appointmentReplyTime;
    protected int appointmentSequenceNumber;
    protected int appointmentState;
    protected String calendarItemType;
    protected List<String> categories;
    protected int conferenceType;
    protected int conflictingMeetingCount;
    protected Date dateTimeStamp;
    protected String duration;
    protected String inReplyTo;
    protected boolean isAllDayEvent;
    protected boolean isCancelled;
    protected boolean isMeeting;
    protected boolean isOnlineMeeting;
    protected boolean isRecurring;
    protected boolean isResponseRequested;
    protected String lastModifiedName;
    protected String legacyFreeBusyStatus;
    protected boolean meetingRequestWasSent;
    protected String meetingTimeZone = "Tokyo Standard Time";
    protected String meetingWorkspaceUrl;
    protected String mimeContent;
    protected String myResponseType;
    protected String netShowUrl;
    protected Date originalStart;
    protected String parentFolderId;
    protected Date recurrenceId;
    protected Date reminderDueBy;
    protected String timeZone;
    protected String startTimeZone;
    protected String endTimeZone;
    protected String uid;
    protected String when;
    protected String[] ScheduleItemNameList = new String[]{"uid", "recurrenceId", "dateTimeStamp", "start", "end", "originalStart", "isAllDayEvent", "legacyFreeBusyStatus", "location", "when", "isMeeting", "isCancelled", "isRecurring", "meetingRequestWasSent", "isResponseRequested", "calendarItemType", "myResponseType", "organizer", "requiredAttendees", "optionalAttendees", "resources", "conflictingMeetingCount", "adjacentMeetingCount", "conflictingMeetings", "adjacentMeetings", "duration", "timeZone", "appointmentReplyTime", "appointmentSequenceNumber", "appointmentState", "recurrence", "firstOccurrence", "lastOccurrence", "modifiedOccurrences", "deletedOccurrences", "meetingTimeZone", "conferenceType", "allowNewTimeProposal", "isOnlineMeeting", "meetingWorkspaceUrl", "netShowUrl"};
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

    public int getAdjacentMeetingCount() {
        return this.adjacentMeetingCount;
    }

    public void setAdjacentMeetingCount(int adjacentMeetingCount) {
        this.adjacentMeetingCount = adjacentMeetingCount;
    }

    public boolean isAllowNewTimeProposal() {
        return this.allowNewTimeProposal;
    }

    public void setAllowNewTimeProposal(boolean allowNewTimeProposal) {
        this.allowNewTimeProposal = allowNewTimeProposal;
    }

    public Date getAppointmentReplyTime() {
        return this.appointmentReplyTime;
    }

    public void setAppointmentReplyTime(Date appointmentReplyTime) {
        this.appointmentReplyTime = appointmentReplyTime;
    }

    public int getAppointmentSequenceNumber() {
        return this.appointmentSequenceNumber;
    }

    public void setAppointmentSequenceNumber(int appointmentSequenceNumber) {
        this.appointmentSequenceNumber = appointmentSequenceNumber;
    }

    public int getAppointmentState() {
        return this.appointmentState;
    }

    public void setAppointmentState(int appointmentState) {
        this.appointmentState = appointmentState;
    }

    public String getCalendarItemType() {
        return this.calendarItemType;
    }

    public void setCalendarItemType(String calendarItemType) {
        this.calendarItemType = calendarItemType;
    }

    public List<String> getCategories() {
        return this.categories;
    }

    public void setCategories(List<String> categories) {
        this.categories = categories;
    }

    public int getConferenceType() {
        return this.conferenceType;
    }

    public void setConferenceType(int conferenceType) {
        this.conferenceType = conferenceType;
    }

    public int getConflictingMeetingCount() {
        return this.conflictingMeetingCount;
    }

    public void setConflictingMeetingCount(int conflictingMeetingCount) {
        this.conflictingMeetingCount = conflictingMeetingCount;
    }

    public Date getDateTimeStamp() {
        return this.dateTimeStamp;
    }

    public void setDateTimeStamp(Date dateTimeStamp) {
        this.dateTimeStamp = dateTimeStamp;
    }

    public String getDuration() {
        return this.duration;
    }

    public void setDuration(String duration) {
        this.duration = duration;
    }

    public String getInReplyTo() {
        return this.inReplyTo;
    }

    public void setInReplyTo(String inReplyTo) {
        this.inReplyTo = inReplyTo;
    }

    public boolean isAllDayEvent() {
        return this.isAllDayEvent;
    }

    public void setAllDayEvent(boolean isAllDayEvent) {
        this.isAllDayEvent = isAllDayEvent;
    }

    public boolean isCancelled() {
        return this.isCancelled;
    }

    public void setCancelled(boolean isCancelled) {
        this.isCancelled = isCancelled;
    }

    public boolean isMeeting() {
        return this.isMeeting;
    }

    public void setMeeting(boolean isMeeting) {
        this.isMeeting = isMeeting;
    }

    public boolean isOnlineMeeting() {
        return this.isOnlineMeeting;
    }

    public void setOnlineMeeting(boolean isOnlineMeeting) {
        this.isOnlineMeeting = isOnlineMeeting;
    }

    public boolean isRecurring() {
        return this.isRecurring;
    }

    public void setRecurring(boolean isRecurring) {
        this.isRecurring = isRecurring;
    }

    public boolean isResponseRequested() {
        return this.isResponseRequested;
    }

    public void setResponseRequested(boolean isResponseRequested) {
        this.isResponseRequested = isResponseRequested;
    }

    public String getLastModifiedName() {
        return this.lastModifiedName;
    }

    public void setLastModifiedName(String lastModifiedName) {
        this.lastModifiedName = lastModifiedName;
    }

    public String getLegacyFreeBusyStatus() {
        return this.legacyFreeBusyStatus;
    }

    public void setLegacyFreeBusyStatus(String legacyFreeBusyStatus) {
        this.legacyFreeBusyStatus = legacyFreeBusyStatus;
    }

    public boolean isMeetingRequestWasSent() {
        return this.meetingRequestWasSent;
    }

    public void setMeetingRequestWasSent(boolean meetingRequestWasSent) {
        this.meetingRequestWasSent = meetingRequestWasSent;
    }

    public String getMeetingTimeZone() {
        return this.meetingTimeZone;
    }

    public void setMeetingTimeZone(String meetingTimeZone) {
        this.meetingTimeZone = meetingTimeZone;
    }

    public String getMeetingWorkspaceUrl() {
        return this.meetingWorkspaceUrl;
    }

    public void setMeetingWorkspaceUrl(String meetingWorkspaceUrl) {
        this.meetingWorkspaceUrl = meetingWorkspaceUrl;
    }

    public String getMimeContent() {
        return this.mimeContent;
    }

    public void setMimeContent(String mimeContent) {
        this.mimeContent = mimeContent;
    }

    public String getMyResponseType() {
        return this.myResponseType;
    }

    public void setMyResponseType(String myResponseType) {
        this.myResponseType = myResponseType;
    }

    public String getNetShowUrl() {
        return this.netShowUrl;
    }

    public void setNetShowUrl(String netShowUrl) {
        this.netShowUrl = netShowUrl;
    }

    public Date getOriginalStart() {
        return this.originalStart;
    }

    public void setOriginalStart(Date originalStart) {
        this.originalStart = originalStart;
    }

    public String getParentFolderId() {
        return this.parentFolderId;
    }

    public void setParentFolderId(String parentFolderId) {
        this.parentFolderId = parentFolderId;
    }

    public Date getRecurrenceId() {
        return this.recurrenceId;
    }

    public void setRecurrenceId(Date recurrenceId) {
        this.recurrenceId = recurrenceId;
    }

    public Date getReminderDueBy() {
        return this.reminderDueBy;
    }

    public void setReminderDueBy(Date reminderDueBy) {
        this.reminderDueBy = reminderDueBy;
    }

    public String getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(String timeZone) {
        this.timeZone = timeZone;
    }

    public String getUid() {
        return this.uid;
    }

    public void setUid(String uid) {
        this.uid = uid;
    }

    public String getWhen() {
        return this.when;
    }

    public void setWhen(String when) {
        this.when = when;
    }

    public String[] getScheduleItemNameList() {
        return this.ScheduleItemNameList;
    }

    public void setScheduleItemNameList(String[] scheduleItemNameList) {
        this.ScheduleItemNameList = scheduleItemNameList;
    }

    public String getStartTimeZone() {
        return this.startTimeZone;
    }

    public void setStartTimeZone(String startTimeZone) {
        this.startTimeZone = startTimeZone;
    }

    public String getEndTimeZone() {
        return this.endTimeZone;
    }

    public void setEndTimeZone(String endTimeZone) {
        this.endTimeZone = endTimeZone;
    }

    public MailAddress getOrganizer() {
        return this.organizer;
    }

    public void setOrganizer(MailAddress organizer) {
        this.organizer = organizer;
    }

    public Date getStart() {
        return this.start;
    }

    public void setStart(Date start) {
        this.start = start;
    }

    public Date getEnd() {
        return this.end;
    }

    public void setEnd(Date end) {
        this.end = end;
    }

    public MailAddress[] getRequiredAttendees() {
        return this.requiredAttendees;
    }

    public void setRequiredAttendees(MailAddress[] requiredAttendees) {
        this.requiredAttendees = requiredAttendees;
    }

    public MailAddress[] getTo() {
        return this.requiredAttendees;
    }

    public void setTo(MailAddress[] requiredAttendees) {
        this.requiredAttendees = requiredAttendees;
    }

    public MailAddress[] getOptionalAttendees() {
        return this.optionalAttendees;
    }

    public void setOptionalAttendees(MailAddress[] optionalAttendees) {
        this.optionalAttendees = optionalAttendees;
    }

    public long getReminderoffset() {
        if (this.reminderMinutesBeforeStart == null) {
            return -1L;
        }
        return Long.parseLong(this.reminderMinutesBeforeStart);
    }

    public void setReminderoffset(long reminderoffset) {
        this.reminderMinutesBeforeStart = "" + reminderoffset;
    }

    public MailAddress[] getCc() {
        return this.optionalAttendees;
    }

    public void setCc(MailAddress[] optionalAttendees) {
        this.optionalAttendees = optionalAttendees;
    }

    public MailAddress[] getResources() {
        return this.resources;
    }

    public void setResources(MailAddress[] resources) {
        this.resources = resources;
    }

    public MailAddress[] getBcc() {
        return this.resources;
    }

    public void setBcc(MailAddress[] resources) {
        this.resources = resources;
    }

    public static ExchewsScheduleDTO convertFromCalendarItemType(CalendarItemType item) throws Exception {
        int i;
        MailAddress[] add;
        if (item == null) {
            return null;
        }
        ExchewsScheduleDTO rc = new ExchewsScheduleDTO();
        ExchewsScheduleDTO.convertFromItemType(rc, (ItemType)item);
        if (item.getBody() != null) {
            String string = "item.getBody().getValue():" + item.getBody().getValue();
            ExchewsScheduleDTO.trace_aroundBody1$advice(string, LogAspect.aspectOf(), string, null, ajc$tjp_0);
        }
        if (item.getTimeZone() != null) {
            rc.timeZone = item.getTimeZone();
        }
        if (item.getStartTimeZone() != null) {
            rc.startTimeZone = item.getStartTimeZone().getId();
        }
        if (item.getEndTimeZone() != null) {
            rc.endTimeZone = item.getEndTimeZone().getId();
        }
        rc.location = item.getLocation();
        rc.start = ExchEWSTranslator.convertEWSDateTime2JavaDate(item.getStart());
        rc.end = ExchEWSTranslator.convertEWSDateTime2JavaDate(item.getEnd());
        try {
            rc.setMeetingTimeZone(null);
            rc.setMeetingTimeZone(item.getMeetingTimeZone().getTimeZoneName());
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            rc.setOrganizer(ExchEWSTranslator.convertEWSMailBox2MailAddress(item.getOrganizer().getMailbox()));
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            List to_ar = item.getRequiredAttendees().getAttendee();
            add = new MailAddress[to_ar.size()];
            i = 0;
            for (AttendeeType to : to_ar) {
                add[i++] = ExchEWSTranslator.convertEWSMailBox2MailAddress(to.getMailbox());
            }
            rc.setTo(add);
        }
        catch (NullPointerException to_ar) {
            // empty catch block
        }
        try {
            List cc_ar = item.getOptionalAttendees().getAttendee();
            add = new MailAddress[cc_ar.size()];
            i = 0;
            for (AttendeeType cc : cc_ar) {
                add[i++] = ExchEWSTranslator.convertEWSMailBox2MailAddress(cc.getMailbox());
            }
            rc.setCc(add);
        }
        catch (NullPointerException cc_ar) {
            // empty catch block
        }
        try {
            List bcc_ar = item.getResources().getAttendee();
            add = new MailAddress[bcc_ar.size()];
            i = 0;
            for (AttendeeType bcc : bcc_ar) {
                add[i++] = ExchEWSTranslator.convertEWSMailBox2MailAddress(bcc.getMailbox());
            }
            rc.setBcc(add);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return rc;
    }

    public static CalendarItemType convertToCalendarItemType(IScheduleDTO dto) throws Exception {
        AttendeeType attendeeType;
        int n;
        int n2;
        MailAddress[] mailAddressArray;
        List atl;
        NonEmptyArrayOfAttendeesType attype;
        if (dto == null) {
            return null;
        }
        CalendarItemType rc = new CalendarItemType();
        if (!(dto instanceof ExchewsScheduleDTO)) {
            throw new IllegalArgumentException("dto must be instance of ExchewsScheduleDTO");
        }
        ExchewsScheduleDTO schedule = (ExchewsScheduleDTO)dto;
        ExchewsScheduleDTO.convertToItemType((ItemType)rc, schedule);
        if (schedule.getBody() != null) {
            String string = "item.getBody().getValue():" + schedule.getBody();
            ExchewsScheduleDTO.debug_aroundBody3$advice(string, LogAspect.aspectOf(), string, null, ajc$tjp_1);
        }
        rc.setLocation(schedule.getLocation());
        rc.setStart(ExchEWSTranslator.convertJavaDate2EWSDateTime(schedule.getStart()));
        rc.setEnd(ExchEWSTranslator.convertJavaDate2EWSDateTime(schedule.getEnd()));
        try {
            SingleRecipientType organizer = new SingleRecipientType();
            organizer.setMailbox(ExchEWSTranslator.convertMailAddress2EWSMailBox(schedule.getOrganizer()));
        }
        catch (NullPointerException organizer) {
            // empty catch block
        }
        try {
            MailAddress[] to_ar = schedule.getTo();
            attype = new NonEmptyArrayOfAttendeesType();
            atl = attype.getAttendee();
            mailAddressArray = to_ar;
            n2 = to_ar.length;
            n = 0;
            while (n < n2) {
                MailAddress to = mailAddressArray[n];
                attendeeType = new AttendeeType();
                attendeeType.setMailbox(ExchEWSTranslator.convertMailAddress2EWSMailBox(to));
                atl.add(attendeeType);
                ++n;
            }
            rc.setRequiredAttendees(attype);
        }
        catch (NullPointerException to_ar) {
            // empty catch block
        }
        try {
            MailAddress[] cc_ar = schedule.getCc();
            attype = new NonEmptyArrayOfAttendeesType();
            atl = attype.getAttendee();
            mailAddressArray = cc_ar;
            n2 = cc_ar.length;
            n = 0;
            while (n < n2) {
                MailAddress cc = mailAddressArray[n];
                attendeeType = new AttendeeType();
                attendeeType.setMailbox(ExchEWSTranslator.convertMailAddress2EWSMailBox(cc));
                atl.add(attendeeType);
                ++n;
            }
            rc.setOptionalAttendees(attype);
        }
        catch (NullPointerException cc_ar) {
            // empty catch block
        }
        try {
            MailAddress[] bcc_ar = schedule.getBcc();
            attype = new NonEmptyArrayOfAttendeesType();
            atl = attype.getAttendee();
            mailAddressArray = bcc_ar;
            n2 = bcc_ar.length;
            n = 0;
            while (n < n2) {
                MailAddress bcc = mailAddressArray[n];
                attendeeType = new AttendeeType();
                attendeeType.setMailbox(ExchEWSTranslator.convertMailAddress2EWSMailBox(bcc));
                atl.add(attendeeType);
                ++n;
            }
            rc.setResources(attype);
        }
        catch (NullPointerException bcc_ar) {
            // empty catch block
        }
        try {
            ArrayOfStringsType array = new ArrayOfStringsType();
            List a = array.getString();
            for (String cat : schedule.getCategories()) {
                a.add(cat);
            }
        }
        catch (NullPointerException array) {
            // empty catch block
        }
        rc.setIsAllDayEvent(Boolean.valueOf(schedule.isAllDayEvent()));
        rc.setLegacyFreeBusyStatus(LegacyFreeBusyType.BUSY);
        if (schedule.getMeetingTimeZone() != null) {
            TimeZoneType tz = new TimeZoneType();
            tz.setTimeZoneName(schedule.getMeetingTimeZone());
            rc.setMeetingTimeZone(tz);
        }
        if (schedule.getMeetingWorkspaceUrl() != null) {
            rc.setMeetingWorkspaceUrl(schedule.getMeetingWorkspaceUrl());
        }
        if (schedule.getMimeContent() != null) {
            MimeContentType mimeContentType = new MimeContentType();
            mimeContentType.setValue(schedule.getMimeContent());
        }
        if (schedule.getParentFolderId() != null) {
            FolderIdType folderIdType = new FolderIdType();
            folderIdType.setId(schedule.getParentFolderId());
        }
        return rc;
    }

    public Date getEndDate() {
        return this.end;
    }

    public String getLocation() {
        return this.location;
    }

    public Date getStartDate() {
        return this.start;
    }

    public String getUserId() {
        return null;
    }

    public void setEndDate(Date endDate) {
        this.end = endDate;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public void setStartDate(Date startDate) {
        this.start = startDate;
    }

    public void setUserId(String userId) {
    }

    static {
        ExchewsScheduleDTO.ajc$preClinit();
    }

    private static final /* synthetic */ void trace_aroundBody0(String string) {
        Log.trace((String)string);
    }

    private static final /* synthetic */ void trace_aroundBody1$advice(String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exchews_log_LogAspect$jp_co_connectone_eai_exchews_log_LogAspect$log(ajc$aspectInstance).isTraceEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exchews_log_LogAspect$jp_co_connectone_eai_exchews_log_LogAspect$log(ajc$aspectInstance).trace((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final /* synthetic */ void debug_aroundBody2(String string) {
        Log.debug((String)string);
    }

    private static final /* synthetic */ void debug_aroundBody3$advice(String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exchews_log_LogAspect$jp_co_connectone_eai_exchews_log_LogAspect$log(ajc$aspectInstance).isDebugEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exchews_log_LogAspect$jp_co_connectone_eai_exchews_log_LogAspect$log(ajc$aspectInstance).debug((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("ExchewsScheduleDTO.java", Class.forName("jp.co.connectone.eai.exchews.store.ExchewsScheduleDTO"));
        ajc$tjp_0 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "trace", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 573);
        ajc$tjp_1 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "debug", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 636);
    }
}

