/*
 * Decompiled with CFR 0.152.
 */
package jp.co.connectone.store.pim;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Date;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.BodyPart;
import javax.mail.Multipart;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import jp.co.connectone.log.Log;
import jp.co.connectone.store.BasicRecordObject;
import jp.co.connectone.store.IObjectIndex;
import jp.co.connectone.store.client.AttachmentDataSource;
import jp.co.connectone.store.pim.AttachmentDTO;
import jp.co.connectone.store.pim.HeaderDTO;
import jp.co.connectone.store.pim.IMailDTO;
import jp.co.connectone.store.pim.MailAddress;

public class BasicMailDTO
extends BasicRecordObject
implements IMailDTO {
    private static final long serialVersionUID = 1L;
    protected HeaderDTO header = null;
    protected String body = null;
    protected AttachmentDTO[] attachments = null;

    public BasicMailDTO() {
        this.header = null;
    }

    public BasicMailDTO(HeaderDTO header) {
        this.header = header;
    }

    @Override
    public MailAddress[] getBCC() {
        return this.header.getHeaderBCC();
    }

    @Override
    public MailAddress[] getCC() {
        return this.header.getHeaderCC();
    }

    @Override
    public MailAddress getFrom() {
        return this.header.getHeaderFrom();
    }

    @Override
    public int getPriority() {
        return this.header.getHeaderPriority();
    }

    @Override
    public MailAddress getReplyTo() {
        return this.header.getHeaderReplyTo();
    }

    @Override
    public Date getSentDate() {
        return this.header.getHeaderSendDate();
    }

    @Override
    public Date getReceivedDate() {
        return this.header.getHeaderReceivedDate();
    }

    @Override
    public int getSize() {
        return this.header.getHeaderSize();
    }

    @Override
    public String getSubject() {
        return this.header.getHeaderSubject();
    }

    @Override
    public MailAddress[] getTo() {
        return this.header.getHeaderTo();
    }

    @Override
    public void setBCC(MailAddress[] bcc) {
        this.header.setHeaderBCC(bcc);
    }

    @Override
    public void setCC(MailAddress[] cc) {
        this.header.setHeaderCC(cc);
    }

    @Override
    public void setFrom(MailAddress from) {
        this.header.setHeaderFrom(from);
    }

    @Override
    public void setPriority(int priority) {
        this.header.setHeaderPriority(priority);
    }

    @Override
    public void setReplyTo(MailAddress replyTo) {
        this.header.setHeaderReplyTo(replyTo);
    }

    @Override
    public void setSentDate(Date date) {
        this.header.setHeaderSendDate(date);
    }

    @Override
    public void setSize(int size) {
        this.header.setHeaderSize(size);
    }

    @Override
    public void setSubject(String subject) {
        this.header.setHeaderSubject(subject);
    }

    @Override
    public void setTo(MailAddress[] to) {
        this.header.setHeaderTo(to);
    }

    @Override
    public String getBody() {
        return this.body;
    }

    @Override
    public int getNumberOfAttachments() {
        if (this.attachments == null) {
            return 0;
        }
        return this.attachments.length;
    }

    @Override
    public AttachmentDTO getAttachment(int number) {
        return this.attachments[number];
    }

    @Override
    public HeaderDTO getHeader() {
        return this.header;
    }

    @Override
    public String getMailBinary() {
        String rc = "";
        if (this.attachments == null) {
            return this.body;
        }
        try {
            String tmp;
            MimeMessage msg = new MimeMessage(null);
            MimeMultipart part = new MimeMultipart();
            MimeBodyPart body = new MimeBodyPart();
            body.setText(this.body);
            part.addBodyPart((BodyPart)body);
            int i = 0;
            while (i < this.attachments.length) {
                MimeBodyPart attach = new MimeBodyPart();
                attach.setDataHandler(new DataHandler((DataSource)new AttachmentDataSource(this.attachments[i])));
                attach.setFileName(this.attachments[i].getFileName());
                part.addBodyPart((BodyPart)attach);
                ++i;
            }
            msg.setContent((Multipart)part);
            msg.saveChanges();
            rc = "MIME-Version: 1.0\r\nContent-Type: " + msg.getHeader("Content-Type", null) + "\r\n\r\n";
            InputStream is = msg.getInputStream();
            BufferedReader b = new BufferedReader(new InputStreamReader(is));
            while ((tmp = b.readLine()) != null) {
                rc = String.valueOf(rc) + tmp + "\n";
            }
        }
        catch (Exception e) {
            Log.error("Exception on creating MimeMessage", e);
        }
        return rc;
    }

    @Override
    public void setBody(String body) {
        this.body = body;
    }

    @Override
    public void setHeaderDTO(HeaderDTO header) {
        this.header = header;
    }

    @Override
    public void setAttachments(AttachmentDTO[] attachments) {
        this.attachments = attachments;
    }

    @Override
    public AttachmentDTO[] getAttachments() {
        return this.attachments;
    }

    public String toString() {
        String rc = super.toString();
        if (this.header != null) {
            rc = String.valueOf(rc) + ":" + this.header.getHeaderUIDL() + ":" + this.header.getHeaderSubject();
        }
        if (this.getNumberOfAttachments() > 0) {
            rc = String.valueOf(rc) + " attachments:" + this.getNumberOfAttachments();
        }
        return rc;
    }

    @Override
    public IObjectIndex getOid() {
        if (this.header == null) {
            return null;
        }
        return this.header.getOid();
    }

    @Override
    public void setOid(IObjectIndex oid) {
        if (this.header == null) {
            this.header = new HeaderDTO();
        }
        this.header.setOid(oid);
    }
}

