/*
 * Decompiled with CFR 0.152.
 */
package jregex;

import jregex.Pattern;
import jregex.PatternSyntaxException;

public class WildcardPattern
extends Pattern {
    public static final String WORD_CHAR = "\\w";
    public static final String ANY_CHAR = ".";
    private static final String defaultSpecials = "[]().{}+|^$\\";
    private static final String defaultWcClass = ".";
    private String str;

    protected static String convertSpecials(String string, String string2, String string3) {
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            switch (c) {
                case '*': {
                    stringBuffer.append("(");
                    stringBuffer.append(string2);
                    stringBuffer.append("*)");
                    break;
                }
                case '?': {
                    stringBuffer.append("(");
                    stringBuffer.append(string2);
                    stringBuffer.append(")");
                    break;
                }
                default: {
                    if (string3.indexOf(c) >= 0) {
                        stringBuffer.append('\\');
                    }
                    stringBuffer.append(c);
                }
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    public WildcardPattern(String string) {
        this(string, true);
    }

    public WildcardPattern(String string, boolean bl) {
        this(string, bl ? 1 : 0);
    }

    public WildcardPattern(String string, int n) {
        this.compile(string, ".", defaultSpecials, n);
    }

    public WildcardPattern(String string, String string2, int n) {
        this.compile(string, string2, defaultSpecials, n);
    }

    protected WildcardPattern() {
    }

    protected void compile(String string, String string2, String string3, int n) {
        String string4 = WildcardPattern.convertSpecials(string, string2, string3);
        try {
            this.compile(string4, n);
        }
        catch (PatternSyntaxException patternSyntaxException) {
            throw new Error(patternSyntaxException.getMessage() + "; original expr: " + string + ", converted: " + string4);
        }
        this.str = string;
    }

    public String toString() {
        return this.str;
    }
}

