/*
 * Decompiled with CFR 0.152.
 */
package jregex;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.util.Hashtable;
import jregex.MatchResult;
import jregex.Matcher;
import jregex.PatternSyntaxException;
import jregex.REFlags;
import jregex.RETokenizer;
import jregex.Replacer;
import jregex.Substitution;
import jregex.Term;

public class Pattern
implements Serializable,
REFlags {
    String stringRepr;
    Term root;
    Term root0;
    int memregs;
    int counters;
    int lookaheads;
    Hashtable namedGroupMap;

    protected Pattern() throws PatternSyntaxException {
    }

    public Pattern(String string) throws PatternSyntaxException {
        this(string, 0);
    }

    public Pattern(String string, String string2) throws PatternSyntaxException {
        this.stringRepr = string;
        this.compile(string, Pattern.parseFlags(string2));
    }

    public Pattern(String string, int n) throws PatternSyntaxException {
        this.compile(string, n);
    }

    protected void compile(String string, int n) throws PatternSyntaxException {
        this.stringRepr = string;
        Term.makeTree(string, n, this);
    }

    public int groupCount() {
        return this.memregs;
    }

    public Integer groupId(String string) {
        return (Integer)this.namedGroupMap.get(string);
    }

    public boolean matches(String string) {
        return this.matcher(string).matches();
    }

    public boolean startsWith(String string) {
        return this.matcher(string).matchesPrefix();
    }

    public Matcher matcher() {
        return new Matcher(this);
    }

    public Matcher matcher(String string) {
        Matcher matcher = new Matcher(this);
        matcher.setTarget(string);
        return matcher;
    }

    public Matcher matcher(char[] cArray, int n, int n2) {
        Matcher matcher = new Matcher(this);
        matcher.setTarget(cArray, n, n2);
        return matcher;
    }

    public Matcher matcher(MatchResult matchResult, int n) {
        Matcher matcher = new Matcher(this);
        if (matchResult instanceof Matcher) {
            matcher.setTarget((Matcher)matchResult, n);
        } else {
            matcher.setTarget(matchResult.targetChars(), matchResult.start(n) + matchResult.targetStart(), matchResult.length(n));
        }
        return matcher;
    }

    public Matcher matcher(MatchResult matchResult, String string) {
        Integer n = matchResult.pattern().groupId(string);
        if (n == null) {
            throw new IllegalArgumentException("group not found:" + string);
        }
        int n2 = n;
        return this.matcher(matchResult, n2);
    }

    public Matcher matcher(Reader reader, int n) throws IOException {
        Matcher matcher = new Matcher(this);
        matcher.setTarget(reader, n);
        return matcher;
    }

    public Replacer replacer(String string) {
        return new Replacer(this, string);
    }

    public Replacer replacer(Substitution substitution) {
        return new Replacer(this, substitution);
    }

    public RETokenizer tokenizer(String string) {
        return new RETokenizer(this, string);
    }

    public RETokenizer tokenizer(char[] cArray, int n, int n2) {
        return new RETokenizer(this, cArray, n, n2);
    }

    public RETokenizer tokenizer(Reader reader, int n) throws IOException {
        return new RETokenizer(this, reader, n);
    }

    public String toString() {
        return this.stringRepr;
    }

    public String toString_d() {
        return this.root.toStringAll();
    }

    static int parseFlags(String string) throws PatternSyntaxException {
        boolean bl = true;
        int n = string.length();
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            char c = string.charAt(n3);
            switch (c) {
                case '+': {
                    bl = true;
                    break;
                }
                case '-': {
                    bl = false;
                    break;
                }
                default: {
                    int n4 = Pattern.getFlag(c);
                    if (bl) {
                        n2 |= n4;
                        break;
                    }
                    n2 &= ~n4;
                }
            }
            ++n3;
        }
        return n2;
    }

    static int parseFlags(char[] cArray, int n, int n2) throws PatternSyntaxException {
        boolean bl = true;
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            char c = cArray[n + n4];
            switch (c) {
                case '+': {
                    bl = true;
                    break;
                }
                case '-': {
                    bl = false;
                    break;
                }
                default: {
                    int n5 = Pattern.getFlag(c);
                    if (bl) {
                        n3 |= n5;
                        break;
                    }
                    n3 &= ~n5;
                }
            }
            ++n4;
        }
        return n3;
    }

    private static int getFlag(char c) throws PatternSyntaxException {
        switch (c) {
            case 'i': {
                return 1;
            }
            case 'm': {
                return 2;
            }
            case 's': {
                return 4;
            }
            case 'x': {
                return 8;
            }
            case 'u': {
                return 16;
            }
            case 'X': {
                return 32;
            }
        }
        throw new PatternSyntaxException("unknown flag: " + c);
    }
}

