/*
 * Decompiled with CFR 0.152.
 */
package jp.co.connectone.eai.exch2k.store;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javax.mail.BodyPart;
import javax.mail.Multipart;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimeUtility;
import jp.co.connectone.eai.exch2k.dav.DavSearchCondition;
import jp.co.connectone.eai.exch2k.log.LogAspect;
import jp.co.connectone.eai.exch2k.store.EAIExch2kBase;
import jp.co.connectone.eai.exch2k.store.Exch2kFolderIndex;
import jp.co.connectone.eai.exch2k.store.Exch2kObjectIndex;
import jp.co.connectone.eai.exch2k.store.Exch2kScheduleDTO;
import jp.co.connectone.eai.exch2k.store.Exch2kServiceInfo;
import jp.co.connectone.exception.DataNotFound;
import jp.co.connectone.exception.DeleteFailed;
import jp.co.connectone.exception.HandleException;
import jp.co.connectone.exception.IncorrectData;
import jp.co.connectone.exception.IncorrectStore;
import jp.co.connectone.exception.NoSuchRights;
import jp.co.connectone.exception.SearchConditionFailed;
import jp.co.connectone.exception.ServerDown;
import jp.co.connectone.exception.UpdateFailed;
import jp.co.connectone.log.Log;
import jp.co.connectone.service.IServiceInfo;
import jp.co.connectone.service.IServiceInfoRawData;
import jp.co.connectone.store.BasicSearchDestination;
import jp.co.connectone.store.FolderMetadata;
import jp.co.connectone.store.IDatabaseIndex;
import jp.co.connectone.store.IFolderIndex;
import jp.co.connectone.store.IObjectIndex;
import jp.co.connectone.store.IRecordObject;
import jp.co.connectone.store.ISearchDestination;
import jp.co.connectone.store.ISearchFormula;
import jp.co.connectone.store.ISearchType;
import jp.co.connectone.store.IStoreID;
import jp.co.connectone.store.SearchCondition;
import jp.co.connectone.store.SearchConditionCollection;
import jp.co.connectone.store.SimpleStoreID;
import jp.co.connectone.store.client.ScheduleSearchCondition;
import jp.co.connectone.store.pim.IScheduleDTO;
import jp.co.connectone.store.pim.IScheduleStore;
import jp.co.connectone.store.pim.MailAddress;
import jp.co.connectone.user.IAccountData;
import jp.co.connectone.user.PasswordBasedAccountDataImpl;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.AroundClosure;
import org.aspectj.runtime.reflect.Factory;

public class Exch2kScheduleStoreImpl
extends EAIExch2kBase
implements IScheduleStore {
    private static final String DEFAULT_EXCHANGE_SCHEDULE_PATH_ELEMENT = "\u4e88\u5b9a\u8868";
    private IFolderIndex scheduleElement = new Exch2kFolderIndex("\u4e88\u5b9a\u8868");
    protected static final String elmentName = "\u4e88\u5b9a\u8868";
    public static final IStoreID storeID;
    public static final String storeName = "Exchange2K schedule store";
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;

    static {
        Exch2kScheduleStoreImpl.ajc$preClinit();
        storeID = new SimpleStoreID(Exch2kScheduleStoreImpl.class.getName());
    }

    public String getName() throws Exception {
        return storeName;
    }

    public IServiceInfo getServiceInfo(IServiceInfoRawData serviceData) throws Exception {
        return super.getServiceInfo(storeID, storeName, serviceData);
    }

    public IServiceInfo getServiceInfo() throws Exception {
        return new Exch2kServiceInfo(storeID, storeName);
    }

    public IStoreID getStoreID() throws Exception {
        return storeID;
    }

    public void delete(IAccountData acc, ISearchDestination dest, IObjectIndex oid) throws Exception {
        this.deleteSchedule(acc, oid);
    }

    public IRecordObject[] getAllDatas(IAccountData acc, ISearchDestination dest) throws Exception {
        return this.getAllSchedules(acc, null);
    }

    public FolderMetadata[] getFolderList(IAccountData acc, ISearchDestination dest) throws Exception {
        FolderMetadata[] l_strFolderlist = new FolderMetadata[]{};
        this.setAccountData((PasswordBasedAccountDataImpl)acc);
        IFolderIndex path = dest.getFolder();
        if (path == null) {
            path = this.scheduleElement;
        }
        Vector<Object> lists = super.getAllSubFolders((String)path.getIndex());
        ArrayList<FolderMetadata> arrFolderlist = this.populateFolderList(0, (String)path.getIndex(), lists);
        l_strFolderlist = arrFolderlist.toArray(l_strFolderlist);
        int i = 0;
        while (i < l_strFolderlist.length) {
            if (l_strFolderlist[i].getFolderName().length() == 0) {
                l_strFolderlist[i].setFolderName((String)path.getIndex());
            }
            ++i;
        }
        return l_strFolderlist;
    }

    public IRecordObject read(IAccountData acc, ISearchDestination dest, IObjectIndex oid) throws Exception {
        return this.getSchedule(acc, oid);
    }

    public IRecordObject[] search(IAccountData acc, ISearchFormula col) throws Exception {
        return this.searchSchedules(acc, col);
    }

    public IRecordObject[] searchByDate(IAccountData acc, ISearchDestination dest, Date startDate) throws Exception {
        throw new UnsupportedOperationException("search shcedules with date not yet supported.");
    }

    public IObjectIndex write(IAccountData acc, ISearchDestination dest, IRecordObject data) throws Exception {
        IObjectIndex rc = null;
        rc = data.isNew() ? this.createNewSchedule(acc, (IScheduleDTO)data) : this.updateSchedule(acc, (IScheduleDTO)data);
        return rc;
    }

    public boolean isValidSchedule(IScheduleDTO IScheduleDTO2) throws IncorrectStore, ServerDown, DataNotFound, HandleException {
        return true;
    }

    public boolean isValidSchedule(IAccountData acc, IScheduleDTO IScheduleDTO2) throws IncorrectStore, ServerDown, NoSuchRights, DataNotFound, IncorrectData, HandleException {
        return true;
    }

    public boolean isDuplicateSchedule(IAccountData acc, IScheduleDTO IScheduleDTO2) throws IncorrectStore, NoSuchRights, ServerDown, DataNotFound, IncorrectData, HandleException {
        return false;
    }

    public IScheduleDTO[] getAllSchedules(IAccountData acc, Date cutOffDate) throws IncorrectData, NoSuchRights, ServerDown, DataNotFound, IncorrectStore, SearchConditionFailed, HandleException {
        Exch2kScheduleDTO[] l_IScheduleDTOArray = null;
        Vector<String> v = this.makeItemList();
        this.setAccountData((PasswordBasedAccountDataImpl)acc);
        Vector<HashMap<String, Object>> col = super.getList(this.scheduleElement, v);
        int len = col.size();
        l_IScheduleDTOArray = new Exch2kScheduleDTO[len];
        int i = 0;
        while (i < len) {
            l_IScheduleDTOArray[i] = this.populateScheduleDTO(col.elementAt(i));
            ++i;
        }
        return l_IScheduleDTOArray;
    }

    private Vector<String> makeItemList() {
        Vector<String> v = new Vector<String>();
        v.add("DAV:id");
        v.add("DAV:href");
        v.add("DAV:getcontentlength");
        v.add("DAV:ishidden");
        v.add("http://schemas.microsoft.com/exchange/sensitivity");
        v.add("http://schemas.microsoft.com/mapi/reminderset");
        v.add("http://schemas.microsoft.com/mapi/remindertime");
        v.add("urn:schemas:calendar:dtstart");
        v.add("urn:schemas:calendar:dtend");
        v.add("urn:schemas:calendar:location");
        v.add("urn:schemas:calendar:alldayevent");
        v.add("urn:schemas:calendar:busystatus");
        v.add("urn:schemas:calendar:created");
        v.add("urn:schemas:calendar:duration");
        v.add("urn:schemas:calendar:exdate");
        v.add("urn:schemas:calendar:exrule");
        v.add("urn:schemas:calendar:instancetype");
        v.add("urn:schemas:calendar:isorganizer");
        v.add("urn:schemas:calendar:lastmodified");
        v.add("urn:schemas:calendar:lastmodifiedtime");
        v.add("urn:schemas:calendar:meetingstatus");
        v.add("urn:schemas:calendar:organizer");
        v.add("urn:schemas:calendar:rdate");
        v.add("urn:schemas:calendar:recurrenceid");
        v.add("urn:schemas:calendar:reminderoffset");
        v.add("urn:schemas:calendar:remindernexttime");
        v.add("urn:schemas:calendar:resources");
        v.add("urn:schemas:calendar:rrule");
        v.add("urn:schemas:calendar:sequence");
        v.add("urn:schemas:calendar:timezone");
        v.add("urn:schemas:calendar:timezoneid");
        v.add("urn:schemas:calendar:uid");
        v.add("urn:schemas:calendar:version");
        v.add("urn:schemas:httpmail:subject");
        v.add("urn:schemas:httpmail:textdescription");
        v.add("urn:schemas:httpmail:hasattachment");
        v.add("urn:schemas:mailheader:to");
        v.add("urn:schemas:mailheader:cc");
        v.add("urn:schemas:mailheader:bcc");
        return v;
    }

    public IScheduleDTO[] searchSchedules(IAccountData acc, ISearchFormula form) throws IncorrectData, NoSuchRights, ServerDown, DataNotFound, IncorrectStore, SearchConditionFailed, HandleException {
        SearchConditionCollection conds = form.getSearchConditions();
        if (conds == null) {
            throw new NullPointerException("Search Condition must not be null");
        }
        if (conds.size() == 0) {
            return this.getAllSchedules(acc, null);
        }
        String idToSee = null;
        Date dateObj = null;
        IObjectIndex oid = null;
        Iterator it = conds.iterator();
        ScheduleSearchCondition cond = null;
        while (it.hasNext()) {
            cond = (ScheduleSearchCondition)it.next();
            ISearchType type = cond.getType();
            Object value = cond.getValue();
            String string = "condition:" + type + ":" + value;
            Exch2kScheduleStoreImpl.debug_aroundBody1$advice(this, string, LogAspect.aspectOf(), string, null, ajc$tjp_0);
            if (type == ScheduleSearchCondition.CONDITION.TYPE_ACCOUNTNAME) {
                idToSee = ((IObjectIndex)value).getIndex().toString();
                continue;
            }
            if (type == ScheduleSearchCondition.CONDITION.TYPE_SINGLEDATE) {
                dateObj = (Date)value;
                continue;
            }
            if (type == ScheduleSearchCondition.CONDITION.TYPE_OID) {
                oid = (IObjectIndex)value;
                continue;
            }
            throw new IllegalArgumentException("Illegal SearchCondition");
        }
        if (idToSee == null) {
            return this.getSchedulesByDate(acc, dateObj);
        }
        Exch2kScheduleDTO[] l_IScheduleDTOArray = null;
        Vector<String> v = this.makeItemList();
        this.exSetAccountData((PasswordBasedAccountDataImpl)acc, idToSee);
        Vector<HashMap<String, Object>> col = super.exGetListByDate(1, this.scheduleElement, v, dateObj, "urn:schemas:calendar:dtstart");
        int len = col.size();
        l_IScheduleDTOArray = new Exch2kScheduleDTO[len];
        int i = 0;
        while (i < len) {
            if (oid == null) {
                l_IScheduleDTOArray[i] = this.populateScheduleDTO(col.elementAt(i));
            } else {
                Exch2kScheduleDTO s = this.populateScheduleDTO(col.elementAt(i));
                if (oid.equals(s.getOid())) {
                    l_IScheduleDTOArray = new Exch2kScheduleDTO[]{s};
                    break;
                }
            }
            ++i;
        }
        return l_IScheduleDTOArray;
    }

    public IScheduleDTO[] getSchedulesByDate(IAccountData acc, Date dateObj) throws IncorrectData, NoSuchRights, ServerDown, DataNotFound, IncorrectStore, SearchConditionFailed, HandleException {
        Exch2kScheduleDTO[] l_IScheduleDTOArray = null;
        Vector<String> v = this.makeItemList();
        this.setAccountData((PasswordBasedAccountDataImpl)acc);
        Vector<HashMap<String, Object>> col = super.getListByDate(this.scheduleElement, v, dateObj, "urn:schemas:calendar:dtstart");
        int len = col.size();
        l_IScheduleDTOArray = new Exch2kScheduleDTO[len];
        int i = 0;
        while (i < len) {
            l_IScheduleDTOArray[i] = this.populateScheduleDTO(col.elementAt(i));
            ++i;
        }
        return l_IScheduleDTOArray;
    }

    public IScheduleDTO getSchedule(IAccountData acc, IObjectIndex oid) throws IncorrectData, NoSuchRights, ServerDown, DataNotFound, IncorrectStore, HandleException {
        String string = "getSchedule::oid=" + oid;
        Exch2kScheduleStoreImpl.debug_aroundBody3$advice(this, string, LogAspect.aspectOf(), string, null, ajc$tjp_1);
        this.setAccountData((PasswordBasedAccountDataImpl)acc);
        HashMap<String, Object> sche = super.getProps((String)oid.getIndex(), this.makeItemList());
        return this.populateScheduleDTO(sche);
    }

    public IObjectIndex createNewSchedule(IAccountData acc, IScheduleDTO scheduleDTO) throws IncorrectData, NoSuchRights, DataNotFound, IncorrectStore, ServerDown, HandleException {
        Exch2kScheduleDTO dto2;
        IObjectIndex oid = null;
        this.setAccountData((PasswordBasedAccountDataImpl)acc);
        Hashtable<String, String> h = this.populateHashtable(scheduleDTO);
        String url = String.valueOf(this.generateBaseURL()) + "\u4e88\u5b9a\u8868" + "/" + new Date().getTime() + ".EML";
        Hashtable<String, String> h2 = this.populateNewScheduleElements();
        h.putAll(h2);
        oid = super.saveData(this.escapeURL(url), h);
        if (scheduleDTO instanceof Exch2kScheduleDTO && "CONFIRMED".equals((dto2 = (Exch2kScheduleDTO)scheduleDTO).getMeetingstatus())) {
            HashMap<String, Object> savedData = super.getFile(url);
            String uid = (String)savedData.get("uid");
            dto2.setUid(uid);
            h = this.populateHashtable(scheduleDTO);
            h2 = this.populateRequestElements();
            h.putAll(h2);
            url = String.valueOf(this.generateBaseURL()) + this.scheduleElement.getIndex().toString() + "/" + new Date().getTime() + "-request.EML";
            oid = super.saveData(this.escapeURL(url), h);
            super.sendSavedMsg(url);
        }
        return oid;
    }

    public IObjectIndex updateSchedule(IAccountData acc, IScheduleDTO objIScheduleDTO) throws IncorrectData, NoSuchRights, ServerDown, DataNotFound, IncorrectStore, SearchConditionFailed, UpdateFailed, HandleException {
        IObjectIndex oid = null;
        Hashtable<String, String> h = this.populateHashtable(objIScheduleDTO);
        this.setAccountData((PasswordBasedAccountDataImpl)acc);
        String url = (String)objIScheduleDTO.getOid().getIndex();
        oid = super.saveData(url, h);
        return oid;
    }

    public void deleteSchedule(IAccountData acc, IObjectIndex oid) throws IncorrectData, DeleteFailed, NoSuchRights, ServerDown, DataNotFound, IncorrectStore, SearchConditionFailed, HandleException {
        this.setAccountData((PasswordBasedAccountDataImpl)acc);
        super.delete(oid);
    }

    private Exch2kScheduleDTO populateScheduleDTO(HashMap<String, Object> itemList) throws ServerDown, DataNotFound {
        Exch2kScheduleDTO l_IScheduleDTO = new Exch2kScheduleDTO();
        try {
            l_IScheduleDTO.setFieldSet(itemList);
        }
        catch (IllegalAccessException e) {
            Log.error((String)"failed setting FieldSet", (Throwable)e);
        }
        l_IScheduleDTO.setOid((IObjectIndex)new Exch2kObjectIndex(itemList.get("href")));
        l_IScheduleDTO.setSubject((String)itemList.get("subject"));
        l_IScheduleDTO.setLocation((String)itemList.get("location"));
        l_IScheduleDTO.setBody((String)itemList.get("textdescription"));
        l_IScheduleDTO.setStartDate(this.davDateStr2JavaDate((String)itemList.get("dtstart")));
        l_IScheduleDTO.setEndDate(this.davDateStr2JavaDate((String)itemList.get("dtend")));
        try {
            boolean b = false;
            long l = Long.parseLong((String)itemList.get("alldayevent"));
            if (l != 0L) {
                b = true;
            }
            l_IScheduleDTO.setAlldayevent(b);
        }
        catch (NumberFormatException b) {
            // empty catch block
        }
        l_IScheduleDTO.setBusystatus((String)itemList.get("busystatus"));
        l_IScheduleDTO.setCreated(this.davDateStr2JavaDate((String)itemList.get("created")));
        try {
            l_IScheduleDTO.setDuration(Long.parseLong((String)itemList.get("duration")));
        }
        catch (NumberFormatException b) {
            // empty catch block
        }
        String[] exdate = new String[]{(String)itemList.get("exdate")};
        l_IScheduleDTO.setExdate(exdate);
        l_IScheduleDTO.setExrule((String)itemList.get("exrule"));
        try {
            l_IScheduleDTO.setInstancetype(Long.parseLong((String)itemList.get("instancetype")));
        }
        catch (NumberFormatException l) {
            // empty catch block
        }
        try {
            boolean b = false;
            long l = Long.parseLong((String)itemList.get("isorganizer"));
            if (l != 0L) {
                b = true;
            }
            l_IScheduleDTO.setIsorganizer(b);
        }
        catch (NumberFormatException b) {
            // empty catch block
        }
        l_IScheduleDTO.setLastmodified(this.davDateStr2JavaDate((String)itemList.get("lastmodified")));
        l_IScheduleDTO.setLastmodifiedtime(this.davDateStr2JavaDate((String)itemList.get("lastmodifiedtime")));
        l_IScheduleDTO.setMeetingstatus((String)itemList.get("meetingstatus"));
        try {
            MailAddress[] organizer = MailAddress.parseAddressLine((String)MimeUtility.decodeText((String)((String)itemList.get("organizer"))));
            l_IScheduleDTO.setOrganizer(organizer[0]);
        }
        catch (Exception organizer) {
            // empty catch block
        }
        try {
            MailAddress[] TOs = MailAddress.parseAddressLine((String)MimeUtility.decodeText((String)((String)itemList.get("to"))));
            l_IScheduleDTO.setTo(TOs);
        }
        catch (Exception TOs) {
            // empty catch block
        }
        try {
            MailAddress[] CCs = MailAddress.parseAddressLine((String)MimeUtility.decodeText((String)((String)itemList.get("cc"))));
            l_IScheduleDTO.setCc(CCs);
        }
        catch (Exception CCs) {
            // empty catch block
        }
        try {
            MailAddress[] BCCs = MailAddress.parseAddressLine((String)MimeUtility.decodeText((String)((String)itemList.get("bcc"))));
            l_IScheduleDTO.setBcc(BCCs);
        }
        catch (Exception BCCs) {
            // empty catch block
        }
        l_IScheduleDTO.setRecurrenceid((String)itemList.get("recurrenceid"));
        try {
            l_IScheduleDTO.setReminderoffset(Long.parseLong((String)itemList.get("reminderoffset")));
        }
        catch (NumberFormatException BCCs) {
            // empty catch block
        }
        try {
            l_IScheduleDTO.setRemindernexttime(this.davDateStr2JavaDate((String)itemList.get("remindernexttime")));
        }
        catch (NumberFormatException BCCs) {
            // empty catch block
        }
        String reminderSet = (String)itemList.get("reminderset");
        if ("1".equals(reminderSet)) {
            l_IScheduleDTO.setReminderset(true);
        } else {
            l_IScheduleDTO.setReminderset(false);
        }
        l_IScheduleDTO.setResources((String)itemList.get("resources"));
        l_IScheduleDTO.setRrule((String)itemList.get("rrule"));
        try {
            l_IScheduleDTO.setSequence(Long.parseLong((String)itemList.get("sequence")));
        }
        catch (NumberFormatException l) {
            // empty catch block
        }
        l_IScheduleDTO.setTimezone((String)itemList.get("timezone"));
        try {
            l_IScheduleDTO.setTimezoneid(Long.parseLong((String)itemList.get("timezoneid")));
        }
        catch (NumberFormatException l) {
            // empty catch block
        }
        l_IScheduleDTO.setUid((String)itemList.get("uid"));
        l_IScheduleDTO.setVersion((String)itemList.get("version"));
        try {
            boolean b = false;
            long l = Long.parseLong((String)itemList.get("responserequested"));
            if (l != 0L) {
                b = true;
            }
            l_IScheduleDTO.setResponserequested(b);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return l_IScheduleDTO;
    }

    private Hashtable<String, String> populateRequestElements() {
        Hashtable<String, String> h = new Hashtable<String, String>();
        h.put("DAV:contentclass", "urn:content-classes:calendarmessage");
        h.put("http://schemas.microsoft.com/exchange/outlookmessageclass", "IPM.Schedule.Meeting.Request");
        h.put("http://schemas.microsoft.com/mapi/finvited", "1");
        h.put("http://schemas.microsoft.com/mapi/responsestatus", "1");
        h.put("http://schemas.microsoft.com/mapi/responsestate", "0");
        h.put("http://schemas.microsoft.com/mapi/response_requested", "1");
        h.put("http://schemas.microsoft.com/mapi/apptstateflags", "3");
        h.put("http://schemas.microsoft.com/mapi/busystatus", "1");
        h.put("http://schemas.microsoft.com/mapi/intendedbusystatus", "2");
        return h;
    }

    private Hashtable<String, String> populateNewScheduleElements() {
        Hashtable<String, String> h = new Hashtable<String, String>();
        h.put("DAV:contentclass", "urn:content-classes:appointment");
        h.put("http://schemas.microsoft.com/exchange/outlookmessageclass", "IPM.Appointment");
        return h;
    }

    private Hashtable<String, String> populateHashtable(IScheduleDTO dto) {
        Hashtable<String, String> h = new Hashtable<String, String>();
        String string = "dto=" + dto;
        Exch2kScheduleStoreImpl.debug_aroundBody5$advice(this, string, LogAspect.aspectOf(), string, null, ajc$tjp_2);
        if (dto.getSubject() != null) {
            h.put("urn:schemas:httpmail:subject", dto.getSubject());
        }
        if (dto.getLocation() != null) {
            h.put("urn:schemas:calendar:location", dto.getLocation());
        }
        if (dto.getBody() != null) {
            h.put("urn:schemas:httpmail:textdescription", dto.getBody());
        }
        if (dto.getStartDate() != null) {
            h.put("urn:schemas:calendar:dtstart", this.javaDate2MSDavDateStr(dto.getStartDate()));
        }
        if (dto.getEndDate() != null) {
            h.put("urn:schemas:calendar:dtend", this.javaDate2MSDavDateStr(dto.getEndDate()));
        }
        if (dto instanceof Exch2kScheduleDTO) {
            int i;
            Exch2kScheduleDTO dto2 = (Exch2kScheduleDTO)dto;
            if (dto2.isResponserequested()) {
                h.put("urn:schemas:calendar:responserequested", "1");
            } else {
                h.put("urn:schemas:calendar:responserequested", "0");
            }
            if (dto2.isAlldayevent()) {
                h.put("urn:schemas:calendar:alldayevent", "1");
            } else {
                h.put("urn:schemas:calendar:alldayevent", "0");
            }
            if (dto2.getBusystatus() != null) {
                h.put("urn:schemas:calendar:busystatus", dto2.getBusystatus());
            }
            h.put("urn:schemas:calendar:instancetype", "" + dto2.getInstancetype());
            if (dto2.getMeetingstatus() != null) {
                h.put("urn:schemas:calendar:meetingstatus", dto2.getMeetingstatus());
            }
            if (dto2.getRemindernexttime() != null) {
                h.put("urn:schemas:calendar:remindernexttime", this.javaDate2MSDavDateStr(dto2.getRemindernexttime()));
            }
            if (dto2.isReminderset()) {
                h.put("http://schemas.microsoft.com/mapi/reminderset", "1");
            } else {
                h.put("http://schemas.microsoft.com/mapi/reminderset", "0");
            }
            if (dto2.getUid() != null) {
                h.put("urn:schemas:calendar:uid", dto2.getUid());
            }
            MailAddress[] tmp = dto2.getTo();
            String addressStr = "";
            if (tmp != null) {
                i = 0;
                while (i < tmp.length) {
                    addressStr = String.valueOf(addressStr) + ((InternetAddress)this.populateAddress(tmp[i])).getAddress() + ",";
                    ++i;
                }
                if (addressStr.length() > 0) {
                    addressStr = addressStr.substring(0, addressStr.length() - 1);
                    h.put("urn:schemas:mailheader:to", addressStr);
                }
            }
            tmp = dto2.getCc();
            addressStr = "";
            if (tmp != null) {
                i = 0;
                while (i < tmp.length) {
                    addressStr = String.valueOf(addressStr) + ((InternetAddress)this.populateAddress(tmp[i])).getAddress() + ",";
                    ++i;
                }
                if (addressStr.length() > 0) {
                    addressStr = addressStr.substring(0, addressStr.length() - 1);
                    h.put("urn:schemas:mailheader:cc", addressStr);
                }
            }
            tmp = dto2.getBcc();
            addressStr = "";
            if (tmp != null) {
                i = 0;
                while (i < tmp.length) {
                    addressStr = String.valueOf(addressStr) + ((InternetAddress)this.populateAddress(tmp[i])).getAddress() + ",";
                    ++i;
                }
                if (addressStr.length() > 0) {
                    addressStr = addressStr.substring(0, addressStr.length() - 1);
                    h.put("urn:schemas:mailheader:bcc", addressStr);
                }
            }
        }
        return h;
    }

    @Override
    protected DavSearchCondition convertCondition(SearchCondition src) throws HandleException {
        throw new HandleException("Not yet implemented");
    }

    @Override
    protected String populateMessageFile(Hashtable<String, String> itemList) {
        String subject = itemList.get("urn:schemas:httpmail:subject");
        String body = itemList.get("urn:schemas:httpmail:textdescription");
        String location = itemList.get("urn:schemas:calendar:location");
        String startDate = itemList.get("urn:schemas:calendar:dtstart");
        String endDate = itemList.get("urn:schemas:calendar:dtend");
        String timeStampStr = this.javaDate2MSDavDateStr(new Date());
        String msg = "content-class: urn:content-classes:appointment\r\n";
        try {
            msg = String.valueOf(msg) + "Content-Transfer-Encoding: 8bit" + "\r\n";
            msg = String.valueOf(msg) + "Thread-Topic: " + MimeUtility.encodeText((String)subject, (String)"UTF-8", (String)"B") + "\r\n";
        }
        catch (Exception e) {
            Log.error((String)"Exception on creating MimeMessage", (Throwable)e);
        }
        String vcalStr = "";
        vcalStr = String.valueOf(vcalStr) + "BEGIN:VCALENDAR\r\n";
        vcalStr = String.valueOf(vcalStr) + "METHOD:REQUEST\r\n";
        vcalStr = String.valueOf(vcalStr) + "PRODID:Microsoft CDO for Microsoft Exchange\r\n";
        vcalStr = String.valueOf(vcalStr) + "VERSION:2.0\r\n";
        vcalStr = String.valueOf(vcalStr) + "BEGIN:VTIMEZONE\r\n";
        vcalStr = String.valueOf(vcalStr) + "TZID:Osaka\\, Sapporo\\, Tokyo\r\n";
        vcalStr = String.valueOf(vcalStr) + "X-MICROSOFT-CDO-TZID:20\r\n";
        vcalStr = String.valueOf(vcalStr) + "BEGIN:STANDARD\r\n";
        vcalStr = String.valueOf(vcalStr) + "DTSTART:16010101T000000\r\n";
        vcalStr = String.valueOf(vcalStr) + "TZOFFSETFROM:+0900\r\n";
        vcalStr = String.valueOf(vcalStr) + "TZOFFSETTO:+0900\r\n";
        vcalStr = String.valueOf(vcalStr) + "END:STANDARD\r\n";
        vcalStr = String.valueOf(vcalStr) + "BEGIN:DAYLIGHT\r\n";
        vcalStr = String.valueOf(vcalStr) + "DTSTART:16010101T000000\r\n";
        vcalStr = String.valueOf(vcalStr) + "TZOFFSETFROM:+0900\r\n";
        vcalStr = String.valueOf(vcalStr) + "TZOFFSETTO:+0900\r\n";
        vcalStr = String.valueOf(vcalStr) + "END:DAYLIGHT\r\n";
        vcalStr = String.valueOf(vcalStr) + "END:VTIMEZONE\r\n";
        vcalStr = String.valueOf(vcalStr) + "BEGIN:VEVENT\r\n";
        vcalStr = String.valueOf(vcalStr) + "DTSTAMP:" + timeStampStr + "\r\n";
        vcalStr = String.valueOf(vcalStr) + "DTSTART;TZID=\"Osaka, Sapporo, Tokyo\":" + startDate + "\r\n";
        vcalStr = String.valueOf(vcalStr) + "SUMMARY:" + subject + "\r\n";
        vcalStr = String.valueOf(vcalStr) + "UID:jp.co.amax." + timeStampStr + "\r\n";
        vcalStr = String.valueOf(vcalStr) + "DTEND;TZID=\"Osaka, Sapporo, Tokyo\":" + endDate + "\r\n";
        vcalStr = String.valueOf(vcalStr) + "LOCATION:" + location + "\r\n";
        vcalStr = String.valueOf(vcalStr) + "DESCRIPTION:" + body.replaceAll("\n", "\\\\N").replaceAll("\r", "") + "\r\n";
        vcalStr = String.valueOf(vcalStr) + "SEQUENCE:0\r\n";
        vcalStr = String.valueOf(vcalStr) + "PRIORITY:5\r\n";
        vcalStr = String.valueOf(vcalStr) + "CLASS:\r\n";
        vcalStr = String.valueOf(vcalStr) + "CREATED:" + timeStampStr + "\r\n";
        vcalStr = String.valueOf(vcalStr) + "LAST-MODIFIED:" + timeStampStr + "\r\n";
        vcalStr = String.valueOf(vcalStr) + "STATUS:TENTATIVE\r\n";
        vcalStr = String.valueOf(vcalStr) + "TRANSP:OPAQUE\r\n";
        vcalStr = String.valueOf(vcalStr) + "X-MICROSOFT-CDO-BUSYSTATUS:BUSY\r\n";
        vcalStr = String.valueOf(vcalStr) + "X-MICROSOFT-CDO-INSTTYPE:0\r\n";
        vcalStr = String.valueOf(vcalStr) + "X-MICROSOFT-CDO-ALLDAYEVENT:FALSE\r\n";
        vcalStr = String.valueOf(vcalStr) + "X-MICROSOFT-CDO-IMPORTANCE:1\r\n";
        vcalStr = String.valueOf(vcalStr) + "X-MICROSOFT-CDO-OWNERAPPTID:-1\r\n";
        vcalStr = String.valueOf(vcalStr) + "END:VEVENT\r\n";
        vcalStr = String.valueOf(vcalStr) + "END:VCALENDAR\r\n";
        String string = "vcalStr=" + vcalStr;
        Exch2kScheduleStoreImpl.debug_aroundBody7$advice(this, string, LogAspect.aspectOf(), string, null, ajc$tjp_3);
        try {
            String tmp;
            MimeMessage mmsg = new MimeMessage(null);
            MimeMultipart part = new MimeMultipart();
            MimeBodyPart pbody = new MimeBodyPart();
            mmsg.setSubject(subject, "UTF-8");
            pbody.setText(vcalStr, "UTF-8");
            part.addBodyPart((BodyPart)pbody);
            pbody.setHeader("Content-Type", "text/calendar; method=REQUEST; charset='UTF-8'");
            mmsg.setContent((Multipart)part);
            mmsg.saveChanges();
            Enumeration lines = mmsg.getAllHeaderLines();
            while (lines.hasMoreElements()) {
                msg = String.valueOf(msg) + (String)lines.nextElement() + "\r\n";
            }
            msg = String.valueOf(msg) + "\r\n";
            msg = String.valueOf(msg) + "content-class: urn:content-classes:appointment\r\n";
            InputStream is = mmsg.getInputStream();
            BufferedReader b = new BufferedReader(new InputStreamReader(is));
            while ((tmp = b.readLine()) != null) {
                msg = String.valueOf(msg) + tmp + "\r\n";
            }
        }
        catch (Exception e) {
            Log.error((String)"Exception on creating MimeMessage", (Throwable)e);
        }
        return msg;
    }

    public ISearchDestination getPresetDestination(IAccountData acc, int type) throws IncorrectData, HandleException {
        super.setAccountData((PasswordBasedAccountDataImpl)acc);
        IFolderIndex folder = null;
        IDatabaseIndex db = null;
        switch (type) {
            case 1: {
                folder = (IFolderIndex)this.populateFolder(this.scheduleElement).getOid();
                break;
            }
            case 2: {
                folder = (IFolderIndex)this.populateFolder(this.scheduleElement).getOid();
                break;
            }
            default: {
                throw new IncorrectData("illegal folderType");
            }
        }
        return new BasicSearchDestination(db, folder);
    }

    @Override
    protected String getElmentName() {
        return "\u4e88\u5b9a\u8868";
    }

    private static final /* synthetic */ void debug_aroundBody0(Exch2kScheduleStoreImpl exch2kScheduleStoreImpl, String string) {
        Log.debug((String)string);
    }

    private static final /* synthetic */ void debug_aroundBody1$advice(Exch2kScheduleStoreImpl ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exch2k_log_LogAspect$jp_co_connectone_eai_exch2k_log_LogAspect$log(ajc$aspectInstance).isDebugEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exch2k_log_LogAspect$jp_co_connectone_eai_exch2k_log_LogAspect$log(ajc$aspectInstance).debug((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final /* synthetic */ void debug_aroundBody2(Exch2kScheduleStoreImpl exch2kScheduleStoreImpl, String string) {
        Log.debug((String)string);
    }

    private static final /* synthetic */ void debug_aroundBody3$advice(Exch2kScheduleStoreImpl ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exch2k_log_LogAspect$jp_co_connectone_eai_exch2k_log_LogAspect$log(ajc$aspectInstance).isDebugEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exch2k_log_LogAspect$jp_co_connectone_eai_exch2k_log_LogAspect$log(ajc$aspectInstance).debug((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final /* synthetic */ void debug_aroundBody4(Exch2kScheduleStoreImpl exch2kScheduleStoreImpl, String string) {
        Log.debug((String)string);
    }

    private static final /* synthetic */ void debug_aroundBody5$advice(Exch2kScheduleStoreImpl ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exch2k_log_LogAspect$jp_co_connectone_eai_exch2k_log_LogAspect$log(ajc$aspectInstance).isDebugEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exch2k_log_LogAspect$jp_co_connectone_eai_exch2k_log_LogAspect$log(ajc$aspectInstance).debug((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final /* synthetic */ void debug_aroundBody6(Exch2kScheduleStoreImpl exch2kScheduleStoreImpl, String string) {
        Log.debug((String)string);
    }

    private static final /* synthetic */ void debug_aroundBody7$advice(Exch2kScheduleStoreImpl ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exch2k_log_LogAspect$jp_co_connectone_eai_exch2k_log_LogAspect$log(ajc$aspectInstance).isDebugEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exch2k_log_LogAspect$jp_co_connectone_eai_exch2k_log_LogAspect$log(ajc$aspectInstance).debug((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("Exch2kScheduleStoreImpl.java", Class.forName("jp.co.connectone.eai.exch2k.store.Exch2kScheduleStoreImpl"));
        ajc$tjp_0 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "debug", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 233);
        ajc$tjp_1 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "debug", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 295);
        ajc$tjp_2 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "debug", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 464);
        ajc$tjp_3 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "debug", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 623);
    }
}

