/*
 * Decompiled with CFR 0.152.
 */
package jp.co.connectone.eai.exch2k.store;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Vector;
import jp.co.connectone.eai.exch2k.dav.DavSearchCondition;
import jp.co.connectone.eai.exch2k.log.LogAspect;
import jp.co.connectone.eai.exch2k.store.EAIExch2kBase;
import jp.co.connectone.eai.exch2k.store.Exch2kFolderIndex;
import jp.co.connectone.eai.exch2k.store.Exch2kObjectIndex;
import jp.co.connectone.eai.exch2k.store.Exch2kServiceInfo;
import jp.co.connectone.exception.DataNotFound;
import jp.co.connectone.exception.DeleteFailed;
import jp.co.connectone.exception.HandleException;
import jp.co.connectone.exception.IncorrectData;
import jp.co.connectone.exception.IncorrectStore;
import jp.co.connectone.exception.NoSuchRights;
import jp.co.connectone.exception.SearchConditionFailed;
import jp.co.connectone.exception.ServerDown;
import jp.co.connectone.exception.UpdateFailed;
import jp.co.connectone.log.Log;
import jp.co.connectone.service.IServiceInfo;
import jp.co.connectone.service.IServiceInfoRawData;
import jp.co.connectone.store.BasicSearchDestination;
import jp.co.connectone.store.FolderMetadata;
import jp.co.connectone.store.IDatabaseIndex;
import jp.co.connectone.store.IFolderIndex;
import jp.co.connectone.store.IObjectIndex;
import jp.co.connectone.store.IRecordObject;
import jp.co.connectone.store.ISearchDestination;
import jp.co.connectone.store.ISearchFormula;
import jp.co.connectone.store.IStoreID;
import jp.co.connectone.store.SearchCondition;
import jp.co.connectone.store.SimpleStoreID;
import jp.co.connectone.store.pim.BasicMemoDTO;
import jp.co.connectone.store.pim.IMemoDTO;
import jp.co.connectone.store.pim.IMemoStore;
import jp.co.connectone.user.IAccountData;
import jp.co.connectone.user.PasswordBasedAccountDataImpl;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.AroundClosure;
import org.aspectj.runtime.reflect.Factory;

public class Exch2kMemoStoreImpl
extends EAIExch2kBase
implements IMemoStore {
    private static final String DEFAULT_EXCHANGE_MEMO_PATH_ELEMENT = "\u30e1\u30e2";
    private IFolderIndex memoElement = new Exch2kFolderIndex("\u30e1\u30e2");
    protected static final String elmentName = "\u30e1\u30e2";
    public static final IStoreID storeID;
    public static final String storeName = "Exchange2K memo store";
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

    static {
        Exch2kMemoStoreImpl.ajc$preClinit();
        storeID = new SimpleStoreID(Exch2kMemoStoreImpl.class.getName());
    }

    public String getName() throws Exception {
        return storeName;
    }

    public IServiceInfo getServiceInfo(IServiceInfoRawData serviceData) throws Exception {
        return super.getServiceInfo(storeID, storeName, serviceData);
    }

    public IServiceInfo getServiceInfo() throws Exception {
        return new Exch2kServiceInfo(storeID, storeName);
    }

    public IStoreID getStoreID() throws Exception {
        return storeID;
    }

    public IMemoDTO[] getAllMemos(IAccountData acc) throws IncorrectData, NoSuchRights, ServerDown, DataNotFound, IncorrectStore, SearchConditionFailed, HandleException {
        IMemoDTO[] l_scheduleDtoArray = null;
        Vector<String> v = this.makeItemList();
        this.setAccountData((PasswordBasedAccountDataImpl)acc);
        Vector<HashMap<String, Object>> col = super.getList(this.memoElement, v);
        int len = col.size();
        l_scheduleDtoArray = new IMemoDTO[len];
        int i = 0;
        while (i < len) {
            l_scheduleDtoArray[i] = this.populateMemoDTO(col.elementAt(i));
            ++i;
        }
        return l_scheduleDtoArray;
    }

    public IMemoDTO[] getMemosByDate(IAccountData acc, Date dateObj) throws IncorrectData, NoSuchRights, ServerDown, DataNotFound, IncorrectStore, SearchConditionFailed, HandleException {
        IMemoDTO[] l_scheduleDtoArray = null;
        Vector<String> v = this.makeItemList();
        this.setAccountData((PasswordBasedAccountDataImpl)acc);
        Vector<HashMap<String, Object>> col = super.getListByDate(this.memoElement, v, dateObj, "urn:schemas:httpmail:datereceived");
        int len = col.size();
        l_scheduleDtoArray = new IMemoDTO[len];
        int i = 0;
        while (i < len) {
            l_scheduleDtoArray[i] = this.populateMemoDTO(col.elementAt(i));
            ++i;
        }
        return l_scheduleDtoArray;
    }

    private Vector<String> makeItemList() {
        Vector<String> v = new Vector<String>();
        v.add("DAV:id");
        v.add("DAV:href");
        v.add("urn:schemas:httpmail:subject");
        v.add("urn:schemas:httpmail:textdescription");
        v.add("urn:schemas:httpmail:sendername");
        v.add("urn:schemas:httpmail:datereceived");
        return v;
    }

    public IMemoDTO getMemoByOID(IAccountData acc, IObjectIndex oid) throws IncorrectData, NoSuchRights, ServerDown, DataNotFound, IncorrectStore, HandleException {
        String string = "getMemoByOID::oid=" + oid;
        Exch2kMemoStoreImpl.debug_aroundBody1$advice(this, string, LogAspect.aspectOf(), string, null, ajc$tjp_0);
        this.setAccountData((PasswordBasedAccountDataImpl)acc);
        HashMap<String, Object> memo = super.getProps((String)oid.getIndex(), this.makeItemList());
        return this.populateMemoDTO(memo);
    }

    public IObjectIndex createNewMemo(IAccountData acc, IMemoDTO IMemoDTO2) throws IncorrectData, NoSuchRights, DataNotFound, IncorrectStore, ServerDown, HandleException {
        IObjectIndex oid = null;
        Hashtable<String, String> h = this.populateHashtable(IMemoDTO2);
        this.setAccountData((PasswordBasedAccountDataImpl)acc);
        String url = String.valueOf(this.generateBaseURL()) + "\u30e1\u30e2" + "/" + new Date().getTime() + ".EML";
        oid = super.saveData(this.escapeURL(url), h);
        return oid;
    }

    public IObjectIndex updateMemo(IAccountData acc, IMemoDTO objIMemoDTO) throws IncorrectData, NoSuchRights, ServerDown, DataNotFound, IncorrectStore, SearchConditionFailed, UpdateFailed, HandleException {
        IObjectIndex oid = null;
        Hashtable<String, String> h = this.populateHashtable(objIMemoDTO);
        this.setAccountData((PasswordBasedAccountDataImpl)acc);
        String url = (String)objIMemoDTO.getOid().getIndex();
        oid = super.saveData(url, h);
        return oid;
    }

    public void deleteMemo(IAccountData acc, IObjectIndex oid) throws IncorrectData, DeleteFailed, NoSuchRights, ServerDown, DataNotFound, IncorrectStore, SearchConditionFailed, HandleException {
        this.setAccountData((PasswordBasedAccountDataImpl)acc);
        super.delete(oid);
    }

    private Hashtable<String, String> populateHashtable(IMemoDTO memo) {
        Hashtable<String, String> h = new Hashtable<String, String>();
        String string = "memo=" + memo;
        Exch2kMemoStoreImpl.debug_aroundBody3$advice(this, string, LogAspect.aspectOf(), string, null, ajc$tjp_1);
        if (memo.getSubject() != null) {
            h.put("urn:schemas:httpmail:subject", memo.getSubject());
        }
        if (memo.getBody() != null) {
            h.put("urn:schemas:httpmail:textdescription", memo.getBody());
        }
        if (memo.getSenderName() != null) {
            h.put("urn:schemas:httpmail:sendername", memo.getSenderName());
        }
        return h;
    }

    private IMemoDTO populateMemoDTO(HashMap<String, Object> itemList) throws ServerDown, DataNotFound {
        BasicMemoDTO l_IMemoDTO = new BasicMemoDTO();
        l_IMemoDTO.setNew(false);
        l_IMemoDTO.setTid((String)itemList.get("id"));
        l_IMemoDTO.setOid((IObjectIndex)new Exch2kObjectIndex(itemList.get("href")));
        l_IMemoDTO.setSubject((String)itemList.get("subject"));
        l_IMemoDTO.setBody((String)itemList.get("textdescription"));
        l_IMemoDTO.setSenderName((String)itemList.get("sendername"));
        l_IMemoDTO.setDate(this.davDateStr2JavaDate((String)itemList.get("datereceived")));
        return l_IMemoDTO;
    }

    @Override
    protected DavSearchCondition convertCondition(SearchCondition src) throws HandleException {
        throw new UnsupportedOperationException("convertCondition not yet supported.");
    }

    public void delete(IAccountData acc, ISearchDestination dest, IObjectIndex oid) throws Exception {
        this.deleteMemo(acc, oid);
    }

    public IRecordObject[] getAllDatas(IAccountData acc, ISearchDestination dest) throws Exception {
        return this.getAllMemos(acc);
    }

    public FolderMetadata[] getFolderList(IAccountData acc, ISearchDestination dest) throws Exception {
        FolderMetadata[] l_strFolderlist = new FolderMetadata[]{};
        this.setAccountData((PasswordBasedAccountDataImpl)acc);
        IFolderIndex path = dest.getFolder();
        if (path == null) {
            path = this.memoElement;
        }
        Vector<Object> lists = super.getAllSubFolders((String)path.getIndex());
        ArrayList<FolderMetadata> arrFolderlist = this.populateFolderList(0, (String)path.getIndex(), lists);
        l_strFolderlist = arrFolderlist.toArray(l_strFolderlist);
        int i = 0;
        while (i < l_strFolderlist.length) {
            if (l_strFolderlist[i].getFolderName().length() == 0) {
                l_strFolderlist[i].setFolderName((String)path.getIndex());
            }
            ++i;
        }
        return l_strFolderlist;
    }

    public IRecordObject read(IAccountData acc, ISearchDestination dest, IObjectIndex oid) throws Exception {
        return this.getMemoByOID(acc, oid);
    }

    public IRecordObject[] search(IAccountData acc, ISearchFormula col) throws Exception {
        throw new UnsupportedOperationException("search not yet supported.");
    }

    public IRecordObject[] searchByDate(IAccountData acc, ISearchDestination dest, Date date) throws Exception {
        throw new UnsupportedOperationException("searchByDate not yet supported.");
    }

    public IObjectIndex write(IAccountData acc, ISearchDestination dest, IRecordObject data) throws Exception {
        IObjectIndex rc = null;
        rc = data.isNew() ? this.createNewMemo(acc, (IMemoDTO)data) : this.updateMemo(acc, (IMemoDTO)data);
        return rc;
    }

    public ISearchDestination getPresetDestination(IAccountData acc, int type) throws IncorrectData, HandleException {
        super.setAccountData((PasswordBasedAccountDataImpl)acc);
        IFolderIndex folder = null;
        IDatabaseIndex db = null;
        switch (type) {
            case 1: {
                folder = (IFolderIndex)this.populateFolder(this.memoElement).getOid();
                break;
            }
            default: {
                throw new IncorrectData("illegal folderType");
            }
        }
        return new BasicSearchDestination(db, folder);
    }

    @Override
    protected String getElmentName() {
        return "\u30e1\u30e2";
    }

    private static final /* synthetic */ void debug_aroundBody0(Exch2kMemoStoreImpl exch2kMemoStoreImpl, String string) {
        Log.debug((String)string);
    }

    private static final /* synthetic */ void debug_aroundBody1$advice(Exch2kMemoStoreImpl ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exch2k_log_LogAspect$jp_co_connectone_eai_exch2k_log_LogAspect$log(ajc$aspectInstance).isDebugEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exch2k_log_LogAspect$jp_co_connectone_eai_exch2k_log_LogAspect$log(ajc$aspectInstance).debug((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final /* synthetic */ void debug_aroundBody2(Exch2kMemoStoreImpl exch2kMemoStoreImpl, String string) {
        Log.debug((String)string);
    }

    private static final /* synthetic */ void debug_aroundBody3$advice(Exch2kMemoStoreImpl ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exch2k_log_LogAspect$jp_co_connectone_eai_exch2k_log_LogAspect$log(ajc$aspectInstance).isDebugEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exch2k_log_LogAspect$jp_co_connectone_eai_exch2k_log_LogAspect$log(ajc$aspectInstance).debug((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("Exch2kMemoStoreImpl.java", Class.forName("jp.co.connectone.eai.exch2k.store.Exch2kMemoStoreImpl"));
        ajc$tjp_0 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "debug", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 95);
        ajc$tjp_1 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "debug", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 138);
    }
}

