/*
 * Decompiled with CFR 0.152.
 */
package jp.co.connectone.user;

import java.lang.reflect.Constructor;
import jp.co.connectone.log.Log;
import jp.co.connectone.service.IServiceInfo;
import jp.co.connectone.store.BasicRecordObject;
import jp.co.connectone.user.IAccountData;
import jp.co.connectone.user.IUserKey;

public abstract class AccountData
extends BasicRecordObject
implements IAccountData {
    private static final long serialVersionUID = 1L;
    protected IServiceInfo serviceInfo;
    private IUserKey uid;

    public static IAccountData getInstance(IUserKey uid, IServiceInfo serviceInfo) {
        IAccountData rc = null;
        String className = serviceInfo.getAccountClassName();
        Object[] param = new Object[]{uid, serviceInfo};
        Class[] paramTypes = new Class[]{IUserKey.class, IServiceInfo.class};
        try {
            Class<?> cl = Class.forName(className);
            Constructor<?> c = cl.getConstructor(paramTypes);
            rc = (IAccountData)c.newInstance(param);
        }
        catch (Exception e) {
            Log.error("failed to make instance of " + className, e);
        }
        return rc;
    }

    protected AccountData() {
        throw new NullPointerException("serviceInfo must not be null");
    }

    public AccountData(IUserKey uid, IServiceInfo serviceInfo) {
        this.setServiceInfo(serviceInfo);
        this.setUid(uid);
    }

    @Override
    public IServiceInfo getServiceInfo() {
        return this.serviceInfo;
    }

    @Override
    public void setServiceInfo(IServiceInfo serviceInfo) {
        this.serviceInfo = serviceInfo;
    }

    @Override
    public IUserKey getUid() {
        return this.uid;
    }

    @Override
    public void setUid(IUserKey uid) {
        this.uid = uid;
        this.oid = uid;
    }
}

