/*
 * Decompiled with CFR 0.152.
 */
package jp.co.connectone.webapps.helpers;

import java.util.Comparator;
import java.util.Date;
import jp.co.connectone.store.pim.BasicScheduleDTO;
import jp.co.connectone.store.pim.ScheduleParseHelper;
import jp.co.connectone.webapps.helpers.WebParserAggregationBase;
import jp.co.connectone.webapps.helpers.WebScheduleParseHelperComparator;
import jp.co.connectone.webapps.tools.DateControler;

public class WebScheduleParseHelper
extends ScheduleParseHelper {
    private static final long serialVersionUID = 1L;
    protected WebParserAggregationBase extention = new WebParserAggregationBase();

    public WebScheduleParseHelper() {
        this.initDTO();
    }

    private void initDTO() {
        this.schedule = new BasicScheduleDTO();
        this.schedule.setBody("");
        this.schedule.setStartDate(new Date());
        this.schedule.setEndDate(new Date());
        this.schedule.setLocation("");
        this.schedule.setSubject("\u7121\u984c");
        String bodyStr = new String("");
        String[] l_byteFilestream = new String[]{bodyStr};
    }

    public void escapeTags() {
        this.schedule.setBody(this.extention.escapeTags(this.schedule.getBody()));
        this.schedule.setSubject(this.extention.escapeTags(this.schedule.getSubject()));
        this.schedule.setLocation(this.extention.escapeTags(this.schedule.getLocation()));
    }

    public int getPrevPage() {
        return this.extention.getPrevPage();
    }

    public int getNextPage() {
        return this.extention.getNextPage();
    }

    public String getBodyHtml() {
        String rc = super.getBody();
        if (rc == null) {
            return rc;
        }
        rc = this.extention.pagingString(rc);
        rc = this.extention.escapeTags(rc);
        rc = this.extention.formatBody(rc);
        return rc;
    }

    public String getSubject() {
        String rc = super.getSubject();
        if (rc == null) {
            return "\u7121\u984c";
        }
        if (rc.length() == 0) {
            return "\u7121\u984c";
        }
        return rc;
    }

    public static Comparator<WebScheduleParseHelper> getComparator() {
        return new WebScheduleParseHelperComparator();
    }

    public int getBodyLength() {
        return this.extention.getBodyLength();
    }

    public void setBodyLength(int bodyLength) {
        this.extention.setBodyLength(bodyLength);
    }

    public int getCurrentPage() {
        return this.extention.getCurrentPage();
    }

    public void setCurrentPage(int currentPage) {
        this.extention.setCurrentPage(currentPage);
    }

    public WebScheduleParseHelper(ScheduleParseHelper org) {
        super(org.getScheduleDTO());
        super.setTid("" + this.extention.getNextID());
    }

    public int getLastPage() {
        return this.extention.getLastPage(super.getBody());
    }

    public String getStartDateStr() {
        return DateControler.getDateStr(this.getStartDate());
    }

    public String getEndDateStr() {
        return DateControler.getDateStr(this.getEndDate());
    }

    public String getStartHourStr() {
        return DateControler.getHourStr(this.getStartDate());
    }

    public String getEndHourStr() {
        return DateControler.getHourStr(this.getEndDate());
    }
}

