/*
 * Decompiled with CFR 0.152.
 */
package jp.co.connectone.eai.jdbc.store;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import jp.co.connectone.eai.jdbc.store.EAIJdbcBase;
import jp.co.connectone.eai.jdbc.store.HSQLServiceInfo;
import jp.co.connectone.eai.jdbc.store.IJdbcDBStore;
import jp.co.connectone.eai.jdbc.store.JdbcJNDIServiceInfo;
import jp.co.connectone.eai.jdbc.store.JdbcTableIndex;
import jp.co.connectone.eai.jdbc.store.MSSQLServiceInfo;
import jp.co.connectone.eai.jdbc.store.MYSQLServiceInfo;
import jp.co.connectone.exception.DataNotFound;
import jp.co.connectone.exception.HandleException;
import jp.co.connectone.exception.IncorrectData;
import jp.co.connectone.exception.IncorrectStore;
import jp.co.connectone.exception.NoSuchRights;
import jp.co.connectone.exception.ServerDown;
import jp.co.connectone.exception.StoreNotFound;
import jp.co.connectone.service.IServiceInfo;
import jp.co.connectone.store.BasicRecordObject;
import jp.co.connectone.store.BasicSearchDestination;
import jp.co.connectone.store.FolderMetadata;
import jp.co.connectone.store.IDatabaseIndex;
import jp.co.connectone.store.IFolderIndex;
import jp.co.connectone.store.IObjectIndex;
import jp.co.connectone.store.IRecordObject;
import jp.co.connectone.store.ISearchDestination;
import jp.co.connectone.store.IStoreID;
import jp.co.connectone.store.SimpleStoreID;
import jp.co.connectone.store.pim.BasicMailDTO;
import jp.co.connectone.store.pim.IMailDTO;
import jp.co.connectone.store.pim.IMailStore;
import jp.co.connectone.user.IAccountData;

public class JdbcMailStoreImpl
extends EAIJdbcBase
implements IMailStore {
    private static final String DEFAULT_JDBC_INBOX_PATH_ELEMENT = "INMAIL";
    private static final String DEFAULT_JDBC_SENTBOX_PATH_ELEMENT = "SENTMAIL";
    private static final String DEFAULT_JDBC_SENDMAIL_PATH_ELEMENT = "MAILSENDBOX";
    public static final int DEST_TYPE_DEFAULT_MAIL_FOLDER = 1;
    public static final int DEST_TYPE_SENT_FOLDER = 2;
    public static final int DEST_TYPE_JUNK_FOLDER = 5;
    public static final int DEST_TYPE_DRAFT_FOLDER = 3;
    public static final int DEST_TYPE_TRASH_FOLDER = 4;
    public static final int DEST_TYPE_SENDBOX = 102;
    private IFolderIndex inboxElement = new JdbcTableIndex("INMAIL");
    private IFolderIndex sentboxElement = new JdbcTableIndex("SENTMAIL");
    private IFolderIndex sendmailElement = new JdbcTableIndex("MAILSENDBOX");
    public static final IStoreID storeID = new SimpleStoreID(JdbcMailStoreImpl.class.getName());
    public static final String storeName = "Jdbc mail store";

    public IObjectIndex[] getUIDLs(IAccountData acc, ISearchDestination dest) throws StoreNotFound, ServerDown, NoSuchRights, IncorrectStore, DataNotFound, IncorrectData, HandleException {
        throw new HandleException("JdbcMailStore does not support getUIDLs.");
    }

    public IObjectIndex[] getUIDLsByDate(IAccountData acc, ISearchDestination dest, Date lastDate) throws StoreNotFound, ServerDown, NoSuchRights, IncorrectStore, DataNotFound, IncorrectData, HandleException {
        throw new HandleException("JdbcMailStore does not support getUIDLsByDate.");
    }

    public String getName() throws Exception {
        return storeName;
    }

    @Override
    public IServiceInfo getServiceInfo(IJdbcDBStore.EnumEngineType engine) throws Exception {
        switch (engine) {
            case ENGINE_TYPE_HSQLDB: {
                return new HSQLServiceInfo(storeID, storeName);
            }
            case ENGINE_TYPE_MSSQL: {
                return new MSSQLServiceInfo(storeID, storeName);
            }
            case ENGINE_TYPE_MYSQL: {
                return new MYSQLServiceInfo(storeID, storeName);
            }
        }
        throw new IllegalArgumentException("Non-supported EngineType.");
    }

    @Override
    public IServiceInfo getServiceInfo() throws Exception {
        return new JdbcJNDIServiceInfo(storeID, storeName);
    }

    public IStoreID getStoreID() throws Exception {
        return storeID;
    }

    public FolderMetadata[] getMailFolders(IAccountData acc, ISearchDestination dest) throws StoreNotFound, NoSuchRights, ServerDown, IncorrectStore, DataNotFound, IncorrectData, HandleException {
        FolderMetadata[] rc = null;
        try {
            rc = super.getFolderList(acc, dest);
        }
        catch (NoSuchRights nsre) {
            throw nsre;
        }
        catch (ServerDown sde) {
            throw sde;
        }
        catch (IncorrectData ide) {
            throw ide;
        }
        catch (HandleException hee) {
            throw hee;
        }
        catch (Exception e) {
            throw new HandleException((Throwable)e);
        }
        return rc;
    }

    public IMailDTO[] getHeaders(IAccountData acc, ISearchDestination dest) throws StoreNotFound, ServerDown, NoSuchRights, IncorrectStore, DataNotFound, IncorrectData, HandleException {
        return this.getMailsFromTable(acc, dest);
    }

    public IMailDTO[] getHeadersByDate(IAccountData acc, ISearchDestination dest, Date date) throws StoreNotFound, ServerDown, NoSuchRights, IncorrectStore, DataNotFound, IncorrectData, HandleException {
        return this.getMailsFromTableByDate(acc, dest, date);
    }

    public IMailDTO getMail(IAccountData acc, ISearchDestination dest, IObjectIndex oid) throws StoreNotFound, ServerDown, NoSuchRights, IncorrectStore, DataNotFound, IncorrectData, HandleException {
        BasicMailDTO mail = null;
        try {
            IRecordObject obj = super.read(acc, dest, oid);
            if (obj != null) {
                mail = new BasicMailDTO();
                mail = (BasicMailDTO)obj.getBean((IRecordObject)mail);
            }
        }
        catch (NoSuchRights nsre) {
            throw nsre;
        }
        catch (ServerDown sde) {
            throw sde;
        }
        catch (IncorrectData ide) {
            throw ide;
        }
        catch (HandleException hee) {
            throw hee;
        }
        catch (Exception e) {
            throw new HandleException((Throwable)e);
        }
        return mail;
    }

    public IMailDTO[] getMailsByDate(IAccountData acc, ISearchDestination dest, Date dateObj) throws StoreNotFound, NoSuchRights, ServerDown, DataNotFound, IncorrectStore, IncorrectData, HandleException {
        return this.getMailsFromTableByDate(acc, dest, dateObj);
    }

    protected IMailDTO[] getMailsFromTable(IAccountData acc, ISearchDestination dest) throws ServerDown, HandleException {
        BasicRecordObject[] mails = null;
        BasicMailDTO[] rc = null;
        try {
            mails = (BasicRecordObject[])super.getAllDatas(acc, dest);
            if (mails == null) {
                return new BasicMailDTO[0];
            }
            rc = new BasicMailDTO[mails.length];
            int i = 0;
            while (i < mails.length) {
                rc[i] = new BasicMailDTO();
                rc[i] = (BasicMailDTO)mails[i].getBean((IRecordObject)rc[i]);
                ++i;
            }
        }
        catch (NoSuchRights nsre) {
            throw nsre;
        }
        catch (ServerDown sde) {
            throw sde;
        }
        catch (IncorrectData ide) {
            throw ide;
        }
        catch (HandleException hee) {
            throw hee;
        }
        catch (Exception e) {
            throw new HandleException((Throwable)e);
        }
        return rc;
    }

    protected IMailDTO[] getMailsFromTableByDate(IAccountData acc, ISearchDestination dest, Date date) throws ServerDown, HandleException {
        BasicMailDTO[] rc = new BasicMailDTO[]{};
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(10, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        Date startDateTime = cal.getTime();
        cal.set(10, 23);
        cal.set(12, 59);
        cal.set(13, 59);
        cal.set(14, 999);
        Date endDateTime = cal.getTime();
        IMailDTO[] mails = this.getMailsFromTable(acc, dest);
        ArrayList<IMailDTO> rmails = new ArrayList<IMailDTO>();
        int i = 0;
        while (i < mails.length) {
            Date checkDate = mails[i].getReceivedDate();
            if (!startDateTime.after(checkDate) && !endDateTime.before(checkDate)) {
                rmails.add(mails[i]);
            }
            ++i;
        }
        rc = rmails.toArray(rc);
        return rc;
    }

    public IMailDTO[] getSentMails(IAccountData acc) throws ServerDown, HandleException {
        ISearchDestination dest = this.getPresetDestination(acc, 2);
        return this.getMailsFromTable(acc, dest);
    }

    public IMailDTO[] getSentMailsByDate(IAccountData acc, Date dateObj) throws ServerDown, HandleException {
        ISearchDestination dest = this.getPresetDestination(acc, 2);
        return this.getMailsFromTableByDate(acc, dest, dateObj);
    }

    public IObjectIndex sendMail(IAccountData acc, IMailDTO mailDTOobj) throws NoSuchRights, ServerDown, IncorrectData, HandleException {
        try {
            return super.write(acc, this.getPresetDestination(acc, 102), (IRecordObject)mailDTOobj);
        }
        catch (NoSuchRights nsre) {
            throw nsre;
        }
        catch (ServerDown sde) {
            throw sde;
        }
        catch (IncorrectData ide) {
            throw ide;
        }
        catch (HandleException hee) {
            throw hee;
        }
        catch (Exception e) {
            throw new HandleException((Throwable)e);
        }
    }

    public void deleteMail(IAccountData acc, ISearchDestination dest, IObjectIndex oid) throws ServerDown, NoSuchRights, DataNotFound, IncorrectData, HandleException {
        try {
            super.delete(acc, dest, oid);
        }
        catch (NoSuchRights nsre) {
            throw nsre;
        }
        catch (ServerDown sde) {
            throw sde;
        }
        catch (IncorrectData ide) {
            throw ide;
        }
        catch (HandleException hee) {
            throw hee;
        }
        catch (Exception e) {
            throw new HandleException((Throwable)e);
        }
    }

    public ISearchDestination getPresetDestination(IAccountData acc, int type) throws IncorrectData, HandleException {
        IFolderIndex folder = null;
        IDatabaseIndex db = null;
        switch (type) {
            case 1: {
                folder = (IFolderIndex)this.populateFolder(this.inboxElement).getOid();
                break;
            }
            case 2: {
                folder = (IFolderIndex)this.populateFolder(this.sentboxElement).getOid();
                break;
            }
            case 102: {
                folder = (IFolderIndex)this.populateFolder(this.sendmailElement).getOid();
                break;
            }
            default: {
                throw new IncorrectData("illegal folderType");
            }
        }
        return new BasicSearchDestination(db, folder);
    }

    public void deleteMail(IAccountData acc, IObjectIndex oid) throws ServerDown, NoSuchRights, DataNotFound, IncorrectData, HandleException {
    }
}

