/*
 * Decompiled with CFR 0.152.
 */
package jp.co.connectone.common;

import java.util.Properties;
import javax.naming.CommunicationException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;
import jp.co.connectone.common.ActiveActiveServerToolBaseImpl;
import jp.co.connectone.exception.HandleException;
import jp.co.connectone.log.Log;

public class DNSTool
extends ActiveActiveServerToolBaseImpl {
    private static boolean toggle = false;
    private int toggleCount;
    protected String dnsServerIP = null;
    protected String dnsServerIP2 = null;

    @Override
    public int getToggleCount() {
        return this.toggleCount;
    }

    @Override
    public void setToggleCount(int toggleCount) {
        this.toggleCount = toggleCount;
    }

    @Override
    public boolean isToggle() {
        return toggle;
    }

    @Override
    public void setToggle(boolean toggle) {
        DNSTool.toggle = toggle;
    }

    public DNSTool(String serverIP, String serverIP2) {
        this.dnsServerIP = serverIP;
        this.dnsServerIP2 = serverIP2;
    }

    public String getIPAddress(String name) throws HandleException {
        Properties props = new Properties();
        props.put("java.naming.factory.initial", "com.sun.jndi.dns.DnsContextFactory");
        props.put("java.naming.provider.url", "dns://" + this.getServerToConnect(this.dnsServerIP, this.dnsServerIP2));
        String retStr = null;
        try {
            InitialDirContext idctx = new InitialDirContext(props);
            Attributes attrs = idctx.getAttributes(name);
            NamingEnumeration<? extends Attribute> allAttr = attrs.getAll();
            while (allAttr.hasMore()) {
                Attribute attr = allAttr.next();
                NamingEnumeration<?> values = attr.getAll();
                if (!values.hasMore()) continue;
                retStr = (String)values.next();
            }
        }
        catch (CommunicationException ce) {
            if (this.toggleOn()) {
                return this.getIPAddress(name);
            }
            throw new HandleException(ce);
        }
        catch (NamingException e) {
            Log.error("error on getting IPAddress from DNS", e);
            throw new HandleException(e);
        }
        return retStr;
    }
}

