﻿import std.stdio, std.string, std.conv, std.file, std.windows.charset, std.cstream;

void main(string[] args)
{
	auto arg = new Args(args);
	writef(arg);
	write(arg.outputFileName, createNoise(arg.width, arg.height, arg.depth));
}

void[] createNoise(ubyte width, ubyte height, ubyte depth)
{
	writef("creating noise..."); flush();
	ubyte[] result = new ubyte[width * height * depth];
	for (auto z = 0; z < depth; z++)
	{
		for (auto y = 0; y < height; y++)
		{
			for (auto x = 0; x < width; x++)
			{
				result[width * height * z + width * y + x] = noise2(x, y, z);
			}
		}
		writef("."); flush();
	}
	return result;
}

void flush()
{
	dout.flush();
}

class Args
{
	const ubyte width, height, depth;
	const char[] outputFileName;
	
	this(char[][] args)
	{
		if (args.length != 5) throw new Error("width height depth outputFileName");
		width = args[1].toUbyte();
		height = args[2].toUbyte();
		depth = args[3].toUbyte();
		outputFileName = std.path.join(getcwd(), fromMBSz(args[4].ptr));
	}
	
	override char[] toString()
	{
		return format(
			"width=%d, height=%d, depth=%d, outputFileName=%s",
			width, height, depth, outputFileName
		);	
	}
}
