/*
* Computer-m
*   by tacyas
*/

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include "./computer-m.h"

extern int argCheck(Computer_m* comp, int argc, char* argv[]) ;
extern int usage(FILE* fpt);

int 
main(int argc, char* argv[])
{
	Computer_m comp;

	argCheck(&comp, argc, argv);

	comm_Read(&comp, 0);
	comm_Exec(&comp, 0);

	return 0;
}

int
argCheck(Computer_m* comp, int argc, char* argv[]) 
{
	int result;
	while((result=getopt(argc, argv, "hi:o:p:l:"))!=-1) {
		switch(result) {
			case 'h': 
				usage(stderr);
				break;
			case 'i': { 
				comp->inputDevice = fopen(optarg, "r");
				if(NULL!=comp->inputDevice) {
					fprintf(stderr, "Cannot open as inputDevice: %s\n", optarg);
					usage(stderr);
				}
				break;
			}
			case 'o': {
				comp->outputDevice = fopen(optarg, "a");
				if(NULL!=comp->outputDevice) {
					fprintf(stderr, "Cannot open as outputDevice: %s\n", optarg);
					usage(stderr);
				}
				break;
			}
			case 'p': {
				comp->programList = fopen(optarg, "r");
				if(NULL!=comp->programList) {
					fprintf(stderr, "Cannot open as programList: %s\n", optarg);
					usage(stderr);
				}
				break;
			}
			case 'l': {
				comp->logDevice = fopen(optarg, "a");
				if(NULL!=comp->logDevice) {
					fprintf(stderr, "Cannot open as logDevice: %s\n", optarg);
					usage(stderr);
				}
				break;
			}
			case ':': 
				fprintf(stderr, "%c needs value\n", result); 
				break;	
			case '?':
				fprintf(stderr, "unknown option\n");
				break;
		}
	}
	return 0;
}

int
usage(FILE* fpt)
{
	fprintf(fpt, "-i inputFilename(RSEND)  or stdin \n");
	fprintf(fpt, "-o outputFilename(ASEND) or stdout \n");
	fprintf(fpt, "-p program-data-List\n");
	fprintf(fpt, "-l logfile or stderr \n");

	fprintf(fpt, ">>>> program-data-list Format\n");
	fprintf(fpt, "PC:  InitPC\n");
	fprintf(fpt, "CCR: InitCCR\n");
	fprintf(fpt, "[ReadyQueue: program-ID0 PC0 IR0 CCR0]\n");
	fprintf(fpt, "[....]\n");
	fprintf(fpt, "ID: program-ID0\n");
	fprintf(fpt, "MMU: Address Instruction_Or_Data\n");
	fprintf(fpt, "MMU: ....\n");
	fprintf(fpt, "[ID: program-ID1]\n");
	fprintf(fpt, "[MMU: ....]\n");

	exit(EXIT_FAILURE);
	return 0;	
}


