package com.mamezou.android.mametalk;

import android.app.Dialog;
import android.content.Context;
import android.database.Cursor;
import android.view.View;
import android.widget.Button;
import android.widget.SimpleCursorAdapter;
import android.widget.Spinner;

import com.google.android.gtalkservice.IGTalkSession;
import com.mamezou.android.provider.Mametalk;

public class PresenceDialog extends Dialog implements View.OnClickListener {

	private IGTalkSession xmppSession = null;
	
	public PresenceDialog(Context c, IGTalkSession session) {
		super(c);
		this.xmppSession = session;
		setContentView(R.layout.presence_change);
		setTitle(GTalkUtils.getUserName(xmppSession));
		Button changeButton = (Button) findViewById(R.id.change);
		changeButton.setOnClickListener(this);
		Button closeButton = (Button) findViewById(R.id.close);
		closeButton.setOnClickListener(this);
		Spinner spin = (Spinner) findViewById(R.id.presence_list);
        Cursor cursor = Mametalk.Presences.query(c.getContentResolver(), "status >= 1");
		spin.setAdapter(new SimpleCursorAdapter(c, android.R.layout.simple_spinner_dropdown_item,
				cursor, new String[] {"name"}, new int[] {android.R.id.text1}));
        int status = GTalkUtils.getPresence(xmppSession).getStatus();
		int numRows = cursor.count();
		cursor.first();
		for (int position = 0; position < numRows; ++position) {
			if (cursor.getInt(cursor.getColumnIndex("status")) == status) {
				spin.setSelection(position);
				break;
			}
			cursor.next();
		}
	}
    
	@Override
	public void onClick(View view) {
		if (view.getId() == R.id.change) {
			Spinner spin = (Spinner)findViewById(R.id.presence_list);
			Cursor cur = (Cursor)spin.getSelectedItem();
			GTalkUtils.setPresence(xmppSession, cur.getInt(cur.getColumnIndex("status")));
	        dismiss();
		}
		cancel();
	}
}
