package com.mamezou.android.mametalk;

import android.app.Dialog;
import android.content.Context;
import android.os.DeadObjectException;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import android.widget.TextView;

import com.google.android.gtalkservice.IGTalkSession;

public class InvitationDialog extends Dialog implements View.OnClickListener {

	private IGTalkSession xmppSession = null;
	
	public InvitationDialog(Context c, IGTalkSession session) {
		super(c);
		this.xmppSession = session;
		setContentView(R.layout.invitation);
		setTitle("Inviting to chat");
		Button addButton = (Button) findViewById(R.id.add);
		addButton.setOnClickListener(this);
		Button cancelButton = (Button) findViewById(R.id.close);
		cancelButton.setOnClickListener(this);
	}
	
    private boolean isValidContact(String contact) {
        if (TextUtils.isEmpty(contact)) {
            return false;
        }
        if (contact.indexOf('@') == -1) {
            return false;
        }
        return true;
    }
    
	@Override
	public void onClick(View view) {
		if (view.getId() == R.id.add) {
			EditText contactText = (EditText) findViewById(R.id.newcontact);
			TextView messageText = (TextView) findViewById(R.id.message);
			if (!isValidContact(contactText.getText().toString())) {
				messageText.setText("Invalid contactname. Please enter Gmail or Google apps. username.");
				return;
			}
	        try {
	            xmppSession.inviteContact(contactText.getText().toString(), null);
	        } catch (DeadObjectException ex) {
	            Log.e(this.getClass().getName(), "caught " + ex);
	        }
	        dismiss();
		}
		cancel();
	}
}
