package com.mamezou.android.mametalk;

import java.util.ArrayList;

import android.app.ListActivity;
import android.database.Cursor;
import android.os.Bundle;
import android.provider.Im;
import android.provider.Im.ContactsColumns;
import android.view.View;
import android.widget.Button;
import android.widget.CheckBox;
import android.widget.SimpleCursorAdapter;
import android.widget.TextView;

import com.google.android.gtalkservice.IGTalkSession;

public class GroupChatCreater extends ListActivity
							  implements View.OnClickListener {

	@Override
	protected void onCreate(Bundle icicle) {
		super.onCreate(icicle);
		setContentView(R.layout.group_chat_creater);
		Button addButton = (Button) findViewById(R.id.add);
        addButton.setOnClickListener(this);
        Button closeButton = (Button) findViewById(R.id.close);
        closeButton.setOnClickListener(this);
	}
	
	private void fillData() {
    	Cursor cursor = Im.Contacts.query(getContentResolver(), null);
    	this.setListAdapter(new SimpleCursorAdapter(this, R.layout.group_chat_contact, cursor,
    				new String[] { ContactsColumns.NICKNAME },
    				new int[] { R.id.nickname }));
    }
	
	@Override
	protected void onResume() {
		super.onResume();
		fillData();
	}

	@SuppressWarnings("deprecation")
	@Override
	public void onClick(View view) {
		if (view.getId() == R.id.add) {
			int size = getListView().getCount();
			ArrayList<String> contacts = new ArrayList<String>();
			for (int i = 0; i < size; i++) {
				View v = getListView().getChildAt(i);
				CheckBox check = (CheckBox)v.findViewById(R.id.check_contact);
				if (check.isChecked()) {
					TextView text = (TextView)v.findViewById(R.id.nickname);
					contacts.add(text.getText().toString());
				}
			}
			IGTalkSession session = IGTalkSession.Stub.asInterface(getIntent().getIBinderExtra("gtalkSession"));
			TextView roomNameText = (TextView)findViewById(R.id.room_name);
			GTalkUtils.createGroupChatSession(session, roomNameText.getText().toString(), contacts);
		}
		setResult(RESULT_OK);
		finish();
	}
}
