package com.mamezou.android.mametalk;

import java.util.ArrayList;

import android.os.DeadObjectException;
import android.os.IBinder;
import android.util.Log;

import com.google.android.gtalkservice.IChatSession;
import com.google.android.gtalkservice.IGTalkService;
import com.google.android.gtalkservice.IGTalkSession;
import com.google.android.gtalkservice.IGroupChatInvitationListener;
import com.google.android.gtalkservice.Presence;

public class GTalkUtils {
	private GTalkUtils() {
		//
	}
	public static String getUserName(IGTalkSession session) {
		try {
			return session.getUsername();
		} catch (DeadObjectException e) {
			log(e);
			return null;
		}
	}
	public static Presence getPresence(IGTalkSession session) {
		try {
			return session.getPresence();
		} catch (DeadObjectException e) {
			log(e);
			return null;
		}
	}
	public static void requestRoster(IGTalkSession session) {
		try {
			session.requestRoster();
		} catch (DeadObjectException e) {
			log(e);
		}
	}
	public static IChatSession createChatSession(IGTalkSession session, String to) {
		try {
			return session.createChatSession(to);
		} catch (DeadObjectException e) {
			log(e);
			return null;
		}
	}
	public static IChatSession getChatSession(IGTalkSession session, String to) {
		try {
			return session.getChatSession(to);
		} catch (DeadObjectException e) {
			log(e);
			return null;
		}
	}
	public static void endChatSession(IGTalkSession session, String contactName) {
		try {
			session.getChatSession(contactName).leave();
		} catch (DeadObjectException e) {
			log(e);
		}
	}
	public static void removeContact(IGTalkSession session, String contact) {
		try {
			session.removeContact(contact);
		} catch (DeadObjectException e) {
			log(e);
		}
	}
	public static void approveSubscriptionRequest(IGTalkSession session, String contact) {
		try {
			session.approveSubscriptionRequest(contact, null);
		} catch (DeadObjectException e) {
			log(e);
		}
	}
	public static boolean isConnected(IGTalkSession session) {
		try {
			return session.isConnected();
		} catch (DeadObjectException e) {
			log(e);
			return false;
		}
	}
	public static int getConnectionState(IGTalkSession session) {
		try {
			return session.getConnectionState();
		} catch (DeadObjectException e) {
			log(e);
			return -1;
		}
	}
	public static IGTalkSession getDefaultSession(IBinder service) {
	    try {
			return IGTalkService.Stub.asInterface(service).getDefaultSession();
		} catch (DeadObjectException e) {
			log(e);
			return null;
		}
	}
	public static void setPresence(IGTalkSession session, int status) {
		try {
        	Presence presence = new Presence();
        	presence.setStatus(status);
        	session.setPresence(presence);
    	} catch (DeadObjectException e) {
    		log(e);
    	}
	}
	public static void createGroupChatSession(IGTalkSession session, String roomName, ArrayList<String> contacts) {
		try {
        	session.createGroupChatSession(roomName, contacts.toArray(new String[] {}));
    	} catch (DeadObjectException e) {
    		log(e);
    	}
	}
	public static void addGroupChatInvitationListener(IGTalkSession session, IGroupChatInvitationListener listener) {
		try {
        	session.addGroupChatInvitationListener(listener);
    	} catch (DeadObjectException e) {
    		log(e);
    	}
	}
	public static String[] getParticipants(IChatSession session) {
		try {
        	return session.getParticipants();
    	} catch (DeadObjectException e) {
    		log(e);
    		return null;
    	}
	}
	private static void log(Exception e) {
		Log.e(GTalkUtils.class.getName(), e.getMessage(), e);
	}
}
