package com.mamezou.android.mametalk;

import android.app.ListActivity;
import android.content.ComponentName;
import android.content.Intent;
import android.content.ServiceConnection;
import android.database.Cursor;
import android.os.Bundle;
import android.os.DeadObjectException;
import android.os.IBinder;
import android.provider.Im;
import android.provider.Im.ChatsColumns;
import android.provider.Im.ContactsColumns;
import android.provider.Im.GroupMemberColumns;
import android.provider.Im.PresenceColumns;
import android.text.TextUtils;
import android.view.Menu;
import android.view.View;
import android.view.Menu.Item;
import android.widget.ImageView;
import android.widget.ListView;
import android.widget.SimpleCursorAdapter;
import android.widget.TextView;

import com.google.android.gtalkservice.GTalkServiceConstants;
import com.google.android.gtalkservice.GroupChatInvitation;
import com.google.android.gtalkservice.IChatSession;
import com.google.android.gtalkservice.IGTalkSession;
import com.google.android.gtalkservice.IGroupChatInvitationListener;

public class ContactList extends ListActivity {
	
	IGTalkSession gtalkSession = null;
    private static final int INVITE_CONTACT_ID = Menu.FIRST;
    private static final int APPROVE_CONTACT_ID = Menu.FIRST + 1;
    private static final int REMOVE_CONTACT_ID = Menu.FIRST + 2;
    private static final int ADD_GROUPCHAT_ID = Menu.FIRST + 3;
    private static final int CHANGE_PRESENCE_ID = Menu.FIRST + 4;
    private static final int GTALK_SETTINGS_ID = Menu.FIRST + 5;
	
    @Override
    public void onCreate(Bundle icicle) {
        super.onCreate(icicle);
        setContentView(R.layout.contacts);
        bindService((new Intent()
    		.setComponent(GTalkServiceConstants.GTALK_SERVICE_COMPONENT)), conn, 0);
    }
    
	private ServiceConnection conn = new ServiceConnection() {
		public void onServiceConnected(ComponentName className, IBinder service) {
	        gtalkSession = GTalkUtils.getDefaultSession(service);
	        if (gtalkSession == null) {
	        	return;
	        }
	        GTalkUtils.setPresence(gtalkSession, Im.PresenceColumns.AVAILABLE);
	        GTalkUtils.requestRoster(gtalkSession);
        	GTalkUtils.addGroupChatInvitationListener(gtalkSession, new IGroupChatInvitationListener.Stub() {
				@Override
				public void onInvitationReceived(GroupChatInvitation groupchatinvitation)
						throws DeadObjectException {
					gtalkSession.joinGroupChatSession(groupchatinvitation.getRoomAddress(), "", "");
				}
			});
	    }
		
	    public void onServiceDisconnected(ComponentName className) {
	    	GTalkUtils.setPresence(gtalkSession, PresenceColumns.OFFLINE);
	        gtalkSession = null;
	    }
    };
    
	@Override
    public boolean onCreateOptionsMenu(Menu menu) {
        super.onCreateOptionsMenu(menu);
        menu.add(Menu.ALTERNATIVE, GTALK_SETTINGS_ID, R.string.menu_xmpp_settings);
        return true;
    }

    @Override
	public boolean onPrepareOptionsMenu(Menu menu) {
		super.onPrepareOptionsMenu(menu);
		boolean havaItems = getListView().getCount() > 0; 
		if (gtalkSession != null) {
			if (menu.findItem(INVITE_CONTACT_ID) == null) {
				menu.add(Menu.SELECTED_ALTERNATIVE, INVITE_CONTACT_ID, R.string.menu_invite_contact);
		        menu.add(Menu.ALTERNATIVE, CHANGE_PRESENCE_ID, R.string.menu_change_presence);
			}
	        if (havaItems) {
	        	if (menu.findItem(APPROVE_CONTACT_ID) == null) {
					menu.add(Menu.SELECTED_ALTERNATIVE, APPROVE_CONTACT_ID, R.string.menu_approve_contact);
				    menu.add(Menu.SELECTED_ALTERNATIVE, REMOVE_CONTACT_ID, R.string.menu_remove_contact);
				    menu.add(Menu.SELECTED_ALTERNATIVE, ADD_GROUPCHAT_ID, R.string.menu_add_groupchat);
	        	}
			} else {
				menu.removeItem(APPROVE_CONTACT_ID);
				menu.removeItem(REMOVE_CONTACT_ID);
				menu.removeItem(ADD_GROUPCHAT_ID);
			}
		} else {
			menu.removeItem(INVITE_CONTACT_ID);
	        menu.removeItem(CHANGE_PRESENCE_ID);
	        menu.removeItem(APPROVE_CONTACT_ID);
			menu.removeItem(REMOVE_CONTACT_ID);
			menu.removeItem(ADD_GROUPCHAT_ID);
		}
		return true;
	}

	@Override
    public boolean onMenuItemSelected(int featureId,Item item) {
    	super.onMenuItemSelected(featureId, item);
        switch (item.getId()) {
        case INVITE_CONTACT_ID:
        	launchInvitation();
        	break;
        case APPROVE_CONTACT_ID:
        	approveRequest();
        	break;
        case REMOVE_CONTACT_ID:
        	removeContact();
        	break;
        case ADD_GROUPCHAT_ID:
        	launchGroupChatCreater();
        	break;
        case CHANGE_PRESENCE_ID:
        	PresenceDialog dialog = new PresenceDialog(this, gtalkSession);
        	dialog.show();
        	break;
        case GTALK_SETTINGS_ID:
        	launchXmppSettings();
        	break;
        }
        return true;
    }
    
    private void launchInvitation() {
    	InvitationDialog invitation = new InvitationDialog(this, gtalkSession);
    	invitation.show();
    }
    
    private void approveRequest() {
    	GTalkUtils.approveSubscriptionRequest(gtalkSession, getColumn(ContactsColumns.USERNAME));
    }
    
    private void removeContact() {
    	GTalkUtils.removeContact(gtalkSession, getColumn(ContactsColumns.USERNAME));
    }
    
    @SuppressWarnings("deprecation")
    private void launchGroupChatCreater() {
    	Intent i = new Intent(this, GroupChatCreater.class);
    	i.putExtra("gtalkSession", gtalkSession.asBinder());
    	startActivity(i);
    }
    
    private void launchXmppSettings() {
    	ComponentName comp = new ComponentName( 
                "com.google.android.gtalksettings", 
                "com.google.android.gtalksettings.GTalkSettingsForwarder"); 
    	startActivity((new Intent()).setComponent(comp));
    }
    
    private void fillData() {
    	Cursor cursor = Im.Contacts.query(getContentResolver(), null);
    	this.setListAdapter(new SimpleCursorAdapter(this, R.layout.contact, cursor,
    				new String[] { ContactsColumns.NICKNAME, "last_message_date", PresenceColumns.PRESENCE_CUSTOM_STATUS },
    				new int[] { R.id.nickname, R.id.last_message_date, R.id.custom_status }) {
    		@Override
    	    public void setViewText(TextView v, String text) {
    			String disp = text;
    			if(v.getId() == R.id.custom_status) {
    				String status = mCursor.getString(mCursor.getColumnIndex(PresenceColumns.PRESENCE_STATUS));
    				if (TextUtils.isEmpty(status)) {
    					disp = "";
    				} else if (Integer.parseInt(status) <= PresenceColumns.INVISIBLE) {
    					disp = "offline";
    				}
				}
    			v.setText(disp);
    		}
    		@Override
			public void setViewImage(ImageView v, String text) {
				if (text != "") {
					v.setImageResource(R.drawable.message_arrival);
				}
			}
    	});
    }
	
	@Override
	protected void onResume() {
		super.onResume();
		fillData();
		getListView().requestFocus();
	}

	@Override
	protected void onDestroy() {
		super.onDestroy();
		unbindService(conn);
	}

	@SuppressWarnings("deprecation")
	@Override
    protected void onListItemClick(ListView l, View v, int position, long id) {
		setSelection(position);
    	if (gtalkSession == null) {
    		MessageUtils.showMessage(this, getText(R.string.xmpp_service_not_connected));
    		return;
    	}
    	String contactName = getColumn(ContactsColumns.USERNAME);
    	IChatSession chatSession = null;
    	Intent i = null;
    	if (getColumnLong(ChatsColumns.GROUP_CHAT) == 1) {
    		chatSession = GTalkUtils.getChatSession(gtalkSession, contactName);
			i = new Intent(this, GroupChatClient.class);
			i.putExtra(GroupMemberColumns.GROUP, getColumnLong("chats_contact_id"));
		} else {
			chatSession = GTalkUtils.createChatSession(gtalkSession, contactName);
			i = new Intent(this, ChatClient.class);
			i.putExtra(ContactsColumns.PROVIDER, getColumnLong(ContactsColumns.PROVIDER));
			i.putExtra(ContactsColumns.ACCOUNT, getColumnLong(ContactsColumns.ACCOUNT));
		}
    	i.putExtra(ContactsColumns.USERNAME, contactName);
    	i.putExtra("chatSession", chatSession.asBinder());
    	startSubActivity(i, 0);
    }
	
	@Override
	protected void onActivityResult(int i, int j, String s, Bundle bundle) {
		super.onActivityResult(i, j, s, bundle);
		GTalkUtils.endChatSession(gtalkSession, getColumn(ContactsColumns.USERNAME));	
	}

	private String getColumn(String columnName) {
		Cursor cursor = (Cursor)getListView().getSelectedItem();
		return cursor.getString(cursor.getColumnIndex(columnName));
	}
	private long getColumnLong(String columnName) {
		Cursor cursor = (Cursor)getListView().getSelectedItem();
		return cursor.getLong(cursor.getColumnIndex(columnName));
	}
	
}