package com.mamezou.android.mametalk;

import java.text.SimpleDateFormat;
import java.util.Date;

import android.app.ListActivity;
import android.database.Cursor;
import android.os.Bundle;
import android.os.DeadObjectException;
import android.provider.Im.BaseMessageColumns;
import android.provider.Im.ContactsColumns;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import android.widget.ListView;

import com.google.android.gtalkservice.IChatSession;

public abstract class AbstractChatActivity extends ListActivity 
						implements View.OnClickListener {

	private EditText commentText;
	protected IChatSession chatSession;
	protected String contactName;
	
	@Override
    public void onCreate(Bundle icicle) {
        super.onCreate(icicle);
        setContentView(R.layout.chat);
        
        commentText = (EditText) findViewById(R.id.comment);
        getListView().setStackFromBottom(true);

        contactName = icicle != null ? icicle.getString(ContactsColumns.USERNAME) : null;
        if (contactName == null) {
        	Bundle extras = getIntent().getExtras();
        	contactName = extras != null ? extras.getString(ContactsColumns.USERNAME) : null;
        }
        setTitle("Talking with " + contactName);
        Button sendButton = (Button) findViewById(R.id.send);
        sendButton.setOnClickListener(this);
        reflectExtras(icicle);
	}
	
	protected abstract void reflectExtras(Bundle icicle);
	
	@Override
	protected void onListItemClick(ListView l, View v, int position, long id) {
		setSelection(position);
		Cursor cursor = (Cursor)getListView().getSelectedItem();
		String body = cursor.getString(cursor.getColumnIndex(BaseMessageColumns.BODY));
		long date = cursor.getLong(cursor.getColumnIndex(BaseMessageColumns.DATE));
		String dispDate = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss").format(new Date(date));
		MessageUtils.showMessage(this, "Message Detail", dispDate + System.getProperty("line.separator") + body);
	}

	@SuppressWarnings("deprecation")
	@Override
	protected void onResume() {
		super.onResume();
		chatSession = IChatSession.Stub.asInterface(getIntent().getIBinderExtra("chatSession"));
        fillData();
		commentText.requestFocus();
	}

	@Override
	public void onClick(View view) {
		String comment = commentText.getText().toString();
        if (TextUtils.isEmpty(comment)) {
            MessageUtils.showMessage(this, getText(R.string.invalid_comment));
            return;
        }
        if (chatSession == null) {
        	MessageUtils.showMessage(this, getText(R.string.xmpp_service_not_connected));
            return;
        }
        try {
            chatSession.sendTextMessage(commentText.getText().toString());
            commentText.setText("");
        } catch (DeadObjectException ex) {
            Log.e(this.getClass().getName(), "caught " + ex);
            MessageUtils.showMessage(this, getText(R.string.found_stale_xmpp_service));
            chatSession = null;
        }
	}
	
	protected abstract void fillData();
}
