package coboled.editors;

import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;

public class CobolOutlinePage extends ContentOutlinePage {

	private CobolEditor editor;
	
	private CobolElement root;
	
	private CobolSelectionChangedListener selectionChangedListener;

	public CobolOutlinePage(CobolEditor cobolEditor) {
		this.editor = cobolEditor;
	}

	@Override
	public void createControl(Composite parent) {
		super.createControl(parent);
		TreeViewer viewer = getTreeViewer();
		viewer.setContentProvider(new CobolContentProvider());
		viewer.setLabelProvider(new CobolLabelProvider());
		
		selectionChangedListener = new CobolSelectionChangedListener();
		viewer.addSelectionChangedListener(selectionChangedListener);
		refresh();
	}

	public void refresh() {
		IDocumentProvider provider = editor.getDocumentProvider();
		IDocument document = provider.getDocument(editor.getEditorInput());
		String source = document.get();
		TreeViewer viewer = getTreeViewer();
		this.root = new CobolParser().parse(source);
		viewer.setInput(this.root);
		viewer.refresh();
	}

	public void setSelection(int offset) {
		if(root != null) {
			CobolElement element = root.getElementByOffset(offset);
			getTreeViewer().removeSelectionChangedListener(selectionChangedListener);
			setSelection(new StructuredSelection(element));	
			getTreeViewer().addSelectionChangedListener(selectionChangedListener);
		}
	}
	
	private class CobolSelectionChangedListener implements ISelectionChangedListener {

		public void selectionChanged(SelectionChangedEvent event) {
			IStructuredSelection sel = (IStructuredSelection) event.getSelection();
			Object element = sel.getFirstElement();
			if (element instanceof CobolElement) {
				int offset = ((CobolElement) element).getOffset();
				editor.selectAndReveal(offset, 0);
			}
		}
	}
}
