package coboled.editors;

import org.eclipse.jface.text.rules.*;

public class CobolPartitionScanner extends RuleBasedPartitionScanner {
	public final static String COBOL_COMMENT = "__cobol_comment";

	private static final int MARK_AREA = 6;

	public CobolPartitionScanner() {

		IToken cobolComment = new Token(COBOL_COMMENT);

		IPredicateRule[] rules = new IPredicateRule[3];

		SingleLineRule asterisk = new EndOfLineRule("*", cobolComment);
		asterisk.setColumnConstraint(MARK_AREA);
		rules[0] = asterisk;

		SingleLineRule slash = new EndOfLineRule("/", cobolComment);
		slash.setColumnConstraint(MARK_AREA);
		rules[1] = slash;

		SingleLineRule debug = new EndOfLineRule("D", cobolComment);
		debug.setColumnConstraint(MARK_AREA);
		rules[2] = debug;

		setPredicateRules(rules);
	}
}
