package coboled.editors;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CobolParser {

	public CobolElement parse(String source) {
		CobolElement root = new CobolElement("root", CobolElementType.ROOT);
		CobolElement work = root;
		Pattern outline = Pattern.compile("^.{6} ( {0,3})([^ ]+?.*)", Pattern.MULTILINE);
		Matcher matcher = outline.matcher(source);
		while (matcher.find()) {
			String group = matcher.group(2);
			if(group != null) {
				String[] strings = group.split(" +");
				if(strings.length >= 2 && strings[0].indexOf("EXIT") == -1) {
					CobolElementType type = null;
					if(strings[1].startsWith("DIVISION")) {
						type = CobolElementType.DIVISION;
					} else if(strings[1].startsWith("SECTION")) {
						type = CobolElementType.SECTION;
					} else if(strings[0].matches("^[0-9][0-9]")) {
						type = CobolElementType.DATA;
					} else {
						strings[1] = null;
						type = CobolElementType.PARAGRAPH;
					}
					CobolElement element = createCobolElement(work, strings[0], strings[1], type, matcher.start());
					work = element;
				}
			}
		}
		return root;
	}
	
	private CobolElement createCobolElement(CobolElement work, 
			String group1, String group2,
			CobolElementType type, int offset) {
		String name = format(group1, group2);
		CobolElement element = new CobolElement(name, type);
		CobolElement parent = getParentElement(work, element);
		element.setParent(parent);
		element.setOffset(offset);
		parent.appendChild(element);
		return element;
	}
	
	private String format(String... args) {
		if(args == null || args.length == 0) {
			return "";
		}
		
		StringBuilder builder = new StringBuilder();
		for(int i = 0; i < args.length; i++) {
			if(args[i] != null) {
				builder.append(args[i].trim()).append(" ");
			}
		}
		
		// 文末にピリオドがあった場合、ピリオドを除く
		String result = builder.toString().trim();
		if(result != null && result.endsWith(".")) {
			return result.substring(0, result.length() - 1);
		}
		return result;
	}

	private CobolElement getParentElement(CobolElement element, CobolElement element2) {
		CobolElementType type = element.getType();
		CobolElementType type2 = element2.getType(); 
		if(type.compareTo(type2) > 0) {
			return element;
		} else if(type.compareTo(type2) == 0) {
			return element.getParent();
		} else {
			return getParentElement(element.getParent(), element2);
		}
	}
}
