/* ------------------------------------------------------------------------ */
/*  Hyper Operating System V4  ITRON4.0 Real-Time OS                  */
/*    ץåݲݡͥ (Windows)                            */
/*                                                                          */
/*                                  Copyright (C) 1998-2002 by Project HOS  */
/*                                  http://sourceforge.jp/projects/hos/     */
/* ------------------------------------------------------------------------ */


#include <stdlib.h>
#include "hospac.h"
#include <tchar.h>


/*  */
typedef struct t_TaskInfo
{
	VP_INT exinf;			/* μ¹Իѥ᡼ */
	FP     task;			/* εư */
} T_TaskInfo;



DWORD WINAPI TaskEntry(LPVOID param);	/* åɤγϴؿ */
void  HookPrimaryThread(void);			/* ץ饤ޥꥹåɤΥեå */

HANDLE hospac_hSem  = NULL;				/* ƥ¾ѥޥե */
BOOL   hospac_blInt = FALSE;			/* ߽ե饰 */

static DWORD  hPrimaryThreadId;			/* ץ饤ޥꥹåID */
static HANDLE hThreadDelete = NULL;		/* 륹åɥϥɥ */



/* ƥν */
void hospac_ini_sys(void)
{
	/* ץ饤ޥꥹåID¸ */
	hPrimaryThreadId = GetCurrentThreadId();

	/* ߶ػߤ˸ΩƤ륻ޥեκ */
	hospac_hSem = CreateSemaphore(NULL, 0, 1, NULL);
}


/* ߵ */
void hospac_ena_int(void)
{
	if ( !hospac_blInt )
	{
		ReleaseSemaphore(hospac_hSem, 1, NULL);
	}
}


/* ߶ػ */
void hospac_dis_int(void)
{
	if ( !hospac_blInt )
	{
		WaitForSingleObject(hospac_hSem, INFINITE);
	}
}


/* ¹ԥƥȤκ */
void hospac_cre_ctx(
		T_HOSPAC_CTXINF *pk_ctxinf,		/* ƥȤ륢ɥ쥹 */
		VP_INT          exinf,			/* μ¹Իѥ᡼ */
		FP              task,			/* εư */
		SIZE            stksz,			/* åΰΥ */
		VP              stk)			/* åΰƬ */
{
	T_TaskInfo *pInfo;

	/* Ǽ */
	pInfo = (T_TaskInfo *)GlobalAlloc(GMEM_FIXED, sizeof(T_TaskInfo));
	pInfo->task  = task;
	pInfo->exinf = exinf;
	
	/*  */
	pk_ctxinf->blIntSuspend = FALSE;
	pk_ctxinf->hThread = CreateThread(NULL, 0, TaskEntry, (LPVOID)pInfo,
									CREATE_SUSPENDED, &pk_ctxinf->dwThreadId);
}


/* åɤγϴؿ */
DWORD WINAPI TaskEntry(LPVOID param)
{
	T_TaskInfo Info;

	Info = *(T_TaskInfo *)param;

	GlobalFree((HGLOBAL)param);

	Info.task(Info.exinf);

	return 0;
}


/* ¹ԥƥȤκ */
void hospac_del_ctx(T_HOSPAC_CTXINF *pk_ctxinf)
{
	if ( GetCurrentThreadId() != pk_ctxinf->dwThreadId )
	{
		/* ¹楹åɤǤʤ¨ */
		TerminateThread(pk_ctxinf->hThread, 0);
	}
	else
	{
		/* ¹楹åɤʤͽ */
		hThreadDelete = pk_ctxinf->hThread;
	}
}


/* ¹ԥƥȤ */
void hospac_swi_ctx(
		T_HOSPAC_CTXINF *pk_pre_ctxinf,		/* ߤΥƥȤ¸ */
		T_HOSPAC_CTXINF *pk_nxt_ctxinf)		/* ˼¹Ԥ륳ƥ */
{
	DWORD dwCount;

	if ( hospac_blInt )
	{
		return;
	}

	/* åɤۤʤڤؤ */
	if ( pk_nxt_ctxinf != pk_pre_ctxinf )
	{
		/* ڤؤоݤڥǤ뤳Ȥǧ */
		for ( ; ; )
		{
			/* ڥɥ󥿤٤˥ڥɤƤߤ */
			dwCount = SuspendThread(pk_nxt_ctxinf->hThread);
			ResumeThread(pk_nxt_ctxinf->hThread);
			
			/* 󥿤0ǤʤХڥɤƤ */
			if ( dwCount > 0 )
			{
				break;
			}
			
			/* ڥɴλޤԤ */
			Sleep(1);
		}
		
		/* ڤؤΥåɤ򵯤 */
		ResumeThread(pk_nxt_ctxinf->hThread);
		
		/* ޥեֵ */
		if ( pk_nxt_ctxinf->blIntSuspend )
		{
			pk_nxt_ctxinf->blIntSuspend = FALSE;
			ReleaseSemaphore(hospac_hSem, 1, NULL);
		}
		
		/* ץ饤ޥꥹåIΥեå */
		if ( hPrimaryThreadId == GetCurrentThreadId() )
		{
			HookPrimaryThread();
		}

		/* ʬȤ򥵥ڥɤ */
		SuspendThread(GetCurrentThread());
	}
	
	/* ͽΥåɤк */
	if ( hThreadDelete != NULL )
	{
		TerminateThread(hThreadDelete, 0);
		CloseHandle(hThreadDelete);
		hThreadDelete = NULL;
	}
}


/* ɥν */
void hospac_idle(void)
{
	/* ޥʤʾϥ⡼ɤڤؤʤɲǽ */
	
	/* ¾Υץ˼¹ԥߥ󥰤Ϳ */
	Sleep(1);
}


/* ץ饤ޥꥹåɤΥեå */
void  HookPrimaryThread(void)
{
	/* ɽ */
	MessageBox(NULL, _T("OK򲡤Ƚλޤ"), _T("Hyper Operationg System V4 for Win32"), MB_OK);

	/* λ */
	ExitProcess(0);
}


/* ------------------------------------------------------------------------ */
/*  Copyright (C) 1998-2002 by Project HOS                                  */
/* ------------------------------------------------------------------------ */
