/* ------------------------------------------------------------------------ */
/*  Hyper Operating System V4  ITRON4.0 Real-Time OS                  */
/*    ̥ͥ ॢȥ塼                                     */
/*                                                                          */
/*                                  Copyright (C) 1998-2002 by Project HOS  */
/*                                  http://sourceforge.jp/projects/hos/     */
/* ------------------------------------------------------------------------ */


#include "mknl.h"



/* ॢԤ˥ɲ */
ER mknl_add_tmout(
		T_MKNL_TCB *mtcb,	/* Ԥ˲ä륿 */
		RELTIM     tmout)	/* ॢȤޤǤλ */
{
	T_MKNL_TCB* mtcb_tmp;

	/* ǽΣĤʤ */
	if ( mknl_timout_head == NULL )
	{
		/* ǽΣĤ򥭥塼Ͽ */
		mtcb->tm_next    = mtcb;
		mtcb->tm_prev    = mtcb;
		mknl_timout_head = mtcb;

		/* ॢȻ */
		mtcb->diftim = tmout;

		return E_OK;
	}
	
	/* 򸡺 */
	mtcb_tmp = mknl_timout_head;
	do
	{
		/*  */
		if ( tmout < mtcb_tmp->diftim )
		{
			/* ֤κʬ */
			mtcb_tmp->diftim -= tmout;
			mtcb->diftim      = tmout;

			/* ꥹȤ */
			mtcb->tm_next          = mtcb_tmp;
			mtcb->tm_prev          = mtcb_tmp->tm_prev;
			mtcb->tm_next->tm_prev = mtcb;
			mtcb->tm_prev->tm_next = mtcb;
			
			/* Ƭʤ */
			if ( mtcb_tmp == mknl_timout_head )
			{
				mknl_timout_head = mtcb;	/* Ƭݥ󥿹 */
			}
			
			return E_OK;
		}
		
		tmout -= mtcb_tmp->diftim;		/* ʬ򸺻 */
		
		mtcb_tmp = mtcb_tmp->tm_next;	/* TCBؿʤ */
	} while ( mtcb_tmp != mknl_timout_head );	/* ꥹȤޤǥ롼 */
	
	/* ɲ */
	mtcb->tm_next          = mtcb_tmp;
	mtcb->tm_prev          = mtcb_tmp->tm_prev;
	mtcb->tm_next->tm_prev = mtcb;
	mtcb->tm_prev->tm_next = mtcb;

	/* Ĥäʬ */
	mtcb->diftim = tmout;

	return E_OK;
}


/* ------------------------------------------------------------------------ */
/*  Copyright (C) 1998-2002 by Project HOS                                  */
/* ------------------------------------------------------------------------ */
