/* ------------------------------------------------------------------------ */
/*  Hyper Operating System V4  ITRON4.0 Real-Time OS                  */
/*    ITRONͥ °Ʊǽ                                      */
/*                                                                          */
/*                                  Copyright (C) 1998-2004 by Project HOS  */
/*                                  http://sourceforge.jp/projects/hos/     */
/* ------------------------------------------------------------------------ */


#include "knl_tsk.h"



/* Ԥ֤ؤΰܹ */
ER sus_tsk(
		ID tskid)	/* ܹоݤΥIDֹ */
{
	T_KERNEL_TCB_RAM *tcb_ram;

	/* ID ϰϥå */
#ifdef HOS_ERCHK_E_ID
	if ( tskid != TSK_SELF && (tskid < KERNEL_TMIN_TSKID || tskid > KERNEL_TMAX_TSKID) )
	{
		return E_ID;	/* IDֹ */
	}
#endif

	mknl_loc_sys();	/* ƥΥå */

	/* ȥ֥å */
	if ( tskid == TSK_SELF )
	{
		/* Ѵ */
#ifdef HOS_ERCHK_E_CTX
		if ( mknl_sns_dsp() )
		{
			/* ǥѥåػ߾֤ TSK_SELF */
			mknl_unl_sys();		/* ƥΥå */
			return E_CTX;		/* ƥ */
		}
#endif
		tcb_ram = kernel_get_run_tsk();
	}
	else
	{
		/* IDֹѴ */
		tcb_ram = KERNEL_TSKID_TO_TCB_RAM(tskid);

		/* ֥¸ߥå */
#ifdef HOS_ERCHK_E_NOEXS
		if ( tcb_ram == NULL )
		{
			mknl_unl_sys();		/* ƥΥå */
			return E_NOEXS;		/* ֥̤ */
		}
#endif
	}

	/* ƥȥå */
#ifdef HOS_ERCHK_E_CTX
	if ( tcb_ram == kernel_get_run_tsk() && mknl_sns_dsp() )
	{
		mknl_unl_sys();		/* ƥΥå */
		return E_CTX;		/* ƥ */
	}
#endif

	/* ֥Ⱦ֥å */
#ifdef HOS_ERCHK_E_OBJ
	if ( mknl_get_tskstat(&tcb_ram->mtcb) == TTS_DMT )
	{
		mknl_unl_sys();		/* ƥΥå */
		return E_OBJ;		/* ֥Ⱦ */
	}
#endif

	/* ֥ȾȽ */
	if ( mknl_get_tskstat(&tcb_ram->mtcb) & TTS_SUS )
	{
		/* 塼󥰥Сեå */
#ifdef HOS_ERCHK_E_QOVR
		if ( tcb_ram->suscnt >= TMAX_SUSCNT )
		{
			mknl_unl_sys();	/* ƥΥå */
			return E_QOVR;
		}
#endif
		tcb_ram->suscnt++;
	}
	else
	{
		/* ζԤ */
		mknl_sus_tsk(&tcb_ram->mtcb);
	}

	/* оݤξ硢ǥѥå¹ */
	if ( tcb_ram == kernel_get_run_tsk())
	{
		mknl_exe_dsp();	/* ǥѥåμ¹ */
		mknl_exe_tex();	/* 㳰μ¹ */
	}

	mknl_unl_sys();	/* ƥΥå */

	return E_OK;
}


/* ------------------------------------------------------------------------ */
/*  Copyright (C) 1998-2004 by Project HOS                                  */
/* ------------------------------------------------------------------------ */
