/* ------------------------------------------------------------------------ */
/*  Hyper Operating System V4  ITRON4.0 Real-Time OS                  */
/*    ITRONͥ °Ʊǽ                                      */
/*                                                                          */
/*                                  Copyright (C) 1998-2002 by Project HOS  */
/*                                  http://sourceforge.jp/projects/hos/     */
/* ------------------------------------------------------------------------ */


#include "knl_tsk.h"



/* εԤ */
ER slp_tsk(void)
{
	T_KERNEL_TCB_RAM *tcb_ram;
	ER ercd;

	mknl_loc_sys();	/* ƥΥå */

	/* ƥȥå */
#ifdef HOS_ERCHK_E_CTX
	if ( mknl_sns_wai() )
	{
		mknl_unl_sys();	/* ƥΥå */
		return E_CTX;	/* ƥ */
	}
#endif

	tcb_ram = kernel_get_run_tsk();

	/* ׵ᥭ塼󥰤Υå */
	if ( tcb_ram->wupcnt > 0 )
	{
		tcb_ram->wupcnt--;
		mknl_unl_sys();		/* ƥΥå */
		return E_OK;
	}
	
	/* Ԥ֤ */
	mknl_wai_tsk(&tcb_ram->mtcb, TTW_SLP);
	
	ercd = (ER)mknl_exe_dsp();	/* ǥѥåμ¹ */
	mknl_exe_tex();				/* 㳰μ¹ */
	
	mknl_unl_sys();		/* ƥΥå */
	
	return ercd;
}


/* ------------------------------------------------------------------------ */
/*  Copyright (C) 1998-2002 by Project HOS                                  */
/* ------------------------------------------------------------------------ */
