/* ------------------------------------------------------------------------ */
/*  Hyper Operating System V4  ITRON4.0 Real-Time OS                  */
/*    ITRONͥ ǽ                                          */
/*                                                                          */
/*                                  Copyright (C) 1998-2002 by Project HOS  */
/*                                  http://sourceforge.jp/projects/hos/     */
/* ------------------------------------------------------------------------ */


#include "knl_tsk.h"



/* ξֻ(ʰ) */
ER ref_tst(
		ID     tskid,
		T_RTST *p_rtst)
{
	T_KERNEL_TCB_RAM *tcb_ram;

	/* ID ϰϥå */
#ifdef HOS_ERCHK_E_ID
	if ( tskid != TSK_SELF && (tskid < KERNEL_TMIN_TSKID || tskid > KERNEL_TMAX_TSKID) )
	{
		return E_ID;	/* IDֹ */
	}
#endif

	mknl_loc_sys();	/* ƥΥå */

	/* ȥ֥å */
	if ( tskid == TSK_SELF )
	{
		/* Ѵ */
#ifdef HOS_ERCHK_E_ID
		if ( mknl_sns_ctx() )
		{
			/* 󥿥ƥȤ TSK_SELF */
			mknl_unl_sys();		/* ƥΥå */
			return E_ID;		/* IDֹ */
		}
#endif
		tcb_ram = kernel_get_run_tsk();
	}
	else
	{
		/* IDѴ */
		tcb_ram = KERNEL_TSKID_TO_TCB_RAM(tskid);

		/* ֥¸ߥå */
#ifdef HOS_ERCHK_E_NOEXS
		if ( tcb_ram == NULL )
		{
			mknl_unl_sys();				/* ƥΥå */
			return (ER_UINT)E_NOEXS;	/* ֥̤ */
		}
#endif
	}

	/*  */
	p_rtst->tskstat = mknl_get_tskstat(&tcb_ram->mtcb);
	p_rtst->tskwait = mknl_get_tskwait(&tcb_ram->mtcb);
	p_rtst->exinf   = tcb_ram->tcb_rom->exinf;

	mknl_unl_sys();	/* ƥΥå */

	return E_OK;	/*  */
}


/* ------------------------------------------------------------------------ */
/*  Copyright (C) 1998-2002 by Project HOS                                  */
/* ------------------------------------------------------------------------ */
