/* ------------------------------------------------------------------------ */
/*  Hyper Operating System V4  ITRON4.0 Real-Time OS                  */
/*    ITRONͥ Ĺס                                      */
/*                                                                          */
/*                                  Copyright (C) 1998-2002 by Project HOS  */
/*                                  http://sourceforge.jp/projects/hos/     */
/* ------------------------------------------------------------------------ */


#include "knl_mpf.h"



/* Ĺס */
ER cre_mpf(
		ID           mpfid,		/* оݤθĹסIDֹ */
		const T_CMPF *pk_cmpf)	/* Ĺס줿ѥåȤؤΥݥ */
{
	ER ercd;

	/* ID Υå */
#ifdef HOS_ERCHK_E_ID
	if ( mpfid < KERNEL_TMIN_MPFID || mpfid > KERNEL_TMAX_MPFID )
	{
		return E_ID;	/* ID */
	}
#endif

	mknl_loc_sys();	/* ƥΥå */

	/* ס뤬Ͽǽɤå */
#ifdef HOS_ERCHK_E_OBJ
	if ( KERNEL_MPFID_TO_MPFCB_RAM(mpfid) != NULL )
	{
		mknl_unl_sys();	/* ƥΥå */
		return E_OBJ;	/* ϿѤ */
	}
#endif

	/* Ĺס */
	ercd = kernel_cre_mpf(mpfid, pk_cmpf);
	
	mknl_unl_sys();	/* ƥΥå */

	return ercd;
}


/* ------------------------------------------------------------------------ */
/*  Copyright (C) 1998-2002 by Project HOS                                  */
/* ------------------------------------------------------------------------ */
