/* ------------------------------------------------------------------------ */
/*  Hyper Operating System V4  ITRON4.0 Real-Time OS                  */
/*    ITRONͥ ٥ȥե饰                                          */
/*                                                                          */
/*                                  Copyright (C) 1998-2002 by Project HOS  */
/*                                  http://sourceforge.jp/projects/hos/     */
/* ------------------------------------------------------------------------ */


#include "knl_flg.h"



/* ٥ȥե饰Ԥ(ॢȤ) */
ER twai_flg(
		ID     flgid,
		FLGPTN waiptn,
		MODE   wfmode,
		FLGPTN *p_flgptn,
		TMO    tmout)
{
	const T_KERNEL_FLGCB_ROM *flgcb_rom;
	T_KERNEL_FLGCB_RAM       *flgcb_ram;
	T_MKNL_TCB *mtcb;
	T_KERNEL_FLGINF flginf;
	ER ercd;

	/* ID Υå */
#ifdef HOS_ERCHK_E_ID
	if ( flgid < KERNEL_TMIN_FLGID || flgid > KERNEL_TMAX_FLGID )
	{
		return E_ID;	/* IDֹ */
	}
#endif

	/* ѥ᡼Υå */
#ifdef HOS_ERCHK_E_PAR
	if ( (wfmode != TWF_ANDW && wfmode != TWF_ORW) || waiptn == 0 )
	{
		return E_PAR;	/* ѥ᡼顼 */
	}
	if ( tmout < TMO_FEVR )
	{
		return E_PAR;
	}
#endif

	mknl_loc_sys();	/* ƥΥå */

	/* ƥȥå */
#ifdef HOS_ERCHK_E_CTX
	if (  tmout != TMO_POL && mknl_sns_wai() )
	{
		mknl_unl_sys();	/* ƥΥå */
		return E_CTX;	/* ƥ */
	}
#endif

	flgcb_ram = KERNEL_FLGID_TO_FLGCB_RAM(flgid);

	/* ֥Ȥ¸ߥå */
#ifdef HOS_ERCHK_E_NOEXS
	if ( flgcb_ram == NULL )
	{
		return E_NOEXS;
	}
#endif

	flgcb_rom = flgcb_ram->flgcb_rom;

	/* ӥѥå */
#ifdef HOS_ERCHK_E_ILUSE
	if ( !(flgcb_rom->flgatr & TA_WMUL) && mknl_ref_qhd(&flgcb_ram->que) != NULL )
	{
		mknl_unl_sys();		/* ƥΥå */
		return E_ILUSE;		/* ӥ */
	}
#endif

	/* Ԥ */
	flginf.waiptn = waiptn;
	flginf.wfmode = wfmode;

	/* ե饰å */
	if ( kernel_chk_flg(flgcb_ram, &flginf) )
	{
		/* ˾Ƥʤ */
		*p_flgptn = flgcb_ram->flgptn;		/* Υե饰ѥǼ */
		if ( flgcb_rom->flgatr & TA_CLR )
		{
			flgcb_ram->flgptn = 0;		/* ꥢ°Хꥢ */
		}
		ercd = E_OK;
	}
	else
	{
		/* Ƥʤ */
		if ( tmout == TMO_POL )
		{
			/* ݡ󥰤ʤ饿ॢ */
			ercd = E_TMOUT;
		}
		else
		{
			/* Ԥ */
			mtcb = mknl_get_run_tsk();		/* ¹楿 */
			mtcb->data = (VP_INT)&flginf;	/* Ԥ֤¸ */
			mknl_wai_tsk(mtcb, TTW_FLG);
			mknl_add_que(&flgcb_ram->que, mtcb, flgcb_rom->flgatr);
			if ( tmout != TMO_FEVR )
			{
				/* ̵ԤǤʤХॢ */
				mknl_add_tmout(mtcb, (RELTIM)tmout);
			}

			ercd = (ER)mknl_exe_dsp();	/* ǥѥå¹ */

			/* Ʋ줿Τʤ */
			if ( ercd == E_OK )
			{
				*p_flgptn = flginf.waiptn;		/* Υե饰ѥǼ */
			}

			mknl_exe_tex();		/* 㳰μ¹ */
		}
	}

	mknl_unl_sys();	/* ƥΥå */

	return ercd;
}


/* ------------------------------------------------------------------------ */
/*  Copyright (C) 1998-2002 by Project HOS                                  */
/* ------------------------------------------------------------------------ */
