/* ------------------------------------------------------------------------ */
/*  Hyper Operating System V4  ITRON4.0 Real-Time OS                  */
/*    ITRONͥ ٥ȥե饰                                          */
/*                                                                          */
/*                                  Copyright (C) 1998-2002 by Project HOS  */
/*                                  http://sourceforge.jp/projects/hos/     */
/* ------------------------------------------------------------------------ */


#include "knl_flg.h"



/* ٥ȥե饰Υꥢ */
ER clr_flg(
		ID     flgid,	/* ꥢоݤΥ٥ȥե饰IDֹ */
		FLGPTN clrptn)	/* ꥢӥåȥѥ(ӥåȿž) */
{
	T_KERNEL_FLGCB_RAM *flgcb_ram;

	/* ID Υå */
#ifdef HOS_ERCHK_E_ID
	if ( flgid < KERNEL_TMIN_FLGID || flgid > KERNEL_TMAX_FLGID )
	{
		return E_ID;	/* IDֹ */
	}
#endif

	mknl_loc_sys();	/* ƥΥå */

	flgcb_ram = KERNEL_FLGID_TO_FLGCB_RAM(flgid);

	/* ֥¸ߥå */
#ifdef HOS_ERCHK_E_NOEXS
	if ( flgcb_ram == NULL )
	{
		mknl_unl_sys();		/* ƥΥå */
		return E_NOEXS;
	}
#endif

	/* ե饰Υꥢ */
	flgcb_ram->flgptn = (FLGPTN)(flgcb_ram->flgptn & clrptn);

	mknl_unl_sys();	/* ƥΥå */

	return E_OK;
}


/* ------------------------------------------------------------------------ */
/*  Copyright (C) 1998-2002 by Project HOS                                  */
/* ------------------------------------------------------------------------ */
