/* ------------------------------------------------------------------------ */
/*  Hyper Operating System V4  ITRON4.0 Real-Time OS                  */
/*    ITRONͥ 顼ϥɥ                                        */
/*                                                                          */
/*                                  Copyright (C) 1998-2002 by Project HOS  */
/*                                  http://sourceforge.jp/projects/hos/     */
/* ------------------------------------------------------------------------ */


#include "knl_alm.h"



/* 顼ϥɥΥޥϥɥ */
void kernel_alm_hdr(
		T_KERNEL_TIM *timobj,	/* ޥ֥ */
		RELTIM       tic)		/* ƥå */
{
	const T_KERNEL_ALMCB_ROM *almcb_rom;
	T_KERNEL_ALMCB_RAM *almcb_ram;
	
	/* upper cast */
	almcb_ram = (T_KERNEL_ALMCB_RAM *)timobj;
	
	/* 顼ॿμ¹ */
	if ( almcb_ram->lefttim <= tic )
	{
		almcb_rom = almcb_ram->almcb_rom;
				
		/* 顼ϥɥ򥿥ޥꥹȤ鳰 */
		kernel_rmv_tml((T_KERNEL_TIM *)almcb_ram);

		/* 顼ϥɥƤӽФ */
		mknl_unl_sys();							/* ƥΥå */		
		almcb_rom->almhdr(almcb_rom->exinf);	/* ϥɥƤӽФ */
		mknl_loc_sys();							/* ƥΥå */
	}
	else
	{
		almcb_ram->lefttim -= tic;		/* Ĥ֤򸺻 */
	}
}


/* ------------------------------------------------------------------------ */
/*  Copyright (C) 1998-2002 by Project HOS                                  */
/* ------------------------------------------------------------------------ */
