/* ------------------------------------------------------------------------ */
/*  Hyper Operating System V4  ITRON4.0 Real-Time OS                  */
/*    ͥ¸إå ᡼ܥå                             */
/*                                                                          */
/*                                  Copyright (C) 1998-2002 by Project HOS  */
/*                                  http://sourceforge.jp/projects/hos/     */
/* ------------------------------------------------------------------------ */


#ifndef __HOS_V4__knl_mbx_h__
#define __HOS_V4__knl_mbx_h__


#include "knl_hos.h"



/* ------------------------------------------ */
/*                                    */
/* ------------------------------------------ */

/* IDϰ */
#define KERNEL_TMIN_MBXID	TMIN_MBXID			/* ᡼ܥåIDκǾ */
#define KERNEL_TMAX_MBXID	(KERNEL_TMIN_MBXID + kernel_mbxcb_cnt - 1)
												/* ᡼ܥåIDκ */


/* ͥ٤ϰ */
#define TMIN_MPRI			1					/* åͥ٤κǾ */
#define TMAX_MPRI			32767				/* åͥ٤κ */

/* ɬפʥΰΥ */
#define TSZ_MPRIHD(maxmpri)	(sizeof(T_MSG *) * ((maxmpri) - TMIN_MPRI + 1))
												/* ̥ͥ塼إåΥΰΥ */



/* ------------------------------------------ */
/*                                      */
/* ------------------------------------------ */

/* ᡼ܥåΥåإå */
typedef struct t_msg
{
	struct t_msg *next;		/* ΥåؤΥݥ */
} T_MSG;

/* ᡼ܥåͥդåإå */
typedef struct t_msg_pri
{
	T_MSG msg;				/* åإå */
	PRI   msgpri;			/* åͥ */
} T_MSG_PRI;


/* ᡼ܥå */
typedef struct t_cmbx
{
	ATR   mbxatr;		/* ᡼ܥå° */
	PRI   maxmpri;		/* åͥ٤κ */
	VP    mprihd;		/* ̤ͥΥå塼إåΰƬ */
} T_CMBX;

/* ᡼ܥå */
typedef struct t_rmbx
{
	ID    wtskid;		/* ᡼ܥåԤƬΥIDֹ */
	T_MSG *pk_msg;		/* å塼ƬΥåѥåȤƬ */
} T_RMBX;


/* ᡼ܥåȥ֥å(ROM) */
typedef struct t_kernel_mbxcb_rom
{
	ATR   mbxatr;		/* ᡼ܥå° */
	PRI   maxmpri;		/* åͥ٤κ */
	T_MSG **mprihd;		/* ̤ͥΥå塼إåΰƬ */
} T_KERNEL_MBXCB_ROM;

/* ᡼ܥåȥ֥å(RAM) */
typedef struct t_kernel_mbxcb_ram
{
	T_MKNL_QUE que;							/* ᡼ܥåԤ塼 */
	const T_KERNEL_MBXCB_ROM *mbxcb_rom;	/* ᡼ܥåȥ֥åROMؤΥݥ */
} T_KERNEL_MBXCB_RAM;



/* ---------------------------------- */
/*        Хѿ          */
/* ---------------------------------- */

/* ᡼ܥå */
extern       T_KERNEL_MBXCB_RAM *kernel_mbxcb_ram_tbl[];	/* ᡼ܥåȥ֥åơ֥(RAM) */
extern const INT kernel_mbxcb_cnt;							/* ᡼ܥåȥ֥åĿ */

#define KERNEL_MBXID_TO_MBXCB_RAM(mbxid)	(kernel_mbxcb_ram_tbl[(mbxid) - KERNEL_TMIN_MBXID])
															/* ᡼ܥåIDMBXCB RAMɥ쥹 */



/* ------------------------------------------ */
/*                ؿ                    */
/* ------------------------------------------ */

#ifdef __cplusplus
extern "C" {
#endif

/* ᡼ܥå */
#define kernel_ini_mbx()									/* ᡼ܥåν */
ER      cre_mbx(ID semid, const T_CMBX *pk_cmbx);			/* ޥե */
ER_ID   acre_mbx(const T_CMBX *pk_cmbx);					/* ޥե(IDֹ漫ưդ) */
ER      kernel_cre_mbx(ID mbxid, const T_CMBX *pk_cmbx);	/* ޥե(ͥؿ) */
ER      del_mbx(ID semid);									/* ޥեκ */
ER      snd_mbx(ID mbxid, T_MSG *pk_msg);					/* ᡼ܥåؤ */
ER      rcv_mbx(ID mbxid, T_MSG **ppk_msg);					/* ᡼ܥåμ */
ER      prcv_mbx(ID mbxid, T_MSG **ppk_msg);				/* ᡼ܥåμ(ݡ) */
ER      trcv_mbx(ID mbxid, T_MSG **ppk_msg, TMO tmout);		/* ᡼ܥåμ(ॢȤ) */
ER      ref_mbx(ID mbxid, T_RMBX *pk_rmbx);					/* ᡼ܥåξֻ */

#ifdef __cplusplus
}
#endif



#endif	/*__HOS_V4__knl_mbx_h__ */


/* ------------------------------------------------------------------------ */
/*  Copyright (C) 1998-2002 by Project HOS                                  */
/* ------------------------------------------------------------------------ */
