/* ------------------------------------------------------------------------ */
/*  Hyper Operating System V4  ITRON4.0 Real-Time OS                  */
/*    ͥ¸إå ߴ                               */
/*                                                                          */
/*                                  Copyright (C) 1998-2002 by Project HOS  */
/*                                  http://sourceforge.jp/projects/hos/     */
/* ------------------------------------------------------------------------ */


#ifndef __HOS_V4__knl_int_h__
#define __HOS_V4__knl_int_h__


#include "knl_hos.h"



/* ------------------------------------------ */
/*                                    */
/* ------------------------------------------ */

/* ֹϰ */
#define KERNEL_TMIN_INTNO	(kernel_min_intno)	/* ֹκǾ */
#define KERNEL_TMAX_INTNO	(KERNEL_TMIN_INTNO + kernel_intcb_cnt - 1)
												/* ֹκ */

/* IDϰ */
#define KERNEL_TMIN_ISRID	TMIN_ISRID			/* ߥӥ롼IDκǾ */
#define KERNEL_TMAX_ISRID	(KERNEL_TMIN_ISRID + kernel_isrcb_cnt - 1)
												/* ߥӥ롼IDκ */



/* ------------------------------------------ */
/*                                      */
/* ------------------------------------------ */

/* ߴȥ֥å */
typedef struct t_kernel_intcb
{
	VP_INT exinf;		/* ߥӥ롼γĥ */
	FP     isr;			/* ߥӥ롼εư */
} T_KERNEL_INTCB;


/* ߥϥɥ */
typedef struct t_dinh
{
	ATR inhatr;			/* ߥϥɥ° */
	FP  inthdr;			/* ߥϥɥεư */
} T_DINH;


/* ߥӥ롼󥳥ȥ֥å */
typedef struct t_kernel_isrcb
{
	INTNO  intno;		/* ֹ */
} T_KERNEL_ISRCB;



/* ---------------------------------- */
/*        Хѿ          */
/* ---------------------------------- */

/* ߴ */
extern T_KERNEL_INTCB  kernel_intcb_tbl[];	/* ߴȥ֥åơ֥ */
extern const INT       kernel_intcb_cnt;	/* ֹ */
extern const INTNO     kernel_min_intno;	/* ֹǾ */

/* ߥӥ롼 */
extern T_KERNEL_ISRCB* kernel_isrcb_tbl[];	/* ߥӥ롼󥳥ȥ֥åơ֥ */
extern const INT       kernel_isrcb_cnt;	/* ߥӥ롼󥳥ȥ֥åθĿ */

/* ѿ */
extern INT kernel_int_cnt;		/* ߥͥȲ */
extern VP  kernel_int_ssp;		/* ߻å */

#define KERNEL_INTNO_TO_INTCB(intno)	(kernel_intcb_tbl[(intno) - KERNEL_TMIN_INTNO])


/* ------------------------------------------ */
/*                ؿ                    */
/* ------------------------------------------ */

#ifdef __cplusplus
extern "C" {
#endif

/*  */
void    kernel_sta_int(void);						/* ߥƥȳϽ */
void    kernel_end_int(void);						/* ߥƥȽλ */

/* ߴ */
void    kernel_exe_int(INTNO intno);				/* ߽¹ */
ER      dis_int(INTNO intno);						/* ߤζػ */
ER      ena_int(INTNO intno);						/* ߤε */


/* ߥϥɥ */
ER      def_inh(INTNO intno, T_DINH *pk_dinh);		/* ߥϥɥ */


/* ߥӥ롼 */
/*
ER      cre_isr();
ER      acre_isr();
*/

#ifdef __cplusplus
}
#endif



#endif	/*  __HOS_V4__knl_int_h__ */


/* ------------------------------------------------------------------------ */
/*  Copyright (C) 1998-2002 by Project HOS                                  */
/* ------------------------------------------------------------------------ */
