/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.linear;

import java.io.Serializable;
import org.apache.commons.math.MathRuntimeException;
import org.apache.commons.math.linear.MatrixIndexException;
import org.apache.commons.math.linear.OpenMapRealMatrix;
import org.apache.commons.math.linear.RealMatrix;
import org.apache.commons.math.linear.RealVector;
import org.apache.commons.math.linear.SparseRealVector;
import org.apache.commons.math.util.OpenIntToDoubleHashMap;

public class OpenMapRealVector
implements SparseRealVector,
Serializable {
    private static final long serialVersionUID = 8772222695580707260L;
    public static final double DEFAULT_ZERO_TOLERANCE = 1.0E-12;
    private final OpenIntToDoubleHashMap entries;
    private final int virtualSize;
    private double epsilon;

    public OpenMapRealVector() {
        this(0, 1.0E-12);
    }

    public OpenMapRealVector(int dimension) {
        this(dimension, 1.0E-12);
    }

    public OpenMapRealVector(int dimension, double epsilon) {
        this.virtualSize = dimension;
        this.entries = new OpenIntToDoubleHashMap(0.0);
        this.epsilon = epsilon;
    }

    protected OpenMapRealVector(OpenMapRealVector v, int resize) {
        this.virtualSize = v.getDimension() + resize;
        this.entries = new OpenIntToDoubleHashMap(v.entries);
        this.epsilon = v.getEpsilon();
    }

    public OpenMapRealVector(int dimension, int expectedSize) {
        this(dimension, expectedSize, 1.0E-12);
    }

    public OpenMapRealVector(int dimension, int expectedSize, double epsilon) {
        this.virtualSize = dimension;
        this.entries = new OpenIntToDoubleHashMap(expectedSize, 0.0);
        this.epsilon = epsilon;
    }

    public OpenMapRealVector(double[] values) {
        this(values, 1.0E-12);
    }

    public OpenMapRealVector(double[] values, double epsilon) {
        this.virtualSize = values.length;
        this.entries = new OpenIntToDoubleHashMap(0.0);
        this.epsilon = epsilon;
        for (int key = 0; key < values.length; ++key) {
            double value = values[key];
            if (this.isZero(value)) continue;
            this.entries.put(key, value);
        }
    }

    public OpenMapRealVector(Double[] values) {
        this(values, 1.0E-12);
    }

    public OpenMapRealVector(Double[] values, double epsilon) {
        this.virtualSize = values.length;
        this.entries = new OpenIntToDoubleHashMap(0.0);
        this.epsilon = epsilon;
        for (int key = 0; key < values.length; ++key) {
            double value = values[key];
            if (this.isZero(value)) continue;
            this.entries.put(key, value);
        }
    }

    public OpenMapRealVector(OpenMapRealVector v) {
        this.virtualSize = v.getDimension();
        this.entries = new OpenIntToDoubleHashMap(v.getEntries());
        this.epsilon = v.getEpsilon();
    }

    public OpenMapRealVector(RealVector v) {
        this.virtualSize = v.getDimension();
        this.entries = new OpenIntToDoubleHashMap(0.0);
        this.epsilon = 1.0E-12;
        for (int key = 0; key < this.virtualSize; ++key) {
            double value = v.getEntry(key);
            if (this.isZero(value)) continue;
            this.entries.put(key, value);
        }
    }

    private OpenIntToDoubleHashMap getEntries() {
        return this.entries;
    }

    protected boolean isZero(double value) {
        return value > -this.epsilon && value < this.epsilon;
    }

    public double getEpsilon() {
        return this.epsilon;
    }

    public void setEpsilon(double epsilon) {
        this.epsilon = epsilon;
    }

    public OpenMapRealVector add(RealVector v) throws IllegalArgumentException {
        this.checkVectorDimensions(v.getDimension());
        if (v instanceof OpenMapRealVector) {
            return this.add((OpenMapRealVector)v);
        }
        return this.add(v.getData());
    }

    public OpenMapRealVector add(OpenMapRealVector v) throws IllegalArgumentException {
        this.checkVectorDimensions(v.getDimension());
        OpenMapRealVector res = this.copy();
        OpenIntToDoubleHashMap.Iterator iter = v.getEntries().iterator();
        while (iter.hasNext()) {
            iter.advance();
            int key = iter.key();
            if (this.entries.containsKey(key)) {
                res.setEntry(key, this.entries.get(key) + iter.value());
                continue;
            }
            res.setEntry(key, iter.value());
        }
        return res;
    }

    public OpenMapRealVector add(double[] v) throws IllegalArgumentException {
        this.checkVectorDimensions(v.length);
        OpenMapRealVector res = new OpenMapRealVector(this.getDimension());
        for (int i = 0; i < v.length; ++i) {
            res.setEntry(i, v[i] + this.getEntry(i));
        }
        return res;
    }

    public OpenMapRealVector append(OpenMapRealVector v) {
        OpenMapRealVector res = new OpenMapRealVector(this, v.getDimension());
        OpenIntToDoubleHashMap.Iterator iter = v.entries.iterator();
        while (iter.hasNext()) {
            iter.advance();
            res.setEntry(iter.key() + this.virtualSize, iter.value());
        }
        return res;
    }

    public OpenMapRealVector append(RealVector v) {
        if (v instanceof OpenMapRealVector) {
            return this.append((OpenMapRealVector)v);
        }
        return this.append(v.getData());
    }

    public OpenMapRealVector append(double d) {
        OpenMapRealVector res = new OpenMapRealVector(this, 1);
        res.setEntry(this.virtualSize, d);
        return res;
    }

    public OpenMapRealVector append(double[] a) {
        OpenMapRealVector res = new OpenMapRealVector(this, a.length);
        for (int i = 0; i < a.length; ++i) {
            res.setEntry(i + this.virtualSize, a[i]);
        }
        return res;
    }

    public OpenMapRealVector copy() {
        return new OpenMapRealVector(this);
    }

    public double dotProduct(RealVector v) throws IllegalArgumentException {
        this.checkVectorDimensions(v.getDimension());
        double res = 0.0;
        OpenIntToDoubleHashMap.Iterator iter = this.entries.iterator();
        while (iter.hasNext()) {
            iter.advance();
            res += v.getEntry(iter.key()) * iter.value();
        }
        return res;
    }

    public double dotProduct(double[] v) throws IllegalArgumentException {
        this.checkVectorDimensions(v.length);
        double res = 0.0;
        OpenIntToDoubleHashMap.Iterator iter = this.entries.iterator();
        while (iter.hasNext()) {
            int idx = iter.key();
            double value = 0.0;
            if (idx < v.length) {
                value = v[idx];
            }
            res += value * iter.value();
        }
        return res;
    }

    public OpenMapRealVector ebeDivide(RealVector v) throws IllegalArgumentException {
        this.checkVectorDimensions(v.getDimension());
        OpenMapRealVector res = new OpenMapRealVector(this);
        OpenIntToDoubleHashMap.Iterator iter = res.entries.iterator();
        while (iter.hasNext()) {
            iter.advance();
            res.setEntry(iter.key(), iter.value() / v.getEntry(iter.key()));
        }
        return res;
    }

    public OpenMapRealVector ebeDivide(double[] v) throws IllegalArgumentException {
        this.checkVectorDimensions(v.length);
        OpenMapRealVector res = new OpenMapRealVector(this);
        OpenIntToDoubleHashMap.Iterator iter = res.entries.iterator();
        while (iter.hasNext()) {
            iter.advance();
            res.setEntry(iter.key(), iter.value() / v[iter.key()]);
        }
        return res;
    }

    public OpenMapRealVector ebeMultiply(RealVector v) throws IllegalArgumentException {
        this.checkVectorDimensions(v.getDimension());
        OpenMapRealVector res = new OpenMapRealVector(this);
        OpenIntToDoubleHashMap.Iterator iter = res.entries.iterator();
        while (iter.hasNext()) {
            iter.advance();
            res.setEntry(iter.key(), iter.value() * v.getEntry(iter.key()));
        }
        return res;
    }

    public OpenMapRealVector ebeMultiply(double[] v) throws IllegalArgumentException {
        this.checkVectorDimensions(v.length);
        OpenMapRealVector res = new OpenMapRealVector(this);
        OpenIntToDoubleHashMap.Iterator iter = res.entries.iterator();
        while (iter.hasNext()) {
            iter.advance();
            res.setEntry(iter.key(), iter.value() * v[iter.key()]);
        }
        return res;
    }

    public OpenMapRealVector getSubVector(int index, int n) throws MatrixIndexException {
        this.checkIndex(index);
        this.checkIndex(index + n - 1);
        OpenMapRealVector res = new OpenMapRealVector(n);
        int end = index + n;
        OpenIntToDoubleHashMap.Iterator iter = this.entries.iterator();
        while (iter.hasNext()) {
            iter.advance();
            int key = iter.key();
            if (key < index || key >= end) continue;
            res.setEntry(key - index, iter.value());
        }
        return res;
    }

    public double[] getData() {
        double[] res = new double[this.virtualSize];
        OpenIntToDoubleHashMap.Iterator iter = this.entries.iterator();
        while (iter.hasNext()) {
            iter.advance();
            res[iter.key()] = iter.value();
        }
        return res;
    }

    public int getDimension() {
        return this.virtualSize;
    }

    public double getDistance(OpenMapRealVector v) throws IllegalArgumentException {
        int key;
        OpenIntToDoubleHashMap.Iterator iter = this.entries.iterator();
        double res = 0.0;
        while (iter.hasNext()) {
            iter.advance();
            key = iter.key();
            double delta = iter.value() - v.getEntry(key);
            res += delta * delta;
        }
        iter = v.getEntries().iterator();
        while (iter.hasNext()) {
            iter.advance();
            key = iter.key();
            if (this.entries.containsKey(key)) continue;
            double value = iter.value();
            res += value * value;
        }
        return Math.sqrt(res);
    }

    public double getDistance(RealVector v) throws IllegalArgumentException {
        this.checkVectorDimensions(v.getDimension());
        if (v instanceof OpenMapRealVector) {
            return this.getDistance((OpenMapRealVector)v);
        }
        return this.getDistance(v.getData());
    }

    public double getDistance(double[] v) throws IllegalArgumentException {
        this.checkVectorDimensions(v.length);
        double res = 0.0;
        for (int i = 0; i < v.length; ++i) {
            double delta = this.entries.get(i) - v[i];
            res += delta * delta;
        }
        return Math.sqrt(res);
    }

    public double getEntry(int index) throws MatrixIndexException {
        this.checkIndex(index);
        return this.entries.get(index);
    }

    public double getL1Distance(OpenMapRealVector v) {
        double max = 0.0;
        OpenIntToDoubleHashMap.Iterator iter = this.entries.iterator();
        while (iter.hasNext()) {
            iter.advance();
            double delta = Math.abs(iter.value() - v.getEntry(iter.key()));
            max += delta;
        }
        iter = v.getEntries().iterator();
        while (iter.hasNext()) {
            iter.advance();
            int key = iter.key();
            if (this.entries.containsKey(key)) continue;
            double delta = Math.abs(iter.value());
            max += Math.abs(delta);
        }
        return max;
    }

    public double getL1Distance(RealVector v) throws IllegalArgumentException {
        this.checkVectorDimensions(v.getDimension());
        if (v instanceof OpenMapRealVector) {
            return this.getL1Distance((OpenMapRealVector)v);
        }
        return this.getL1Distance(v.getData());
    }

    public double getL1Distance(double[] v) throws IllegalArgumentException {
        this.checkVectorDimensions(v.length);
        double max = 0.0;
        for (int i = 0; i < v.length; ++i) {
            double delta = Math.abs(this.getEntry(i) - v[i]);
            max += delta;
        }
        return max;
    }

    public double getL1Norm() {
        double res = 0.0;
        OpenIntToDoubleHashMap.Iterator iter = this.entries.iterator();
        while (iter.hasNext()) {
            iter.advance();
            res += Math.abs(iter.value());
        }
        return res;
    }

    private double getLInfDistance(OpenMapRealVector v) {
        double max = 0.0;
        OpenIntToDoubleHashMap.Iterator iter = this.entries.iterator();
        while (iter.hasNext()) {
            iter.advance();
            double delta = Math.abs(iter.value() - v.getEntry(iter.key()));
            if (!(delta > max)) continue;
            max = delta;
        }
        iter = v.getEntries().iterator();
        while (iter.hasNext()) {
            iter.advance();
            int key = iter.key();
            if (this.entries.containsKey(key) || !(iter.value() > max)) continue;
            max = iter.value();
        }
        return max;
    }

    public double getLInfDistance(RealVector v) throws IllegalArgumentException {
        this.checkVectorDimensions(v.getDimension());
        if (v instanceof OpenMapRealVector) {
            return this.getLInfDistance((OpenMapRealVector)v);
        }
        return this.getLInfDistance(v.getData());
    }

    public double getLInfDistance(double[] v) throws IllegalArgumentException {
        this.checkVectorDimensions(v.length);
        double max = 0.0;
        for (int i = 0; i < v.length; ++i) {
            double delta = Math.abs(this.getEntry(i) - v[i]);
            if (!(delta > max)) continue;
            max = delta;
        }
        return max;
    }

    public double getLInfNorm() {
        double max = 0.0;
        OpenIntToDoubleHashMap.Iterator iter = this.entries.iterator();
        while (iter.hasNext()) {
            iter.advance();
            max += iter.value();
        }
        return max;
    }

    public double getNorm() {
        double res = 0.0;
        OpenIntToDoubleHashMap.Iterator iter = this.entries.iterator();
        while (iter.hasNext()) {
            iter.advance();
            res += iter.value() * iter.value();
        }
        return Math.sqrt(res);
    }

    public boolean isInfinite() {
        boolean infiniteFound = false;
        OpenIntToDoubleHashMap.Iterator iter = this.entries.iterator();
        while (iter.hasNext()) {
            iter.advance();
            double value = iter.value();
            if (Double.isNaN(value)) {
                return false;
            }
            if (!Double.isInfinite(value)) continue;
            infiniteFound = true;
        }
        return infiniteFound;
    }

    public boolean isNaN() {
        OpenIntToDoubleHashMap.Iterator iter = this.entries.iterator();
        while (iter.hasNext()) {
            iter.advance();
            if (!Double.isNaN(iter.value())) continue;
            return true;
        }
        return false;
    }

    public OpenMapRealVector mapAbs() {
        return this.copy().mapAbsToSelf();
    }

    public OpenMapRealVector mapAbsToSelf() {
        OpenIntToDoubleHashMap.Iterator iter = this.entries.iterator();
        while (iter.hasNext()) {
            iter.advance();
            this.entries.put(iter.key(), Math.abs(iter.value()));
        }
        return this;
    }

    public OpenMapRealVector mapAcos() {
        return this.copy().mapAcosToSelf();
    }

    public OpenMapRealVector mapAcosToSelf() {
        for (int i = 0; i < this.virtualSize; ++i) {
            this.setEntry(i, Math.acos(this.getEntry(i)));
        }
        return this;
    }

    public OpenMapRealVector mapAdd(double d) {
        return this.copy().mapAddToSelf(d);
    }

    public OpenMapRealVector mapAddToSelf(double d) {
        for (int i = 0; i < this.virtualSize; ++i) {
            this.setEntry(i, this.getEntry(i) + d);
        }
        return this;
    }

    public OpenMapRealVector mapAsin() {
        return this.copy().mapAsinToSelf();
    }

    public OpenMapRealVector mapAsinToSelf() {
        OpenIntToDoubleHashMap.Iterator iter = this.entries.iterator();
        while (iter.hasNext()) {
            iter.advance();
            this.entries.put(iter.key(), Math.asin(iter.value()));
        }
        return this;
    }

    public OpenMapRealVector mapAtan() {
        return this.copy().mapAtanToSelf();
    }

    public OpenMapRealVector mapAtanToSelf() {
        OpenIntToDoubleHashMap.Iterator iter = this.entries.iterator();
        while (iter.hasNext()) {
            iter.advance();
            this.entries.put(iter.key(), Math.atan(iter.value()));
        }
        return this;
    }

    public OpenMapRealVector mapCbrt() {
        return this.copy().mapCbrtToSelf();
    }

    public OpenMapRealVector mapCbrtToSelf() {
        OpenIntToDoubleHashMap.Iterator iter = this.entries.iterator();
        while (iter.hasNext()) {
            iter.advance();
            this.entries.put(iter.key(), Math.cbrt(iter.value()));
        }
        return this;
    }

    public OpenMapRealVector mapCeil() {
        return this.copy().mapCeilToSelf();
    }

    public OpenMapRealVector mapCeilToSelf() {
        OpenIntToDoubleHashMap.Iterator iter = this.entries.iterator();
        while (iter.hasNext()) {
            iter.advance();
            this.entries.put(iter.key(), Math.ceil(iter.value()));
        }
        return this;
    }

    public OpenMapRealVector mapCos() {
        return this.copy().mapCosToSelf();
    }

    public OpenMapRealVector mapCosToSelf() {
        for (int i = 0; i < this.virtualSize; ++i) {
            this.setEntry(i, Math.cos(this.getEntry(i)));
        }
        return this;
    }

    public OpenMapRealVector mapCosh() {
        return this.copy().mapCoshToSelf();
    }

    public OpenMapRealVector mapCoshToSelf() {
        for (int i = 0; i < this.virtualSize; ++i) {
            this.setEntry(i, Math.cosh(this.getEntry(i)));
        }
        return this;
    }

    public OpenMapRealVector mapDivide(double d) {
        return this.copy().mapDivideToSelf(d);
    }

    public OpenMapRealVector mapDivideToSelf(double d) {
        OpenIntToDoubleHashMap.Iterator iter = this.entries.iterator();
        while (iter.hasNext()) {
            iter.advance();
            this.entries.put(iter.key(), iter.value() / d);
        }
        return this;
    }

    public OpenMapRealVector mapExp() {
        return this.copy().mapExpToSelf();
    }

    public OpenMapRealVector mapExpToSelf() {
        for (int i = 0; i < this.virtualSize; ++i) {
            this.entries.put(i, Math.exp(this.entries.get(i)));
        }
        return this;
    }

    public OpenMapRealVector mapExpm1() {
        return this.copy().mapExpm1ToSelf();
    }

    public OpenMapRealVector mapExpm1ToSelf() {
        OpenIntToDoubleHashMap.Iterator iter = this.entries.iterator();
        while (iter.hasNext()) {
            iter.advance();
            this.entries.put(iter.key(), Math.expm1(iter.value()));
        }
        return this;
    }

    public OpenMapRealVector mapFloor() {
        return this.copy().mapFloorToSelf();
    }

    public OpenMapRealVector mapFloorToSelf() {
        OpenIntToDoubleHashMap.Iterator iter = this.entries.iterator();
        while (iter.hasNext()) {
            iter.advance();
            this.entries.put(iter.key(), Math.floor(iter.value()));
        }
        return this;
    }

    public OpenMapRealVector mapInv() {
        return this.copy().mapInvToSelf();
    }

    public OpenMapRealVector mapInvToSelf() {
        for (int i = 0; i < this.virtualSize; ++i) {
            this.setEntry(i, 1.0 / this.getEntry(i));
        }
        return this;
    }

    public OpenMapRealVector mapLog() {
        return this.copy().mapLogToSelf();
    }

    public OpenMapRealVector mapLog10() {
        return this.copy().mapLog10ToSelf();
    }

    public OpenMapRealVector mapLog10ToSelf() {
        for (int i = 0; i < this.virtualSize; ++i) {
            this.setEntry(i, Math.log10(this.getEntry(i)));
        }
        return this;
    }

    public OpenMapRealVector mapLog1p() {
        return this.copy().mapLog1pToSelf();
    }

    public OpenMapRealVector mapLog1pToSelf() {
        OpenIntToDoubleHashMap.Iterator iter = this.entries.iterator();
        while (iter.hasNext()) {
            iter.advance();
            this.entries.put(iter.key(), Math.log1p(iter.value()));
        }
        return this;
    }

    public OpenMapRealVector mapLogToSelf() {
        for (int i = 0; i < this.virtualSize; ++i) {
            this.setEntry(i, Math.log(this.getEntry(i)));
        }
        return this;
    }

    public OpenMapRealVector mapMultiply(double d) {
        return this.copy().mapMultiplyToSelf(d);
    }

    public OpenMapRealVector mapMultiplyToSelf(double d) {
        OpenIntToDoubleHashMap.Iterator iter = this.entries.iterator();
        while (iter.hasNext()) {
            iter.advance();
            this.entries.put(iter.key(), iter.value() * d);
        }
        return this;
    }

    public OpenMapRealVector mapPow(double d) {
        return this.copy().mapPowToSelf(d);
    }

    public OpenMapRealVector mapPowToSelf(double d) {
        OpenIntToDoubleHashMap.Iterator iter = this.entries.iterator();
        while (iter.hasNext()) {
            iter.advance();
            this.entries.put(iter.key(), Math.pow(iter.value(), d));
        }
        return this;
    }

    public OpenMapRealVector mapRint() {
        return this.copy().mapRintToSelf();
    }

    public OpenMapRealVector mapRintToSelf() {
        OpenIntToDoubleHashMap.Iterator iter = this.entries.iterator();
        while (iter.hasNext()) {
            iter.advance();
            this.entries.put(iter.key(), Math.rint(iter.value()));
        }
        return this;
    }

    public OpenMapRealVector mapSignum() {
        return this.copy().mapSignumToSelf();
    }

    public OpenMapRealVector mapSignumToSelf() {
        OpenIntToDoubleHashMap.Iterator iter = this.entries.iterator();
        while (iter.hasNext()) {
            iter.advance();
            this.entries.put(iter.key(), Math.signum(iter.value()));
        }
        return this;
    }

    public OpenMapRealVector mapSin() {
        return this.copy().mapSinToSelf();
    }

    public OpenMapRealVector mapSinToSelf() {
        OpenIntToDoubleHashMap.Iterator iter = this.entries.iterator();
        while (iter.hasNext()) {
            iter.advance();
            this.entries.put(iter.key(), Math.sin(iter.value()));
        }
        return this;
    }

    public OpenMapRealVector mapSinh() {
        return this.copy().mapSinhToSelf();
    }

    public OpenMapRealVector mapSinhToSelf() {
        OpenIntToDoubleHashMap.Iterator iter = this.entries.iterator();
        while (iter.hasNext()) {
            iter.advance();
            this.entries.put(iter.key(), Math.sinh(iter.value()));
        }
        return this;
    }

    public OpenMapRealVector mapSqrt() {
        return this.copy().mapSqrtToSelf();
    }

    public OpenMapRealVector mapSqrtToSelf() {
        OpenIntToDoubleHashMap.Iterator iter = this.entries.iterator();
        while (iter.hasNext()) {
            iter.advance();
            this.entries.put(iter.key(), Math.sqrt(iter.value()));
        }
        return this;
    }

    public OpenMapRealVector mapSubtract(double d) {
        return this.copy().mapSubtractToSelf(d);
    }

    public OpenMapRealVector mapSubtractToSelf(double d) {
        return this.mapAddToSelf(-d);
    }

    public OpenMapRealVector mapTan() {
        return this.copy().mapTanToSelf();
    }

    public OpenMapRealVector mapTanToSelf() {
        OpenIntToDoubleHashMap.Iterator iter = this.entries.iterator();
        while (iter.hasNext()) {
            iter.advance();
            this.entries.put(iter.key(), Math.tan(iter.value()));
        }
        return this;
    }

    public OpenMapRealVector mapTanh() {
        return this.copy().mapTanhToSelf();
    }

    public OpenMapRealVector mapTanhToSelf() {
        OpenIntToDoubleHashMap.Iterator iter = this.entries.iterator();
        while (iter.hasNext()) {
            iter.advance();
            this.entries.put(iter.key(), Math.tanh(iter.value()));
        }
        return this;
    }

    public OpenMapRealVector mapUlp() {
        return this.copy().mapUlpToSelf();
    }

    public OpenMapRealVector mapUlpToSelf() {
        OpenIntToDoubleHashMap.Iterator iter = this.entries.iterator();
        while (iter.hasNext()) {
            iter.advance();
            this.entries.put(iter.key(), Math.ulp(iter.value()));
        }
        return this;
    }

    public OpenMapRealMatrix outerproduct(OpenMapRealVector v) throws IllegalArgumentException {
        this.checkVectorDimensions(v.getDimension());
        OpenMapRealMatrix res = new OpenMapRealMatrix(this.virtualSize, this.virtualSize);
        OpenIntToDoubleHashMap.Iterator iter = this.entries.iterator();
        while (iter.hasNext()) {
            iter.advance();
            OpenIntToDoubleHashMap.Iterator iter2 = v.getEntries().iterator();
            while (iter2.hasNext()) {
                iter2.advance();
                res.setEntry(iter.key(), iter2.key(), iter.value() * iter2.value());
            }
        }
        return res;
    }

    public RealMatrix outerProduct(RealVector v) throws IllegalArgumentException {
        this.checkVectorDimensions(v.getDimension());
        if (v instanceof OpenMapRealVector) {
            return this.outerproduct((OpenMapRealVector)v);
        }
        OpenMapRealMatrix res = new OpenMapRealMatrix(this.virtualSize, this.virtualSize);
        OpenIntToDoubleHashMap.Iterator iter = this.entries.iterator();
        while (iter.hasNext()) {
            iter.advance();
            int row = iter.key();
            for (int col = 0; col < this.virtualSize; ++col) {
                res.setEntry(row, col, iter.value() * v.getEntry(col));
            }
        }
        return res;
    }

    public RealMatrix outerProduct(double[] v) throws IllegalArgumentException {
        this.checkVectorDimensions(v.length);
        OpenMapRealMatrix res = new OpenMapRealMatrix(this.virtualSize, this.virtualSize);
        OpenIntToDoubleHashMap.Iterator iter = this.entries.iterator();
        while (iter.hasNext()) {
            iter.advance();
            int row = iter.key();
            double value = iter.value();
            for (int col = 0; col < this.virtualSize; ++col) {
                res.setEntry(row, col, value * v[col]);
            }
        }
        return res;
    }

    public RealVector projection(RealVector v) throws IllegalArgumentException {
        this.checkVectorDimensions(v.getDimension());
        return v.mapMultiply(this.dotProduct(v) / v.dotProduct(v));
    }

    public OpenMapRealVector projection(double[] v) throws IllegalArgumentException {
        this.checkVectorDimensions(v.length);
        return (OpenMapRealVector)this.projection(new OpenMapRealVector(v));
    }

    public void setEntry(int index, double value) throws MatrixIndexException {
        this.checkIndex(index);
        if (!this.isZero(value)) {
            this.entries.put(index, value);
        } else if (this.entries.containsKey(index)) {
            this.entries.remove(index);
        }
    }

    public void setSubVector(int index, RealVector v) throws MatrixIndexException {
        this.checkIndex(index);
        this.checkIndex(index + v.getDimension() - 1);
        this.setSubVector(index, v.getData());
    }

    public void setSubVector(int index, double[] v) throws MatrixIndexException {
        this.checkIndex(index);
        this.checkIndex(index + v.length - 1);
        for (int i = 0; i < v.length; ++i) {
            this.setEntry(i + index, v[i]);
        }
    }

    public void set(double value) {
        for (int i = 0; i < this.virtualSize; ++i) {
            this.setEntry(i, value);
        }
    }

    public OpenMapRealVector subtract(OpenMapRealVector v) throws IllegalArgumentException {
        this.checkVectorDimensions(v.getDimension());
        OpenMapRealVector res = this.copy();
        OpenIntToDoubleHashMap.Iterator iter = v.getEntries().iterator();
        while (iter.hasNext()) {
            iter.advance();
            int key = iter.key();
            if (this.entries.containsKey(key)) {
                res.setEntry(key, this.entries.get(key) - iter.value());
                continue;
            }
            res.setEntry(key, -iter.value());
        }
        return res;
    }

    public OpenMapRealVector subtract(RealVector v) throws IllegalArgumentException {
        this.checkVectorDimensions(v.getDimension());
        if (v instanceof OpenMapRealVector) {
            return this.subtract((OpenMapRealVector)v);
        }
        return this.subtract(v.getData());
    }

    public OpenMapRealVector subtract(double[] v) throws IllegalArgumentException {
        this.checkVectorDimensions(v.length);
        OpenMapRealVector res = new OpenMapRealVector(this);
        for (int i = 0; i < v.length; ++i) {
            if (this.entries.containsKey(i)) {
                res.setEntry(i, this.entries.get(i) - v[i]);
                continue;
            }
            res.setEntry(i, -v[i]);
        }
        return res;
    }

    public OpenMapRealVector unitVector() {
        OpenMapRealVector res = this.copy();
        res.unitize();
        return res;
    }

    public void unitize() {
        double norm = this.getNorm();
        if (this.isZero(norm)) {
            throw MathRuntimeException.createArithmeticException("cannot normalize a zero norm vector", new Object[0]);
        }
        OpenIntToDoubleHashMap.Iterator iter = this.entries.iterator();
        while (iter.hasNext()) {
            iter.advance();
            this.entries.put(iter.key(), iter.value() / norm);
        }
    }

    private void checkIndex(int index) throws MatrixIndexException {
        if (index < 0 || index >= this.getDimension()) {
            throw new MatrixIndexException("index {0} out of allowed range [{1}, {2}]", index, 0, this.getDimension() - 1);
        }
    }

    protected void checkVectorDimensions(int n) throws IllegalArgumentException {
        if (this.getDimension() != n) {
            throw MathRuntimeException.createIllegalArgumentException("vector length mismatch: got {0} but expected {1}", this.getDimension(), n);
        }
    }

    public double[] toArray() {
        return this.getData();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this.epsilon);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + this.virtualSize;
        OpenIntToDoubleHashMap.Iterator iter = this.entries.iterator();
        while (iter.hasNext()) {
            iter.advance();
            temp = Double.doubleToLongBits(iter.value());
            result = 31 * result + (int)(temp ^ temp >> 32);
        }
        return result;
    }

    public boolean equals(Object obj) {
        double test;
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OpenMapRealVector)) {
            return false;
        }
        OpenMapRealVector other = (OpenMapRealVector)obj;
        if (this.virtualSize != other.virtualSize) {
            return false;
        }
        if (Double.doubleToLongBits(this.epsilon) != Double.doubleToLongBits(other.epsilon)) {
            return false;
        }
        OpenIntToDoubleHashMap.Iterator iter = this.entries.iterator();
        while (iter.hasNext()) {
            iter.advance();
            test = other.getEntry(iter.key());
            if (Double.doubleToLongBits(test) == Double.doubleToLongBits(iter.value())) continue;
            return false;
        }
        iter = other.getEntries().iterator();
        while (iter.hasNext()) {
            iter.advance();
            test = iter.value();
            if (Double.doubleToLongBits(test) == Double.doubleToLongBits(this.getEntry(iter.key()))) continue;
            return false;
        }
        return true;
    }

    public double getSparcity() {
        return (double)this.entries.size() / (double)this.getDimension();
    }
}

