#!/bin/zsh

release=`basename $PWD`
jarfile=$release

mkdir classes
javac -d classes -sourcepath src -source 1.5 src/**/*.java
( cd classes ; jar cvf ../${jarfile}.jar * )
rm -r classes

if [ -e doc ] ; then
  rm -r doc/*
else
  mkdir doc
fi
javadoc -d doc -protected -version -author src/**/*.java

( cd ../ ; rm ${release}.zip ; zip -r ${release}.zip $release -x ${release}/**/.svn/**/{*,.*} ${release}/**/*~ )

