package jp.crestmuse.cmx.inference.game;

import java.awt.Color;
import java.awt.Graphics;

public class MusicLog {

  private static final int MOVE_LIMIT = 10;
  private int x, y;
  private int length;
  private int targetY;
  private Color color;

  public void init(int x, int y, int length, Color color) {
    this.x = x;
    this.y = y;
    this.length = length;
    this.color = color;
    targetY = y;
  }

  public void update() {
    y += Math.max(Math.min((targetY - y), MOVE_LIMIT), -MOVE_LIMIT);
  }

  public void paint(Graphics g) {
    g.setColor(color);
    g.fillOval(x, y, length, length);
  }

  public void updateTargetY() {
    targetY += length;
  }
}
