package jp.crestmuse.cmx.inference.game;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;

import javax.swing.ImageIcon;
import javax.swing.JPanel;

import jp.crestmuse.cmx.amusaj.filewrappers.BayesNetWrapper;
import jp.crestmuse.cmx.inference.Calculator;
import jp.crestmuse.cmx.inference.MusicRepresentation;
import jp.crestmuse.cmx.inference.MusicRepresentation.MusicElement;
import jp.crestmuse.cmx.sound.TickTimer;

public class MelodyPanel extends JPanel implements Calculator {

  private final boolean[] isWhiteKey = { true, false, true, false, true, true,
      false, true, false, true, false, true };
  private final int[] noteIndex2whiteKey = { 0, -1, 1, -1, 2, 3, -1, 4, -1, 5,
      -1, 6 };
  private static final int PANEL_WIDTH = 420;
  private static final int PANEL_HEIGHT = 580;
  private static final int KEYBOARD_LENGTH = 120;
//  private static final int NOTELOG_NUM = 4;
  private static final int MOVE_LIMIT = 10;
//  private int notelogLength;
  private int keyboardY;
  private PressedKey pressedKey;
  private Beam[] beams;
  private DoubleBeam[] dbeams;
  private NextPredictArrow nextPredictArrow;
  private CountBar countBar;
  private double[] predictedNoteProbs;
  private LinkedList<Double> entropies;
  int secondCount, lastCount;
  // private Image puyo;
  // private Image boring;
  // private Image flust;
  private Puyo puyo;
//  private TickTimer musicTimer;
  private boolean friendly = true;
  // private Robo green;
  // private Robo red;
  private Robots robots;
  private ThrowBalls throwBalls;
  // private int balanceCounter = 0;
  // private ReflectNoteBall[] noteBalls;
  private NoteBalls noteBalls;
  private boolean calcFriendlyByRank;
  private double friendlyEntropyThreshold = 2.7;
  private BayesNetWrapper bayesNet;
  private int prevNote = -1;

  public MelodyPanel(TickTimer musicTimer) {
    this(musicTimer, 0);
  }

  public MelodyPanel(TickTimer musicTimer, double friendlyEntropyThreshold) {
    setPreferredSize(new Dimension(PANEL_WIDTH, PANEL_HEIGHT));
    // puyo = new ImageIcon("puyo.png").getImage();
    // boring = new ImageIcon("boring.png").getImage();
    // flust = new ImageIcon("flust.png").getImage();
    puyo = new Puyo((PANEL_WIDTH - 128) / 2, PANEL_HEIGHT - 128, 128, 128);
    // green = new Robo(0, (PANEL_HEIGHT - 128) / 2, 128, 128, new
    // ImageIcon("greena.png").getImage(), new
    // ImageIcon("greenb.png").getImage());
    // red = new Robo(PANEL_WIDTH - 128, (PANEL_HEIGHT - 128) / 2, 128, 128, new
    // ImageIcon("redb.png").getImage(), new ImageIcon("reda.png").getImage());
    robots = new Robots(PANEL_WIDTH / 2, (PANEL_HEIGHT - 128) / 2);
    throwBalls = new ThrowBalls();
//    notelogLength = PANEL_WIDTH / 7;
    // keyboardY = PANEL_HEIGHT - (KEYBOARD_LENGTH + notelogLength *
    // NOTELOG_NUM);
    keyboardY = 0;
    pressedKey = new PressedKey();
    beams = new Beam[10];
    for (int i = 0; i < 10; i++)
      beams[i] = new Beam();
    dbeams = new DoubleBeam[10];
    for (int i = 0; i < 10; i++)
      dbeams[i] = new DoubleBeam();
    nextPredictArrow = new NextPredictArrow(keyboardY / 2
        - NextPredictArrow.DEFAULT_HEIGHT / 2);
    countBar = new CountBar();
    predictedNoteProbs = new double[12];
    entropies = new LinkedList<Double>();
    secondCount = lastCount = 0;
//    this.musicTimer = musicTimer;
    // noteBalls = new ReflectNoteBall[10];
    // for(int i=0; i<10; i++)
    // noteBalls[i] = new ReflectNoteBall();
    noteBalls = new NoteBalls();
    if (friendlyEntropyThreshold > 0) {
      this.friendlyEntropyThreshold = friendlyEntropyThreshold;
      this.calcFriendlyByRank = false;
    } else
      this.calcFriendlyByRank = true;
    bayesNet = new BayesNetWrapper("contents/trigram.xml");
  }

//  private boolean fin = false;

  public void update(MusicRepresentation musRep, MusicElement me, int index) {
    // if(fin) return;
    // if(index == 0) {
    // double averageEntropy = 0;
    // for(double d : entropies)
    // averageEntropy += d;
    // averageEntropy /= entropies.size();
    // int totalHit = countBar.yellowCount + countBar.greenCount;
    // System.out.println(countBar.yellowCount + " / " + totalHit + " = " +
    // countBar.yellowCount / (double)totalHit);
    // System.out.println(secondCount + " / " + totalHit + " = " + secondCount /
    // (double)totalHit);
    // System.out.println(lastCount + " / " + totalHit + " = " + lastCount /
    // (double)totalHit);
    // System.out.println(averageEntropy);
    // fin = true;
    // return;
    // }
    int currentNoteIndex = me.getHighestProbIndex();
    int currentX = index2x(currentNoteIndex);
    double currentNoteProb = predictedNoteProbs[currentNoteIndex];
    Arrays.sort(predictedNoteProbs);
    if (currentNoteProb == predictedNoteProbs[11]) {
      for (DoubleBeam b : dbeams) {
        if (b.alive)
          continue;
        b
            .init(currentX, 0, keyboardY / 2, keyboardY, Color.YELLOW,
                Color.GREEN);
        nextPredictArrow.prepareHitBeam(b);
        break;
      }
      countBar.yellowCount++;
    } else {
      if (currentNoteProb == predictedNoteProbs[10])
        secondCount++;
      else if (currentNoteProb == predictedNoteProbs[0])
        lastCount++;
      for (Beam b : beams) {
        if (b.alive)
          continue;
        b.init(currentX, 0, keyboardY, Color.GREEN);
        break;
      }
      countBar.greenCount++;
    }
    if (calcFriendlyByRank) {
      friendly = true;
      for (int i = 0; i < 6; i++)
        if (currentNoteProb == predictedNoteProbs[i]) {
          friendly = false;
          break;
        }
    }

    // update bayes net
    bayesNet.setEvidence(0, prevNote);
    bayesNet.setEvidence(1, currentNoteIndex);
    bayesNet.update();
    prevNote = currentNoteIndex;

    // predict next note
    double[] margin = bayesNet.getMargin(2);
    double entropy = 0;
    for (int i = 0; i < 12; i++) {
      predictedNoteProbs[i] = margin[i];
      if (predictedNoteProbs[i] != 0.0)
        entropy += -predictedNoteProbs[i] * Math.log(predictedNoteProbs[i])
            / Math.log(2);
    }
    if (entropy > 0) {
      System.err.println(entropy);
      entropies.add(entropy);
    }
    int nextX = index2x(bayesNet.getHighestMarginIndex(2));
    nextPredictArrow.targetX = nextX - NextPredictArrow.DEFAULT_WIDTH / 2;
    pressedKey.init(currentNoteIndex);

    if (!calcFriendlyByRank) {
      friendly = entropy < friendlyEntropyThreshold;
    }

    // if(friendly && balanceCounter < 0 || !friendly && balanceCounter > 0)
    // balanceCounter = 0;
    // balanceCounter = friendly ? balanceCounter + 1 : balanceCounter - 1;

    // Color toPuyoColor = friendly ? Color.GREEN : Color.RED;
    // int robox = friendly ? 64 : PANEL_WIDTH - 64;
    // for(ReflectNoteBall nb : noteBalls) {
    // if(nb.exist) continue;
    // nb.init(Color.GRAY, toPuyoColor, currentX, KEYBOARD_LENGTH, robox,
    // green.y + 64, (PANEL_WIDTH - 128) / 2, PANEL_HEIGHT - 64);
    // break;
    // }
    noteBalls.add(currentX, KEYBOARD_LENGTH, PANEL_HEIGHT / 2 - 50, friendly);
  }

  private int index2x(int index) {
    if (isWhiteKey[index])
      return getWidth() * noteIndex2whiteKey[index] / 7 + getWidth() / 14;
    return getWidth() * index / 12 + getWidth() / 24;
  }

  public void update(long elapsedTime) {
    pressedKey.update();
    // for (Beam b : beams)
    // b.update();
    // for (DoubleBeam db : dbeams)
    // db.update();
    // nextPredictArrow.update();
    // countBar.update();
    // for(ReflectNoteBall nb : noteBalls)
    // nb.update();
    noteBalls.update(elapsedTime);
    // green.update(elapsedTime);
    // red.update(elapsedTime);
    robots.update(elapsedTime);
    throwBalls.update(elapsedTime);
    puyo.update(elapsedTime);
  }

  public void paint(Graphics g) {
    super.paint(g);

    // keyboard
    g.setColor(Color.WHITE);
    g.fillRect(0, keyboardY, getWidth(), KEYBOARD_LENGTH);
    int whiteKeyHeight = (int) (getWidth() / 7.0);
    boolean nextInWhite = isWhiteKey[pressedKey.index];
    if (nextInWhite) {
      g.setColor(pressedKey.color);
      g.fillRect(whiteKeyHeight * noteIndex2whiteKey[pressedKey.index],
          keyboardY, whiteKeyHeight, KEYBOARD_LENGTH);
    }
    g.setColor(Color.BLACK);
    for (int i = 0; i < 7; i++)
      g.drawLine(whiteKeyHeight * i, keyboardY, whiteKeyHeight * i, keyboardY
          + KEYBOARD_LENGTH);
    int blackKeyHeight = (int) (getWidth() / 12.0);
    for (int i = 0; i < 12; i++)
      if (!isWhiteKey[i])
        g.fillRect(blackKeyHeight * i, keyboardY, blackKeyHeight,
            KEYBOARD_LENGTH * 2 / 3);
    if (!nextInWhite) {
      g.setColor(pressedKey.color);
      g.fillRect(blackKeyHeight * pressedKey.index, keyboardY, blackKeyHeight,
          KEYBOARD_LENGTH * 2 / 3);
    }

    // beams
    // for (Beam b : beams)
    // b.draw(g);
    // for (DoubleBeam db : dbeams)
    // db.draw(g);

    // arrow
    // nextPredictArrow.draw(g);

    // bar
    // countBar.draw(g);
    // g.drawImage(kuro, (420-128)/2, 0, (420-128)/2+128, 128, 0, 0, 128, 128,
    // null);
    // g.drawImage(midori, 0, 580-128, 128, 580, 0, 0, 128, 128, null);
    // g.drawImage(aka, 420-128, 580-128, 420, 580, 0, 0, 128, 128, null);

    // popup
    g.setColor(Color.WHITE);
    g.fillOval(0, (PANEL_HEIGHT - 200) / 2, PANEL_WIDTH, 200);
    g.fillOval(300, 390, 75, 50);
    g.fillOval(290, 460, 30, 30);

    // note ball
    // for(ReflectNoteBall nb : noteBalls)
    // nb.draw(g);
    noteBalls.draw(g);

    // robot
    // green.draw(g);
    // red.draw(g);
    robots.draw(g);
    throwBalls.draw(g);

    // puyo
    // Image currentImage;
    // if(balanceCounter > 3)
    // currentImage = boring;
    // else if(balanceCounter < -3)
    // currentImage = flust;
    // else
    // currentImage = puyo;
    // g.drawImage(currentImage, (PANEL_WIDTH-128)/2, PANEL_HEIGHT - 128,
    // (PANEL_WIDTH-128)/2+128, PANEL_HEIGHT, 0, 0, 128, 128, null);
    puyo.draw(g);
  }

  private class PressedKey {

    int index;
    Color color;
    int alpha;

    PressedKey() {
      color = new Color(0, 255, 0, 0); 
    }

    void init(int index) {
      this.index = index;
      alpha = 255;
    }

    void update() {
      if (alpha <= 0)
        return;
      alpha = Math.max(alpha - 5, 0);
      color = new Color(color.getRed(), color.getGreen(), color.getBlue(),
          alpha);
    }
  }
/*
  private class ReflectNoteBall extends GameEntity {
    int x, y, roboX, roboY, puyoX, puyoY;
    Color currentColor, nextColor;
    State toRobo, toPuyo;
    boolean exist = false;

    ReflectNoteBall() {
      toRobo = new State() {
        public void execute(long elapsedTime) {
          x += Math.min(Math.max(roboX - x, -MOVE_LIMIT), MOVE_LIMIT);
          y += Math.min(Math.max(roboY - y, -MOVE_LIMIT), MOVE_LIMIT);
          if (x == roboX && y == roboY) {
            currentColor = nextColor;
            changeState(toPuyo);
          }
        }

        public void draw(Graphics g) {
          drawBody(g);
        }
      };
      toPuyo = new State() {
        public void execute(long elapsedTime) {
          x += Math.min(Math.max(puyoX - x, -MOVE_LIMIT), MOVE_LIMIT);
          y += Math.min(Math.max(puyoY - y, -MOVE_LIMIT), MOVE_LIMIT);
          if (x == puyoX && y == puyoY) {
            exist = false;
            changeState(State.EmptyState);
          }
        }

        public void draw(Graphics g) {
          drawBody(g);
        }
      };
    }

    void init(Color toRoboColor, Color toPuyoColor, int startX, int startY,
        int robox, int roboy, int puyox, int puyoy) {
      x = startX;
      y = startY;
      roboX = robox;
      roboY = roboy;
      puyoX = puyox;
      puyoY = puyoy;
      currentColor = toRoboColor;
      nextColor = toPuyoColor;
      exist = true;
      changeState(toRobo);
    }

    public void drawBody(Graphics g) {
      g.setColor(currentColor);
      g.fillRect(x, y, 10, 10);
    }
  }
*/
  private class NoteBalls {
    static final int NOTEBALL_NUM = 32;
    static final long REQIRE_TIME = 500;
    long currentTime = 0, leastTime = 0;
    NoteBall[] nbs;
    int balanceCounter = 0;
    LinkedList<NoteBall> noteBallList;
    int nextIndex = 0;
    NoteBall lastNoteBall;

    NoteBalls() {
      nbs = new NoteBall[NOTEBALL_NUM];
      for (int i = 0; i < NOTEBALL_NUM; i++)
        nbs[i] = new NoteBall();
      noteBallList = new LinkedList<NoteBall>();
    }

    void update(long elapsedTime) {
      currentTime += elapsedTime;
      for (NoteBall nb : nbs)
        nb.update(elapsedTime);
    }

    void draw(Graphics g) {
      g.setColor(Color.GRAY);
      for (NoteBall nb : nbs)
        nb.draw(g);
    }

    void add(int x, int startY, int targetY, boolean friendly) {
      long arivalTime = Math.max(leastTime, currentTime + REQIRE_TIME);
//      for (NoteBall nb : nbs)
//        if (!nb.alive) {
//          nb.init(x, startY, targetY, arivalTime - currentTime, friendly);
//          noteBallList.add(nb);
//          break;
//        }
      nbs[nextIndex].init(x, startY, targetY, arivalTime - currentTime, friendly);
      noteBallList.add(nbs[nextIndex]);
      lastNoteBall = nbs[nextIndex];
      nextIndex = (nextIndex + 1) % NOTEBALL_NUM;
//      leastTime = arivalTime + Robots.CAPTURE_TIME * 2;
      if (friendly && balanceCounter < 0 || !friendly && balanceCounter > 0)
        balanceCounter = 0;
      balanceCounter = friendly ? balanceCounter + 1 : balanceCounter - 1;
      if (balanceCounter <= -Robots.CAPTURE_LIMIT
          || balanceCounter >= Robots.CAPTURE_LIMIT) {
        balanceCounter = 0;
//        leastTime += Robots.TRUSH_TIME * 2;
      }
    }

    NoteBall getNextTarget() {
      if (noteBallList.size() == 0)
        return null;
      return noteBallList.removeFirst();
//      if(lastNoteBall != null && !lastNoteBall.alive) return null;
//      return lastNoteBall;
    }

    boolean hurry() {
      if(noteBallList.size() == 0)
        return false;
      return !noteBallList.get(0).alive;
    }

    class NoteBall {
      static final int DIA = 15;
      int x, y, startY, targetY;
      long totalTime, reqireTime;
      boolean friendly;
      boolean alive = false;

      void init(int x, int startY, int targetY, long reqireTime,
          boolean friendly) {
        this.x = x;
        this.y = startY;
        this.startY = startY;
        this.targetY = targetY;
        totalTime = 0;
        this.reqireTime = reqireTime;
        this.friendly = friendly;
        alive = true;
      }

      void update(long elapsedTime) {
        if (!alive)
          return;
        totalTime = Math.min(totalTime + elapsedTime, reqireTime);
        y = (int) ((targetY - startY) * totalTime / reqireTime) + startY;
        if (y == targetY)
          alive = false;
      }

      void draw(Graphics g) {
        if (!alive)
          return;
        g.fillOval(x, y, DIA, DIA);
      }

    }

  }
/*
  private class Robo extends GameEntity {
    Image current, stayImage, highImage;
    int x, y, width, height;
    int prevBeat = 0;
    State stay;

    Robo(int _x, int _y, int _width, int _height, Image normal, Image high) {
      x = _x;
      y = _y;
      width = _width;
      height = _height;
      stayImage = normal;
      highImage = high;
      current = highImage;
      stay = new State() {
        public void execute(long elapsedTime) {
          int currentBeat = (int) (musicTimer.getTickPosition() / musicTimer
              .getTicksPerBeat());
          if (prevBeat < currentBeat) {
            prevBeat = currentBeat;
            if (friendly)
              current = stayImage;
            else
              current = highImage;
          }
        }

        public void draw(Graphics g) {
          g.drawImage(current, x, y, x + width, y + height, 0, 0, width,
              height, null);
        }
      };
      changeState(stay);
    }
  }
*/
  private class Robots extends GameEntity {
    static final long CAPTURE_TIME = 17 * 33;
    static final long TRUSH_TIME = 500;
    static final int CAPTURE_LIMIT = 1;
    static final int WIDTH = 128;
    static final int HEIGHT = 128;
    int x, y, startX;
    NoteBalls.NoteBall targetNoteBall;
    State wait, run, capture, trush;
    int balanceCounter = 0;
    Image greenWait, redWait, greenRun, redRun;

    Robots(int x, int y) {
      this.x = x;
      this.y = y;
      greenWait = new ImageIcon("contents/greenWait.png").getImage();
      redWait = new ImageIcon("contents/redWait.png").getImage();
      greenRun = new ImageIcon("contents/greenRun.png").getImage();
      redRun = new ImageIcon("contents/redRun.png").getImage();
      wait = new Wait();
      run = new Run();
      capture = new Capture();
      trush = new Trush();
      changeState(wait);
    }

    class Wait extends State {

      public void execute(long elapsedTime) {
        targetNoteBall = noteBalls.getNextTarget();
        if (targetNoteBall != null) {
          if (targetNoteBall.friendly && balanceCounter < 0
              || !targetNoteBall.friendly && balanceCounter > 0)
            balanceCounter = 0;
          balanceCounter = targetNoteBall.friendly ? balanceCounter + 1
              : balanceCounter - 1;
          changeState(run);
        }
      }

      public void draw(Graphics g) {
        g.drawImage(greenWait, x - WIDTH + 10, y, x + 10, y + HEIGHT, 0, 0, WIDTH, HEIGHT, null);
        g.drawImage(redWait, x + WIDTH - 10, y, x - 10, y + HEIGHT, 0, 0, WIDTH, HEIGHT, null);
      }

    }

    class Run extends State {
      
      int gdx1, gdx2, rdx1, rdx2;

      public void enter() {
        startX = x;
        if(targetNoteBall.x - x > 0) {
          gdx1 = -WIDTH;
          gdx2 = 0;
          rdx1 = 0;
          rdx2 = WIDTH;
        } else {
          gdx1 = 0;
          gdx2 = -WIDTH;
          rdx1 = WIDTH;
          rdx2 = 0;
        }
      }

      public void execute(long elapsedTime) {
        x = (int) ((targetNoteBall.x - startX) * targetNoteBall.totalTime / targetNoteBall.reqireTime)
            + startX;
        if (!targetNoteBall.alive)
          changeState(capture);
      }

      public void draw(Graphics g) {
        g.drawImage(greenRun, x + gdx1, y, x + gdx2, y + HEIGHT, 0, 0, WIDTH, HEIGHT, null);
        g.drawImage(redRun, x + rdx1, y, x + rdx2, y + HEIGHT, 0, 0, WIDTH, HEIGHT, null);
      }

    }

    class Capture extends State {
      long totalTime;
      AnimationSequence greenCapture;
      AnimationSequence greenFall;
      AnimationSequence redCapture;
      AnimationSequence redFall;

      Capture() {
        greenCapture = new AnimationSequence();
        greenCapture.add(new ImageIcon("contents/greenCapture00.png").getImage(), 5);
        greenCapture.add(new ImageIcon("contents/greenCapture01.png").getImage(), 3);
        greenCapture.add(new ImageIcon("contents/greenCapture02.png").getImage(), 3);
        greenCapture.add(new ImageIcon("contents/greenCapture03.png").getImage(), 3);
        greenCapture.add(new ImageIcon("contents/greenCapture04.png").getImage(), 3);
        greenFall = new AnimationSequence();
        greenFall.add(new ImageIcon("contents/greenFall00.png").getImage(), 3);
//        greenFall.add(new ImageIcon("greenFall01.png").getImage(), 3);
//        greenFall.add(new ImageIcon("greenFall02.png").getImage(), 3);
        greenFall.add(new ImageIcon("contents/greenFall03.png").getImage(), 3);
        redCapture = new AnimationSequence();
        redCapture.add(new ImageIcon("contents/redCapture00.png").getImage(), 5);
        redCapture.add(new ImageIcon("contents/redCapture01.png").getImage(), 3);
        redCapture.add(new ImageIcon("contents/redCapture02.png").getImage(), 3);
        redCapture.add(new ImageIcon("contents/redCapture03.png").getImage(), 3);
        redCapture.add(new ImageIcon("contents/redCapture04.png").getImage(), 3);
        redFall = new AnimationSequence();
        redFall.add(new ImageIcon("contents/redFall00.png").getImage(), 3);
        redFall.add(new ImageIcon("contents/redFall03.png").getImage(), 3);
      }

      public void enter() {
        totalTime = 0;
        greenCapture.init();
        greenFall.init();
        redCapture.init();
        redFall.init();
      }

      public void execute(long elapsedTime) {
        greenFall.next();
        redFall.next();
        redCapture.next();
        if (greenCapture.next() == null || noteBalls.hurry()) {
          if (balanceCounter >= CAPTURE_LIMIT
              || balanceCounter <= -CAPTURE_LIMIT) {
            changeState(trush);
          } else {
            changeState(wait);
          }
        }
      }

      public void draw(Graphics g) {
        if(targetNoteBall.friendly) {
          g.drawImage(greenCapture.currentKeyFrame.image, x - WIDTH + 20, y, x + 20, y + HEIGHT, 0, 0, WIDTH, HEIGHT, null);
          g.drawImage(redFall.currentKeyFrame.image, x + WIDTH, y + 20, x, y + HEIGHT + 20, 0, 0, WIDTH, HEIGHT, null);
        } else {
          g.drawImage(greenFall.currentKeyFrame.image, x - WIDTH + 30, y + 10, x + 30, y + HEIGHT + 10, 0, 0, WIDTH, HEIGHT, null);
          g.drawImage(redCapture.currentKeyFrame.image, x + WIDTH, y, x, y + HEIGHT, 0, 0, WIDTH, HEIGHT, null);
        }
      }

    }

    class Trush extends State {
      long totalTime;
      Image greenTrush = new ImageIcon("contents/greenTrush.png").getImage();
      Image redTrush = new ImageIcon("contents/redTrush.png").getImage();

      public void enter() {
        totalTime = 0;
        throwBalls.init(x, y + 100, (PANEL_WIDTH - ThrowBalls.DIA) / 2, puyo.y, targetNoteBall.friendly);
      }

      public void execute(long elapsedTime) {
        totalTime += elapsedTime;
        if (totalTime > TRUSH_TIME || noteBalls.hurry()) {
          balanceCounter = 0;
          changeState(wait);
        }
      }

      public void draw(Graphics g) {
        if(targetNoteBall.friendly) {
          g.drawImage(greenTrush, x - WIDTH + 40, y, x + 40, y + HEIGHT, 0, 0, WIDTH, HEIGHT, null);
          g.drawImage(redWait, x + WIDTH, y, x, y + HEIGHT, 0, 0, WIDTH, HEIGHT, null);
        } else {
          g.drawImage(greenWait, x - WIDTH, y, x, y + HEIGHT, 0, 0, WIDTH, HEIGHT, null);
          g.drawImage(redTrush, x + WIDTH, y, x, y + HEIGHT, 0, 0, WIDTH, HEIGHT, null);
        }
      }

    }

  }

  private class ThrowBalls {
    static final long REQIRED_TIME = 500;
    static final int DIA = 32;
    int x, y, sx, sy, tx, ty;
    long totalTime = 0;
    boolean friendly;
    Color color;
    boolean alive = false;

    void init(int startX, int startY, int targetX, int targetY, boolean friendly) {
      this.x = startX;
      this.y = startY;
      this.sx = startX;
      this.sy = startY;
      this.tx = targetX;
      this.ty = targetY;
      this.friendly = friendly;
      color = friendly ? Color.GREEN : Color.RED;
      totalTime = 0;
      alive = true;
    }

    void update(long elapsedTime) {
      if (!alive)
        return;
      totalTime = Math.min(totalTime + elapsedTime, REQIRED_TIME);
      x = (int) ((tx - sx) * totalTime / REQIRED_TIME + sx);
      y = (int) ((ty - sy) * totalTime / REQIRED_TIME + sy);
      if (x == tx && y == ty) {
        puyo.hit(friendly);
        alive = false;
      }
    }

    void draw(Graphics g) {
      if (!alive)
        return;
      g.setColor(color);
      g.fillOval(x, y, DIA, DIA);
    }

  }

  private class Puyo extends GameEntity {
    static final long CHANGE_TIME = 1000;
    int x, y, width, height;
    Image currentImage, normalImage, goodImage, boringImage, noveltyImage, flustImage;
    State normal, good, boring, novelty, flust;
//    boolean hit = false;
    int greenCount = 0, redCount = 0;
    boolean goNovelty = false;
    State backFromNovelty;

    Puyo(int x, int y, int w, int h) {
      this.x = x;
      this.y = y;
      this.width = w;
      this.height = h;
      this.normalImage = new ImageIcon("contents/puyoNormal.png").getImage();
      this.goodImage = new ImageIcon("contents/puyoGood.png").getImage();
      this.boringImage = new ImageIcon("contents/puyoBoring.png").getImage();
      this.noveltyImage = new ImageIcon("contents/puyoNovelty.png").getImage();
      this.flustImage = new ImageIcon("contents/puyoFlust.png").getImage();
      normal = new Normal();
      good = new Good();
      boring = new Boring();
      novelty = new Novelty();
      flust = new Flust();
      changeState(normal);
    }

    void hit(boolean friendly) {
      if(friendly) {
        greenCount++;
        redCount = 0;
      } else {
        goNovelty = true;
        redCount++;
      }
    }

    public void draw(Graphics g) {
      g.drawImage(currentImage, x, y, x + width, y + height, 0, 0, width,
          height, null);
    }

    class Normal extends State {
      public void enter() {
        currentImage = normalImage;
      }

      public void execute(long elapsedTime) {
        if(goNovelty) {
          changeState(novelty);
          goNovelty = false;
          backFromNovelty = normal;
        } else if(greenCount >= 3) {
          greenCount = 0;
          changeState(good);
        }
      }
    }

    class Good extends State {
      public void enter() {
        currentImage = goodImage;
      }
      public void execute(long elapsedTime) {
        if(goNovelty) {
          changeState(novelty);
          goNovelty = false;
          backFromNovelty = good;
        } else if(greenCount >= 3) {
          greenCount = 0;
          changeState(boring);
        }
      }
    }

    class Boring extends State {
      public void enter() {
        currentImage = boringImage;
      }
      public void execute(long elapsedTime) {
        if(redCount > 0)
          changeState(normal);
      }
    }

    class Novelty extends State {
      int frameCounter;
      public void enter() {
        currentImage = noveltyImage;
        frameCounter = 20;
      }
      public void execute(long elapsedTime) {
        if(frameCounter < 0) {
          if(redCount >= 3)
            changeState(flust);
          else
            changeState(backFromNovelty);
        }
        frameCounter--;
      }
      public void exit() {
        greenCount = 0;
      }
    }

    class Flust extends State {
      public void enter() {
        currentImage = flustImage;
      }
      public void execute(long elapsedTime) {
        if(greenCount > 0)
          changeState(normal);
      }
    }

  }

  private class AnimationSequence {
    LinkedList<KeyFrame> keyFrames = new LinkedList<KeyFrame>();
    KeyFrame currentKeyFrame;
    Iterator<KeyFrame> iterator;
    int durationFrame;

    void add(Image image, int durationFrame) {
      keyFrames.add(new KeyFrame(image, durationFrame));
    }

    void init() {
      iterator = keyFrames.iterator();
      currentKeyFrame = iterator.next();
      durationFrame = currentKeyFrame.durationFrame;
    }

    Image next() {
      if(durationFrame <= 0) {
        if(!iterator.hasNext())
          return null;
        currentKeyFrame = iterator.next();
        durationFrame = currentKeyFrame.durationFrame;
      }
      durationFrame--;
      return currentKeyFrame.image;
    }

    class KeyFrame {
      Image image;
      int durationFrame;
      KeyFrame(Image img, int df) {
        image = img;
        durationFrame = df;
      }
    }

  }

  private class Beam extends GameEntity {

    int x;
    int headY, tailY;
    int topY;
    Color color;
    State moveHead, moveTail, wait;
    boolean alive;

    Beam() {
      moveHead = new State() {
        public void execute(long elapsedTime) {
          headY += Math.max(topY - headY, -MOVE_LIMIT * 2);
          if (headY == topY)
            changeState(moveTail);
        }

        public void draw(Graphics g) {
          drawLine(g);
        }
      };
      moveTail = new State() {
        public void execute(long elapsedTime) {
          tailY += Math.max(topY - tailY, -MOVE_LIMIT * 2);
          if (tailY == topY) {
            alive = false;
            changeState(wait);
          }
        }

        public void draw(Graphics g) {
          drawLine(g);
        }
      };
      wait = State.EmptyState;
      changeState(wait);
      alive = false;
    }

    void init(int x, int topY, int tailY, Color color) {
      this.x = x;
      this.headY = tailY;
      this.tailY = tailY;
      this.topY = topY;
      this.color = color;
      changeState(moveHead);
      alive = true;
    }

    void drawLine(Graphics g) {
      g.setColor(color);
      g.drawLine(x, headY, x, tailY);
    }

  }

  private class DoubleBeam extends GameEntity {

    int x;
    int headY, tailY;
    int topY, centerY;
    Color headColor, tailColor;
    State moveHeadToCenter, moveHeadToTop, moveTailToCenter, moveTailToTop,
        wait;
    boolean alive;

    DoubleBeam() {
      moveHeadToCenter = new State() {
        public void execute(long elapsedTime) {
          headY += Math.max(centerY - headY, -MOVE_LIMIT);
          if (headY == centerY)
            changeState(moveHeadToTop);
        }

        public void draw(Graphics g) {
          g.setColor(tailColor);
          g.drawLine(x, headY, x, tailY);
        }
      };
      moveHeadToTop = new State() {
        public void execute(long elapsedTime) {
          headY += Math.max(topY - headY, -MOVE_LIMIT);
          if (headY == topY)
            changeState(moveTailToCenter);
        }

        public void draw(Graphics g) {
          g.setColor(headColor);
          g.drawLine(x, headY, x, centerY);
          g.setColor(tailColor);
          g.drawLine(x, centerY, x, tailY);
        }
      };
      moveTailToCenter = new State() {
        public void execute(long elapsedTime) {
          tailY += Math.max(centerY - tailY, -MOVE_LIMIT);
          if (tailY == centerY)
            changeState(moveTailToTop);
        }

        public void draw(Graphics g) {
          g.setColor(headColor);
          g.drawLine(x, topY, x, centerY);
          g.setColor(tailColor);
          g.drawLine(x, centerY, x, tailY);
        }
      };
      moveTailToTop = new State() {
        public void execute(long elapsedTime) {
          tailY += Math.max(topY - tailY, -MOVE_LIMIT);
          if (tailY == topY) {
            alive = false;
            changeState(wait);
          }
        }

        public void draw(Graphics g) {
          g.setColor(headColor);
          g.drawLine(x, topY, x, tailY);
        }
      };
      wait = new State() {
        public void execute(long elapsedTime) {
        }
      };
      changeState(wait);
      alive = false;
    }

    void init(int x, int topY, int centerY, int tailY, Color headColor,
        Color tailColor) {
      this.x = x;
      this.topY = topY;
      this.centerY = centerY;
      this.headY = tailY;
      this.tailY = tailY;
      this.headColor = headColor;
      this.tailColor = tailColor;
      changeState(moveHeadToCenter);
      alive = true;
    }

  }

  private class NextPredictArrow extends GameEntity {

    static final int DEFAULT_WIDTH = 20;
    static final int DEFAULT_HEIGHT = 60;
    int x, y;
    int targetX;
    Color color = Color.RED;
    State aiming, recieveBeam, hitBeam;
    DoubleBeam doubleBeam;

    NextPredictArrow(int _y) {
      x = 0;
      this.y = _y;
      aiming = new State() {
        public void execute(long elapsedTime) {
          x += Math.min(Math.max(targetX - x, -MOVE_LIMIT), MOVE_LIMIT);
        }

        public void draw(Graphics g) {
          drawBody(g);
        }
      };
      recieveBeam = new State() {
        public void execute(long elapsedTime) {
          if (doubleBeam.headY < y + DEFAULT_HEIGHT / 2)
            changeState(hitBeam);
        }

        public void draw(Graphics g) {
          drawBody(g);
        }
      };
      hitBeam = new State() {
        int margin;
        int step;

        public void enter() {
          margin = 0;
          step = 1;
        }

        public void execute(long elapsedTime) {
          margin += step;
          if (margin > 10)
            step = -1;
          else if (margin <= 0)
            changeState(aiming);
        }

        public void draw(Graphics g) {
          g.setColor(color);
          g.fillRect(x - margin / 2, y - margin / 2, DEFAULT_WIDTH + margin,
              DEFAULT_HEIGHT + margin);
        }
      };
      changeState(aiming);
    }

    void prepareHitBeam(DoubleBeam beam) {
      x = targetX;
      doubleBeam = beam;
      changeState(recieveBeam);
    }

    void drawBody(Graphics g) {
      g.setColor(color);
      g.fillRect(x, y, DEFAULT_WIDTH, DEFAULT_HEIGHT);
    }

  }

  private class CountBar {
    int centerX, targetX, height = 10;
    int greenCount = 1, yellowCount;

    CountBar() {
      centerX = getWidth();
    }

    void update() {
      targetX = getWidth() * greenCount / (greenCount + yellowCount);
      centerX += Math.min(Math.max(targetX - centerX, -MOVE_LIMIT), MOVE_LIMIT);
    }

    void draw(Graphics g) {
      g.setColor(Color.GREEN);
      g.fillRect(0, 0, centerX, height);
      g.setColor(Color.YELLOW);
      g.fillRect(centerX, 0, getWidth(), height);
    }

  }

}
