package jp.crestmuse.cmx.inference.game;

import java.awt.Graphics;

public abstract class GameEntity {

  private State currentState = State.EmptyState;

  public void update(long elapsedTime) {
    currentState.execute(elapsedTime);
  }

  public void draw(Graphics g) {
    currentState.draw(g);
  }

  protected void changeState(State newState) {
    currentState.exit();
    currentState = newState;
    currentState.enter();
  }

}
