package jp.crestmuse.cmx.inference.game;

import java.awt.Color;

import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiSystem;
import javax.swing.JFrame;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;

import jp.crestmuse.cmx.amusaj.filewrappers.BayesNetWrapper;
import jp.crestmuse.cmx.amusaj.sp.MidiEventWithTicktime;
import jp.crestmuse.cmx.amusaj.sp.MidiInputModule;
import jp.crestmuse.cmx.amusaj.sp.MidiOutputModule;
import jp.crestmuse.cmx.amusaj.sp.SPExecutor;
import jp.crestmuse.cmx.amusaj.sp.SPSpreadModule;
import jp.crestmuse.cmx.inference.AccompanimentGenerator;
import jp.crestmuse.cmx.inference.BayesianCalculator;
import jp.crestmuse.cmx.inference.BayesianMapping;
import jp.crestmuse.cmx.inference.MelodyWriter;
import jp.crestmuse.cmx.inference.MusicRepresentation;
import jp.crestmuse.cmx.inference.NaiveVoicingCalculator;
import jp.crestmuse.cmx.inference.MusicRepresentation.MusicElement;
import jp.crestmuse.cmx.sound.SequencerManager;
import jp.crestmuse.cmx.sound.TickTimer;
import jp.crestmuse.cmx.sound.VirtualKeyboard;

public class GUI3 extends JFrame implements Runnable {

  public final int KEYBOARD_WIDTH = 100;
  public final int MOVE_LIMIT = 10;
  private MelodyPanel melodyPanel;
  private ChordPanel chordPanel;

  public GUI3(MusicRepresentation musicRepresentation, TickTimer tickTimer,
      double friendlyEntropyThreshold) {
    melodyPanel = new MelodyPanel(tickTimer, friendlyEntropyThreshold);
    chordPanel = new ChordPanel(musicRepresentation, tickTimer);
    musicRepresentation.addCalculator("melody", melodyPanel);

    // JPanel melodyBorder = new JPanel();
    // TitledBorder melodyTitle = new TitledBorder("melody");
    // melodyTitle.setTitleColor(Color.WHITE);
    // melodyBorder.setBorder(melodyTitle);
    // melodyBorder.add(melodyPanel);
    //
    // JPanel chordBorder = new JPanel();
    // TitledBorder chordTitle = new TitledBorder("chord");
    // chordTitle.setTitleColor(Color.WHITE);
    // chordBorder.setBorder(chordTitle);
    // chordBorder.add(chordPanel);
    JTabbedPane tab = new JTabbedPane();
    tab.addTab("melody", melodyPanel);
    tab.addTab("chord", chordPanel);

    setBackground(Color.BLACK);
    // setLayout(new FlowLayout());
    // add(melodyBorder);
    // add(chordBorder);
    add(tab);
    pack();

    Thread t = new Thread(this);
    t.start();
  }

  public void run() {
    long prevTime = 0, currentTime, elapsedTime;
    while (!Thread.interrupted()) {
      currentTime = System.currentTimeMillis();
      elapsedTime = currentTime - prevTime;
      prevTime = currentTime;
      melodyPanel.update(elapsedTime);
      chordPanel.update();
      // update ripples
      // for (Ripple r : ripples)
      // r.update();
      repaint();
      try {
        Thread.sleep(Math.max(0, currentTime + 33 - System.currentTimeMillis()));
      } catch (InterruptedException e) {
        break;
      }
    }
  }

  // @Override
  // public void paint(Graphics g) {
  // super.paint(g);
  //
  // // keyboard
  // g.setColor(Color.WHITE);
  // g.fillRect(0, 0, KEYBOARD_WIDTH, getHeight());
  // int whiteKeyHeight = (int) (getHeight() / 7.0);
  // boolean nextInWhite = isWhiteKey[nextNoteIndex];
  // if (nextInWhite) {
  // g.setColor(nextNoteColor);
  // g.fillRect(0, whiteKeyHeight * (6 - noteIndex2whiteKey[nextNoteIndex]),
  // KEYBOARD_WIDTH, whiteKeyHeight);
  // }
  // g.setColor(Color.BLACK);
  // g.drawLine(KEYBOARD_WIDTH, 0, KEYBOARD_WIDTH, getHeight());
  // for (int i = 0; i < 7; i++)
  // g.drawLine(0, whiteKeyHeight * i, KEYBOARD_WIDTH, whiteKeyHeight * i);
  // int blackKeyHeight = (int) (getHeight() / 12.0);
  // for (int i = 0; i < 12; i++)
  // if (!isWhiteKey[11 - i])
  // g.fillRect(0, blackKeyHeight * i, KEYBOARD_WIDTH * 2 / 3,
  // blackKeyHeight);
  // if (!nextInWhite) {
  // g.setColor(nextNoteColor);
  // g.fillRect(0, blackKeyHeight * (11 - nextNoteIndex),
  // KEYBOARD_WIDTH * 2 / 3, blackKeyHeight);
  // }
  //
  // // chord ball
  // g.setColor(Color.RED);
  // g.fillOval(currentX, currentY, whiteKeyHeight, whiteKeyHeight);
  //
  // // ripples
  // for (Ripple r : ripples)
  // r.draw(g);
  // }
  /*
   * public void update(MusicRepresentation musRep, MusicElement me, int index)
   * { // }
   * 
   * private class Ripple { int x, y, r; boolean circle; boolean alive; Color
   * color;
   * 
   * Ripple() { reset(0, 0, true); alive = false; }
   * 
   * void reset(int x, int y, boolean isCircle) { this.x = x; this.y = y; r = 0;
   * circle = isCircle; color = circle ? Color.GREEN : Color.RED; alive = true;
   * }
   * 
   * void update() { if (!alive) return; r += 5; if (r > getHeight()) alive =
   * false; }
   * 
   * void draw(Graphics g) { if (!alive) return; g.setColor(color); if (circle)
   * g.drawOval(x - r, y - r, r * 2, r * 2); else g.drawRect(x - r, y - r, r *
   * 2, r * 2); } }
   */
  public static void main(String[] args) {
    try {
      int measureLength = 8;
      String modelFile = "contents/model.bif";
      String firstChord = "C";
      int inputDeviceIndex = 0;
      int outputDeviceIndex = 1;
      String chordMIDIFile = "contents/C.mid";
      double friendlyEntropyThreshold = -1;
      if (args.length > 0) {
//        outputDeviceIndex = Integer.parseInt(args[0]);
        measureLength = Integer.parseInt(args[0]);
      }
      if (args.length > 1)
        friendlyEntropyThreshold = Double.parseDouble(args[1]);

      final MusicRepresentation mr = new MusicRepresentation(measureLength, 8);
      mr.addMusicLayer("melody", 12);
      mr.addMusicLayer("chord", new String[] { "C", "Dm", "Em", "F", "G", "Am",
          "Bm(b5)" }, 8);
      mr.addMusicLayer("bass", 128, 2);
      mr.addMusicLayer("voicingHigh", 128, 8);
      mr.addMusicLayer("voicingMidHigh", 128, 8);
      mr.addMusicLayer("voicingMidLow", 128, 8);
      mr.addMusicLayer("voicingLow", 128, 8);

      BayesianCalculator bc = new BayesianCalculator(new BayesNetWrapper(
          modelFile));
      bc.addReadMapping(new BayesianMapping("melody", -1,
          BayesianMapping.SET_ONLY, 0));
      bc.addReadMapping(new BayesianMapping("chord", -1,
          BayesianMapping.BY_TIED_LENGTH, 1));
      bc.addReadMapping(new BayesianMapping("melody", 0,
          BayesianMapping.NORMAL, 2));
      bc.addReadMapping(new BayesianMapping("chord", 0, BayesianMapping.NORMAL,
          3));
      bc.addWriteMapping(new BayesianMapping("melody", 1,
          BayesianMapping.NORMAL, 4));
      bc.addWriteMapping(new BayesianMapping("chord", 1,
          BayesianMapping.BY_TIED_LENGTH, 5));

      mr.addCalculator("melody", bc);
      mr.addCalculator("chord", new NaiveVoicingCalculator());
      MusicElement chord = mr.getMusicElement("chord", 0);
      chord.setProb(chord.indexOf(firstChord), 1.0);
      mr.update("chord", 0);

      SPExecutor sp = new SPExecutor();
//      MidiInputModule mi = new MidiInputModule(
//          MidiSystem.getMidiDevice(MidiSystem.getMidiDeviceInfo()[inputDeviceIndex]));
      final VirtualKeyboard vkb = new VirtualKeyboard();
      MidiInputModule mi = new MidiInputModule(vkb);
      MelodyWriter mw = new MelodyWriter(mr, false);
      MidiDevice device = MidiSystem.getMidiDevice(MidiSystem.getMidiDeviceInfo()[outputDeviceIndex]);
      device.open();
      MidiOutputModule mo = new MidiOutputModule(device.getReceiver());

      final SequencerManager sm = new SequencerManager(device.getReceiver());
      AccompanimentGenerator mrg = new AccompanimentGenerator(mr, chordMIDIFile);
      sm.addGeneratable(mrg);

      mi.setTickTimer(sm);
      SPSpreadModule towway = new SPSpreadModule(MidiEventWithTicktime.class, 2);
      sp.addSPModule(mi);
      sp.addSPModule(towway);
      sp.addSPModule(mo);
      sp.addSPModule(mw);
      sp.connect(mi, 0, towway, 0);
      sp.connect(towway, 0, mo, 0);
      sp.connect(towway, 1, mw, 0);

      final double fet = friendlyEntropyThreshold;
      SwingUtilities.invokeAndWait(new Runnable() {
        public void run() {
          GUI3 gui = new GUI3(mr, sm, fet);
          gui.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
          gui.setLocation(380, 0);
          gui.setVisible(true);
          vkb.setVisible(true);
        }
      });

      sp.start();
      sm.start();

      // 終了
      System.in.read();
      sm.stop();
      sp.stop();
      device.close();
    } catch (Exception e) {
      e.printStackTrace();
    }
    System.exit(0);
  }

}
