package jp.crestmuse.cmx.inference.game;


import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.lang.reflect.InvocationTargetException;
import java.util.LinkedList;
import java.util.Random;

import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class GUI0 extends JPanel implements Runnable, KeyListener {

  private Random random;
  private LinkedList<Star> stars;
  private Color[] rainbow = { Color.RED, Color.ORANGE, Color.YELLOW,
      Color.GREEN, Color.BLUE, new Color(35, 71, 148), new Color(167, 87, 168) };
  private Color backgroundTarget;
  private int colorLimit;
  private double elapsed;
  private static GUI0 instance;

  public static GUI0 getInstance() {
    if(instance == null) instance = new GUI0();
    return instance;
  }

  private GUI0() {
    setSize(1024, 512);
    setBackground(Color.BLACK);
    backgroundTarget = Color.BLACK;
    colorLimit = 5;
    random = new Random();
    stars = new LinkedList<Star>();
    Thread t = new Thread(this);
    t.start();
    JFrame frame = new JFrame();
    frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
    frame.setContentPane(this);
    frame.setSize(1024, 512);
    frame.addKeyListener(this);
    frame.setVisible(true);
  }

  public void run() {
    long prev = System.currentTimeMillis(), current;
    while (true) {
      current = System.currentTimeMillis();
      elapsed = (current - prev) / 1000.0;
      prev = current;
      try {
        update();
      } catch (Exception e1) {
        e1.printStackTrace();
        break;
      }
      repaint();
      try {
        Thread.sleep(10);
      } catch (InterruptedException e) {
        break;
      }
    }
  }

  private void update() throws InterruptedException, InvocationTargetException {
    SwingUtilities.invokeAndWait(new Runnable(){
      public void run() {
        Color back = getBackground();
        int r = back.getRed()
            + Math.max(Math.min(backgroundTarget.getRed() - back.getRed(),
                colorLimit), -colorLimit);
        int g = back.getGreen()
            + Math.max(Math.min(backgroundTarget.getGreen() - back.getGreen(),
                colorLimit), -colorLimit);
        int b = back.getBlue()
            + Math.max(Math.min(backgroundTarget.getBlue() - back.getBlue(),
                colorLimit), -colorLimit);
        setBackground(new Color(r, g, b));
        int i = 0;
        while (i < stars.size())
          if (stars.get(i).update(elapsed))
            i++;
          else
            stars.remove(i);
      }
    });
  }

  @Override
  public void paint(Graphics g) {
    super.paint(g);
    for (Star s : stars) s.paint(g);
    g.setColor(getBackground());
    g.fillOval(getWidth() / 2 - 50, getHeight() / 2 - 50, 100, 100);
  }

  public void keyPressed(KeyEvent e) {
  }

  public void keyReleased(KeyEvent e) {
    for (int i = 0; i < 100; i++)
      stars.add(new Star(rainbow[random.nextInt(7)]));
    backgroundTarget = rainbow[random.nextInt(7)].darker().darker();
  }

  public void keyTyped(KeyEvent e) {
  }

  public void keyPressed(final double[] probs) {
    SwingUtilities.invokeLater(new Runnable(){
      public void run() {
        for (int i = 0; i < 7; i++)
          for (int j = 0; j < probs[i] * 100; j++)
            stars.add(new Star(rainbow[i]));
      }
    });
  }

  public void changeMeasure(final int index) {
    SwingUtilities.invokeLater(new Runnable(){
      public void run() {
        backgroundTarget = rainbow[index].darker();
      }
    });
  }

  private class Star {
    double x, y, vx, vy, ax, ay, r;
    double startvx, startvy;
    Color color;
    int avelage = 750;
    int variance = 100;
    int centerx = getWidth() / 2;
    int centery = getHeight() / 2;

    Star(Color color) {
      x = centerx;
      y = centery;
      vx = random.nextDouble();
      vy = random.nextDouble();
      double mag = Math.sqrt(vx * vx + vy * vy);
      vx = (vx / mag) * (avelage + random.nextInt(variance))
          * (random.nextBoolean() ? 1 : -1);
      vy = (vy / mag) * (avelage + random.nextInt(variance))
          * (random.nextBoolean() ? 1 : -1);
      startvx = vx;
      startvy = vy;
      // まっすぐ返るver
      ax = -vx;
      ay = -vy;
      // まっすぐ返らないver
      //ax = -vx * (random.nextDouble() + 1);
      //ay = -vy * (random.nextDouble() + 1);
      // 飛んでいくver
      //ax = vx * 10;
      //ay = vy * 10;
      r = 10;
      this.color = color;
    }

    boolean update(double elapsed) {
      vx += ax * elapsed;
      vy += ay * elapsed;
      x += vx * elapsed;
      y += vy * elapsed;
      // トンネルモード
      r = ((centerx - x) * (centerx - x) + (centery - y) * (centery - y)) / 700;
      //r = 0;
      // 遠くまで飛んでいったら消えるver
      //if ((centerx - x) * (centerx - x) + (centery - y) * (centery - y) > getWidth()
      //    * getWidth())
      //  return false;
      // 円の中に戻ったら消えるver
      if(startvx * (x - centerx) < 0 || startvy * (y - centery) < 0)
        return false;
      return true;
    }

    void paint(Graphics g) {
      g.setColor(color);
      g.drawLine((int)x, (int)y, centerx, centery);
      g.fillOval((int)(x - r / 2), (int) (y - r / 2), (int) r, (int) r);
    }
  }

  public static void main(String[] args) {
    new GUI0();
  }

}
